<?php
/**
 * All Elementor widget init
 * @package goyto
 * @since 1.0.0
 */

if ( !defined('ABSPATH') ){
	exit(); // exit if access directly
}

if ( !class_exists('Goyto_Elementor_Widget_Init') ){

	class Goyto_Elementor_Widget_Init{
		/*
		* $instance
		* @since 1.0.0
		* */
		private static $instance;
		/*
		* construct()
		* @since 1.0.0
		* */
		public function __construct() {
			add_action( 'elementor/elements/categories_registered', array($this,'_widget_categories') );
			//elementor widget registered
			add_action('elementor/widgets/register',array($this,'_widget_registered'));
			add_action('elementor/editor/after_enqueue_styles',array($this,'editor_style'));
			add_action('elementor/documents/register_controls',array($this,'register_goyto_page_controls'));
			add_action('wp_enqueue_scripts', [$this, 'register_widget_styles']);
		}
		/*
	   * getInstance()
	   * @since 1.0.0
	   * */
		public static function getInstance(){
			if ( null == self::$instance ){
				self::$instance = new self();
			}
			return self::$instance;
		}
		/**
		 * _widget_categories()
		 * @since 1.0.0
		 * */
		public function _widget_categories($elements_manager){
			$elements_manager->add_category(
				'goyto_widgets',
				[
					'title' => __( 'goyto Addons', 'goyto-plugin' ),
					'icon' => 'fa fa-plug'
				]
			);
		}
		

		/**
		 * _widget_registered()
		 * @since 1.0.0
		 * */
		public function _widget_registered(){
			if( !class_exists('Elementor\Widget_Base') ){
				return;
			}
			$elementor_widgets = array(	
				
				// goyto Theme Widgets
				'header',
				'hero-section',
				'gallery',
				'heading',
				'button',
				'testimonial',
				'sponsor',
				'blog',
				'cta',
				'pricing-table',
				'feature-item',
				'advance-search',
				'feature-box',
				'app-button',
				'list-item',
				'about-img',
				'photo-slider',
				'feature-content',
				'counter',
				'favorite-section',
				'info-box',
				'booking-slider',
				'hero-two',
				'booking-banner',
				'video-gallery',
				'discount-banner',
				'why-choose-banner',
				'category',
				'hero-three',
				'parallax-banner',
				'working-process',
				'toure-place',
				'about-section',
				'footer',
				'slider',
				'newsletter',
				'animated-shape',
				'listing-banner',
				'toure',
				'toure-filter',
				'authore',
				'contact-faq',
				'social',
				'contact-info',
				'slider-two',
				'tour-details',
				'footer-content',
				'brand',
				'team',
				'destination',
				'video-popup'
			);

		
			$elementor_widgets = apply_filters('goyto_elementor_widget',$elementor_widgets);

			if ( is_array($elementor_widgets) && !empty($elementor_widgets) ) {
				foreach ( $elementor_widgets as $widget ){
					$widget_file = 'plugins/elementor/widget/'.$widget.'.php';
					$template_file = locate_template($widget_file);
					if ( !$template_file || !is_readable( $template_file ) ) {
						$template_file = GOYTO_DIR_PATH.'/elementor/widgets/'.$widget.'.php';
					}
					if ( $template_file && is_readable( $template_file ) ) {
						include_once $template_file;
					}
				}
			}

		}

		public function register_widget_styles(){
			wp_register_style('hero-banner-style', plugins_url('', __FILE__) . '/assets/css/hero-banner.css', array(), '1.0.0', 'all');
			wp_register_style('client', plugins_url('', __FILE__) . '/assets/css/client.css', array(), '1.0.0', 'all');
			wp_register_style('gallery', plugins_url('', __FILE__) . '/assets/css/gallery.css', array(), '1.0.0', 'all');
			wp_register_style('team', plugins_url('', __FILE__) . '/assets/css/team.css', array(), '1.0.0', 'all');
			wp_register_style('info', plugins_url('', __FILE__) . '/assets/css/info.css', array(), '1.0.0', 'all');
			wp_register_style('testimonial', plugins_url('', __FILE__) . '/assets/css/testimonial.css', array(), '1.0.0', 'all');
			wp_register_style('destination', plugins_url('', __FILE__) . '/assets/css/destination.css', array(), '1.0.0', 'all');
			wp_register_style('video', plugins_url('', __FILE__) . '/assets/css/video.css', array(), '1.0.0', 'all');
		}

		public function editor_style(){
			$cs_icon = plugins_url( 'icons.png', __FILE__ );
			wp_add_inline_style( 'elementor-editor', '.elementor-element .icon .goyto-custom-icon{content: url( '.$cs_icon.');width: 28px;}' );
		}

		/**
		 * Elemenotr Page Settings
		 *
		 * @param [type] $document
		 * @return void Elementor Page Settings
		 */
		public function register_goyto_page_controls( $document ) {

			if ( ! $document instanceof \Elementor\Core\DocumentTypes\PageBase || ! $document::get_property( 'has_elements' ) ) {
				return;
			}

			$document->start_controls_section(
				'body_goyto_style',
				[
					'label' => esc_html__( 'goyto Custom Body Style', 'goyto-plugin' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
			$document->add_control(
				'body_color',
				[
					'label' => esc_html__( 'Body Color', 'textdomain' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}}' => 'color: {{VALUE}}',
					],
				]
			);

			$document->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'label' => esc_html__( 'Page Body Font', 'textdomain' ),
					'name' => 'page_body_font',
					'selector' => '{{WRAPPER}}',
				]
			);
			
			$document->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'label' => esc_html__( 'Page Heading', 'textdomain' ),
					'name' => 'page_heading_font',
					'selector' => '{{WRAPPER}} h1, h2, h3, h4, h5, h6',
				]
			);
			$document->add_control(
				'h_color',
				[
					'label' => esc_html__( 'Heading Color', 'textdomain' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} h1, h2, h3, h4, h5, h6' => 'color: {{VALUE}}',
					],
				]
			);
			$document->add_group_control(
				\Elementor\Group_Control_Background::get_type(),
				[
					'name' => 'body_bg_color',
					'types' => [ 'classic' ],
					'exclude' => [ 'color' ],
					'selector' => '{{WRAPPER}} .body-bg-1',
					'fields_options' => [
						'background' => [
							'label' => esc_html__( 'Body Custom BG Image ', 'goyto-plugin' ),
							'description' => esc_html__( 'Choose background type and style.', 'goyto-plugin' ),
							'separator' => 'before',
						]
					]
				]
			);
			$document->end_controls_section();
		}


	}

	if ( class_exists('Goyto_Elementor_Widget_Init') ){
		Goyto_Elementor_Widget_Init::getInstance();
	}

}//end if