<?php

/**
 * Elementor Single Widget
 * @package goyto Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Goyto_About_Section extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'go-about-section';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'About Section', 'goyto-plugin' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'goyto-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'goyto_widgets' ];
	}


	protected function register_controls() {

        $this->start_controls_section(
			'int_widget_opt',
			[
				'label' => esc_html__( 'Feature Select', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'style',
			[
				'label' => esc_html__( 'Style', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'1'  => esc_html__( 'Style 1', 'goyto-plugin' ),
				]
			]
		);
        $this->end_controls_section();

        $this->start_controls_section(
			'int_img_section_opt',
			[
				'label' => esc_html__( 'Images', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'bg_image', [
				'label' => esc_html__( 'BG Image', 'goyto-plugin' ),
				'type' => Controls_Manager::MEDIA,
                'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
        $this->add_control(
			'image', [
				'label' => esc_html__( 'Image', 'goyto-plugin' ),
				'type' => Controls_Manager::MEDIA,
                'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
        $this->add_control(
			'image2', [
				'label' => esc_html__( 'Image 2', 'goyto-plugin' ),
				'type' => Controls_Manager::MEDIA,
                'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
        $this->add_control(
			'image3', [
				'label' => esc_html__( 'Image 3', 'goyto-plugin' ),
				'type' => Controls_Manager::MEDIA,
                'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
        $this->add_control(
			'image4', [
				'label' => esc_html__( 'Image 4', 'goyto-plugin' ),
				'type' => Controls_Manager::MEDIA,
                'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
        $this->end_controls_section();

        $this->start_controls_section(
			'int_heading_opt',
			[
				'label' => esc_html__( 'Heading Option', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'title_shape',
			[
				'label' => esc_html__( 'Title Shape Image', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
			]
		);
		
        $this->add_control(
			'subtitle', [
				'label' => esc_html__( 'Sub Title', 'goyto-plugin' ),
				'default' => esc_html__( 'Get To Know Us', 'goyto-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        
        $this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'goyto-plugin' ),
				'default' => esc_html__( 'Section Title', 'goyto-plugin' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		$this->add_control(
            'title_tag',
            [
                'label'   => __( 'Title HTML Tag', 'goyto-plugin' ),
                'type'    => Controls_Manager::CHOOSE,
                'options' => [
                    'h1' => [
                        'title' => __( 'H1', 'goyto-plugin' ),
                        'icon'  => 'eicon-editor-h1',
                    ],
                    'h2' => [
                        'title' => __( 'H2', 'goyto-plugin' ),
                        'icon'  => 'eicon-editor-h2',
                    ],
                    'h3' => [
                        'title' => __( 'H3', 'goyto-plugin' ),
                        'icon'  => 'eicon-editor-h3',
                    ],
                    'h4' => [
                        'title' => __( 'H4', 'goyto-plugin' ),
                        'icon'  => 'eicon-editor-h4',
                    ],
                    'h5' => [
                        'title' => __( 'H5', 'goyto-plugin' ),
                        'icon'  => 'eicon-editor-h5',
                    ],
                    'h6' => [
                        'title' => __( 'H6', 'goyto-plugin' ),
                        'icon'  => 'eicon-editor-h6',
                    ],
                ],
                'default' => 'h1',
                'toggle'  => false,
            ]
        );
        $this->add_control(
			'description', [
				'label' => esc_html__( 'Description', 'goyto-plugin' ),
				'type' => Controls_Manager::WYSIWYG,
                'label_block' => true,
			]
		);
		
		$this->end_controls_section();

        $this->start_controls_section(
			'--video-option--',
			[
				'label' => esc_html__( 'Video Option', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
       
        $this->add_control(
			'video_link', [
				'label' => esc_html__( 'Vido Link', 'gtbus-plugin' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
        $this->add_control(
			'video_bg', [
				'label' => esc_html__( 'Video BG', 'gtbus-plugin' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->end_controls_section();


        $this->start_controls_section(
			'feature_list_opt',
			[
				'label' => esc_html__( 'List Option', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'type',
            [
                'label'          => __( 'Icon Type', 'gesto-core' ),
                'type'           => Controls_Manager::CHOOSE,
                'label_block'    => false,
                'options'        => [
                    'icon'  => [
                        'title' => __( 'Icon', 'gesto-core' ),
                        'icon'  => 'far fa-smile',
                    ],
                    'image' => [
                        'title' => __( 'Image', 'gesto-core' ),
                        'icon'  => 'fa fa-image',
                    ],
                ],
                'default'        => 'icon',
                'toggle'         => false,
                'style_transfer' => true,
                
            ]
        );
        $repeater->add_control(
			'icon', [
				'label' => esc_html__( 'Icon', 'gesto-plugin' ),
				'type' => Controls_Manager::ICONS,
                'label_block' => true,
                'condition'      => [
                    'type' => 'icon',
                ],
			]
		);
        $repeater->add_control(
			'icon_img', [
				'label' => esc_html__( 'Icon Image', 'gesto-plugin' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
                'condition'      => [
                    'type' => 'image',
                ],
			]
		);
       
        $repeater->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'gtbus-plugin' ),
				'default' => esc_html__( 'Best of Hotel', 'gtbus-plugin' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
        $this->add_control(
			'lists',
			[
				'label' => esc_html__( 'Add List Item', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
			]
		);
		$this->end_controls_section();
        $this->start_controls_section(
			'int_btn_opt',
			[
				'label' => esc_html__( 'Button Option', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'button_bg_color',
				'types' => [ 'classic' ],
				'exclude' => [ 'color' ],
				'selector' => '{{WRAPPER}} .gt-btn-3 a:after',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__( 'Button Hover Icon', 'goyto-plugin' ),
                        'description' => esc_html__( 'Choose background type and style.', 'goyto-plugin' ),
                        'separator' => 'before',
                    ]
                ]
			]
		);
        $this->add_control(
			'btn_shape', [
				'label' => esc_html__( 'Button Icon', 'goyto-plugin' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
        $this->add_control(
			'btn_label', [
				'label' => esc_html__( 'Button Label', 'goyto-plugin' ),
				'default' => esc_html__( 'Goyto Button', 'goyto-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $this->add_control(
			'btn_link', [
				'label' => esc_html__( 'Button Link', 'goyto-plugin' ),
				'type' => Controls_Manager::URL,
                'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
					// 'custom_attributes' => '',
				],
				'label_block' => true,
			]
		);
		$this->end_controls_section();
        $this->start_controls_section(
			'post_sec_h_option',
			[
				'label' => esc_html__( 'Rating Option', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'rating_text',
			[
				'label' => esc_html__( 'Rating Text', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::TEXT,
			]
		);
        $this->add_control(
			'authore_gallery',
			[
				'label' => esc_html__( 'Authore Gallery', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::GALLERY,
			]
		);
		
		$this->end_controls_section();

		$this->start_controls_section(
			'section_on_off_setting',
			[
				'label' => esc_html__( 'Setting Option', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'sub_title_show',
			[
				'label' => esc_html__( 'Show Sub Title', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'goyto-plugin' ),
				'label_off' => esc_html__( 'Hide', 'goyto-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
        
        $this->add_control(
			'desc_show',
			[
				'label' => esc_html__( 'Show Description', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'goyto-plugin' ),
				'label_off' => esc_html__( 'Hide', 'goyto-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
        $this->add_control(
			'video_show',
			[
				'label' => esc_html__( 'Video Box Show', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'goyto-plugin' ),
				'label_off' => esc_html__( 'Hide', 'goyto-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
        $this->add_control(
			'list_show',
			[
				'label' => esc_html__( 'List Item Show', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'goyto-plugin' ),
				'label_off' => esc_html__( 'Hide', 'goyto-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
        $this->add_control(
			'btn_show',
			[
				'label' => esc_html__( 'Button Show', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'goyto-plugin' ),
				'label_off' => esc_html__( 'Hide', 'goyto-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
        $this->add_control(
			'authore_show',
			[
				'label' => esc_html__( 'Authore Show', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'goyto-plugin' ),
				'label_off' => esc_html__( 'Hide', 'goyto-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
       
		$this->end_controls_section();
        
        


	}


	protected function render() {
		$settings = $this->get_settings_for_display();

            $this->add_render_attribute( 'title', 'class', 'elementor-gt-heading section_title tx-split-text split-in-right' );
            if ( ! empty( $settings['btn_link']['url'] ) ) {
                $this->add_link_attributes( 'btn_link', $settings['btn_link'] );
            }
        ?>
        <section id="gt-about-4" class="gt-about-section-4" data-background="<?php echo esc_url($settings['bg_image']['url']);?>">
            <div class="gt-about-content-4  pt-125 pb-125 position-relative">
                <?php if(!empty($settings['image']['url'])):?>
                    <div class="gt-about-plane position-absolute wow slideInRight"  data-wow-delay="500ms" data-wow-duration="2500ms">
                        <img src="<?php echo esc_url($settings['image']['url']);?>" alt="<?php if(!empty($settings['image']['alt'])){ echo esc_url($settings['image']['alt']);}?>">
                    </div>
                <?php endif;?>
                <?php if(!empty($settings['image2']['url'])):?>
                    <div class="gt-about-support position-absolute wow zoomIn"  data-wow-delay="500ms" data-wow-duration="1500ms">
                        <img src="<?php echo esc_url($settings['image2']['url']);?>" alt="<?php if(!empty($settings['image2']['alt'])){ echo esc_url($settings['image2']['alt']);}?>">
                    </div>
                <?php endif;?>

                <?php if(!empty($settings['image3']['url'])):?>
                    <div class="gt-about-shape position-absolute txt_item_active">
                        <img src="<?php echo esc_url($settings['image3']['url']);?>" alt="<?php if(!empty($settings['image3']['alt'])){ echo esc_url($settings['image3']['alt']);}?>">
                    </div>
                <?php endif;?>
                <?php if(!empty($settings['image4']['url'])):?>
                    <div class="gt-about-img-4 txt_item_active position-absolute">
                        <div class="inner-img appear_right">
                            <img src="<?php echo esc_url($settings['image4']['url']);?>" alt="<?php if(!empty($settings['image4']['alt'])){ echo esc_url($settings['image4']['alt']);}?>">
                        </div>
                    </div>
                <?php endif;?>

                <div class="gt-about-text-4">
                    <div class="gt-section-title-2 headline pera-content txt-text-anim">
						<?php if($settings['sub_title_show'] === 'yes'):?>
                        <div class="subtitle d-inline-block cursive-font-2  text-uppercase wow fadeInRight"  data-wow-delay="300ms" data-wow-duration="1000ms">
                            <?php if(!empty($settings['title_shape']['url'])):?>
                                <img src="<?php echo esc_url($settings['title_shape']['url']);?>" alt="<?php if(!empty($settings['title_shape']['alt'])){ echo esc_attr($settings['title_shape']['alt']);}?>"> 
                            <?php endif;?>  
                            <span><?php echo wp_kses($settings['subtitle'], true);?></span>
                            <?php if(!empty($settings['title_shape']['url'])):?>
                                <img src="<?php echo esc_url($settings['title_shape']['url']);?>" alt="<?php if(!empty($settings['title_shape']['alt'])){ echo esc_attr($settings['title_shape']['alt']);}?>"> 
                            <?php endif;?>  
                        </div>
						<?php endif;?>
                        <?php printf('<%1$s %2$s>%3$s</%1$s>',
                            tag_escape($settings['title_tag']),
                            $this->get_render_attribute_string('title'),
                            $settings['title']
                        ); ?>
                        <?php if($settings['desc_show'] === 'yes'):?>
                            <div class="elementor-gt-desc">
                                <?php echo wpautop($settings['description']);?>
                            </div>
                        <?php endif;?>
                    </div>
                    <div class="gt-about-video-list mt-30 d-flex flex-wrap align-items-center">
						<?php if($settings['video_show'] === 'yes'):?>
							<div class="about-video position-relative wow fadeInRight"  data-wow-delay="300ms" data-wow-duration="1000ms">
								<?php if(!empty($settings['video_bg']['url'])):?>
								<div class="inner-img">
									<img src="<?php echo esc_url($settings['video_bg']['url']);?>" alt="<?php if(!empty($settings['video_bg']['alt'])){ echo esc_attr($settings['video_bg']['alt']);} ?>">
								</div>
								<?php endif;?>
								<?php if(!empty($settings['video_link']['url'])):?>
									<a class="video_box d-flex align-items-center justify-content-center position-absolute" href="<?php echo esc_url($settings['video_link']['url']);?>">
										<i class="fas fa-play"></i>
										<span class="video_btn_border border_wrap-1"></span>
										<span class="video_btn_border border_wrap-2"></span>
										<span class="video_btn_border border_wrap-3"></span>
									</a>
								<?php endif;?>
							</div>
						<?php endif;?>
						<?php if($settings['list_show'] === 'yes'):?>
                        <div class="about-list-area ul-li-block wow fadeInLeft"  data-wow-delay="300ms" data-wow-duration="1000ms">
                            <ul>
								<?php foreach($settings['lists'] as $item):?>
									<li>
										<?php if ($item['type'] === 'image' && ($item['icon_img']['url'])) :?>
											<img src="<?php echo esc_url($item['icon_img']['url']);?>" alt="<?php if(!empty($item['icon_img']['alt'])){ echo esc_attr($item['icon_img']['alt']);}else{esc_attr_e('List', 'goyto-plugin');}?>">
										<?php else:?>
											<?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
										<?php endif;?>
										<?php echo wp_kses($item['title'], true);?>
									</li>
								<?php endforeach;?>
                            </ul>
                        </div>
						<?php endif;?>
                    </div>
                    <div class="gt-about-btn-grp-4 mt-45 d-flex align-items-center flex-wrap wow fadeInUp"  data-wow-delay="300ms" data-wow-duration="1000ms">
						<?php if(!empty($settings['btn_label']) || $settings['btn_show'] === 'yes' ):?>
                        <div class="gt-btn-3 text-uppercase">
                            <a <?php echo $this->get_render_attribute_string( 'btn_link' ); ?>><?php echo wp_kses($settings['btn_label'], true);?> 
								<?php if(!empty($settings['btn_shape']['url'])):?>
									<img src="<?php echo esc_url($settings['btn_shape']['url']);?>" alt="<?php echo esc_attr($settings['btn_shape']['url']);?>">
								<?php endif;?>
							</a>
                        </div>
						<?php endif;?>
						<?php if($settings['authore_show'] === 'yes'):?>
                        <div class="gt-client-list d-flex align-items-center flex-wrap ul-li">
                            <ul>
								<?php foreach($settings['authore_gallery'] as $item):?>
                                	<li><img src="<?php echo esc_url($item['url']);?>" alt="<?php if(!empty($item['alt'])){ echo esc_attr($item['url']);}?>"></li>
								<?php endforeach;?>
                            </ul>
							<?php if(!empty($settings['rating_text'])):?>
                            	<div class="client-number-text"><?php echo wp_kses($settings['rating_text'], true);?></div>
							<?php endif;?>
                        </div>
						<?php endif;?>
                    </div>
                </div>
            </div>
        </section>
    <?php
    }


}


Plugin::instance()->widgets_manager->register( new Goyto_About_Section() );