<?php

/**
 * Elementor Single Widget
 * @package goyto Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Goyto_Advance_Search extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'go-adv-search';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Advance Search', 'goyto-plugin' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'goyto-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'goyto_widgets' ];
	}


	protected function register_controls() {

        $this->start_controls_section(
			'int_widget_opt',
			[
				'label' => esc_html__( 'Search Style', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'style',
			[
				'label' => esc_html__( 'Style', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'1'  => esc_html__( 'Style 1', 'goyto-plugin' ),
				]
			]
		);
        $this->end_controls_section();

        $this->start_controls_section(
			'int_heading_opt',
			[
				'label' => esc_html__( 'Search Option Option', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'more_options',
			[
				'label' => esc_html__( 'Location Option', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        $this->add_control(
			'location_label', [
				'label' => esc_html__( 'Location Label', 'goyto-plugin' ),
				'default' => esc_html__( 'Location', 'goyto-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $this->add_control(
			'l_d_value', [
				'label' => esc_html__( 'Location Option Default Value', 'goyto-plugin' ),
				'default' => esc_html__( 'Where To Next?', 'goyto-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $this->add_control(
			'l_icon', [
				'label' => esc_html__( 'Location Icon', 'goyto-plugin' ),
				'type' => Controls_Manager::ICONS,
                'label_block' => true,
			]
		);
        $this->add_control(
			'activity_options',
			[
				'label' => esc_html__( 'Activity Option', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        $this->add_control(
			'activity_label', [
				'label' => esc_html__( 'Activity Label', 'goyto-plugin' ),
				'default' => esc_html__( 'Activity', 'goyto-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $this->add_control(
			'a_d_value', [
				'label' => esc_html__( 'Activity Default Value', 'goyto-plugin' ),
				'default' => esc_html__( 'Select Activity', 'goyto-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $this->add_control(
			'a_icon', [
				'label' => esc_html__( 'Activity Icon', 'goyto-plugin' ),
				'type' => Controls_Manager::ICONS,
                'label_block' => true,
			]
		);
        $this->add_control(
			'type_options',
			[
				'label' => esc_html__( 'Type Option', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        $this->add_control(
			'type_label', [
				'label' => esc_html__( 'Type Label', 'goyto-plugin' ),
				'default' => esc_html__( 'Tour Type', 'goyto-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $this->add_control(
			't_d_value', [
				'label' => esc_html__( 'Type Default Value', 'goyto-plugin' ),
				'default' => esc_html__( 'Select Type', 'goyto-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $this->add_control(
			't_icon', [
				'label' => esc_html__( 'Location Icon', 'goyto-plugin' ),
				'type' => Controls_Manager::ICONS,
                'label_block' => true,
			]
		);
		
		$this->end_controls_section();

	}


	protected function render() {
		$settings = $this->get_settings_for_display();
        if ( ! empty( $settings['website_link']['url'] ) ) {
			$this->add_link_attributes( 'website_link', $settings['website_link'] );
		}
        ?>
		<div class="gt-booking-search-content wow fadeInUp"  data-wow-delay="300ms" data-wow-duration="1000ms">
			<form action="<?php echo esc_url( wp_travel_engine_get_page_permalink( 'search' ) ); ?>">
				<div class="gt-booking-option d-flex align-items-center justify-content-between">
					<div class="option_action position-relative headline">
						<?php if(!empty($settings['location_label'])):?>
							<h3><?php echo wp_kses($settings['location_label'], true)?></h3>
						<?php endif;?>
						<div class="action-icon d-flex align-items-center justify-content-center position-absolute"><?php \Elementor\Icons_Manager::render_icon( $settings['l_icon'], [ 'aria-hidden' => 'true' ] ); ?></div>
						<select name="destination">
						<?php if(!empty($settings['l_d_value'])):?>
							<option value=""><?php echo wp_kses($settings['l_d_value'], true)?></option>
						<?php endif;?>
							<?php
								// Get all terms from the "destination" taxonomy
								$terms = get_terms( array(
									'taxonomy' => 'destination',
									'hide_empty' => false,
								) );

								// Loop through each term and create an option for the select dropdown
								foreach ( $terms as $term ) {
									echo '<option value="' . $term->slug . '">' . $term->name . '</option>';
								}
							?>
						</select>
					</div>
					<div class="option_action position-relative headline">
						<?php if(!empty($settings['activity_label'])):?>
							<h3><?php echo wp_kses($settings['activity_label'], true)?></h3>
						<?php endif;?>
						<div class="action-icon d-flex align-items-center justify-content-center position-absolute"><?php \Elementor\Icons_Manager::render_icon( $settings['a_icon'], [ 'aria-hidden' => 'true' ] ); ?></div>
						<select name="activities">
							<?php if(!empty($settings['a_d_value'])):?>
								<option value=""><?php echo wp_kses($settings['a_d_value'], true)?></option>
							<?php endif;?>
							<?php
								// Get all terms from the "destination" taxonomy
								$terms = get_terms( array(
									'taxonomy' => 'activities',
									'hide_empty' => false,
								) );

								// Loop through each term and create an option for the select dropdown
								foreach ( $terms as $term ) {
									echo '<option value="' . $term->slug . '">' . $term->name . '</option>';
								}
							?>
						</select>
					</div>
					<div class="option_action position-relative headline">
						<?php if(!empty($settings['type_label'])):?>
							<h3><?php echo wp_kses($settings['type_label'], true)?></h3>
						<?php endif;?>
						<div class="action-icon d-flex align-items-center justify-content-center position-absolute"><?php \Elementor\Icons_Manager::render_icon( $settings['t_icon'], [ 'aria-hidden' => 'true' ] ); ?></div>
						<select name="trip_types">
							<?php if(!empty($settings['t_d_value'])):?>
								<option value=""><?php echo wp_kses($settings['t_d_value'], true)?></option>
							<?php endif;?>
							<?php
								// Get all terms from the "destination" taxonomy
								$terms = get_terms( array(
									'taxonomy' => 'trip_types',
									'hide_empty' => false,
								) );

								// Loop through each term and create an option for the select dropdown
								foreach ( $terms as $term ) {
									echo '<option value="' . $term->slug . '">' . $term->name . '</option>';
								}
							?>
						</select>
					</div>
					<div class="submit-btn">
						<button type="submit"><i class="far fa-search"></i></button>
					</div>
				</div>
			</form>
		</div>
		<?php
    }


}


Plugin::instance()->widgets_manager->register( new Goyto_Advance_Search() );