<?php

/**
 * Elementor Single Widget
 * @package goyto Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Goyto_Animated_Shape extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'go-animated-shape';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Goyto Animated Shape', 'goyto-plugin' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'goyto-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'goyto_widgets' ];
	}


	protected function register_controls() {

        $this->start_controls_section(
			'int_widget_opt',
			[
				'label' => esc_html__( 'Shape Image Select', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'shape_img', [
				'label' => esc_html__( 'Shape Image', 'goyto-plugin' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
        $this->add_control(
			'anim_class', [
				'label' => esc_html__( 'Shape Animation Class', 'goyto-plugin' ),
				'description' => esc_html__( 'Use This Class "appear_left" for left animation and use this class "appear_right" for right animation', 'goyto-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $this->add_responsive_control(
			'shape_position_top',
			[
				'label' => esc_html__( 'Top Position', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .gt-blog-shape1' => 'top: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_responsive_control(
			'shape_position_bottom',
			[
				'label' => esc_html__( 'Bottom Position', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .gt-blog-shape1' => 'bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_responsive_control(
			'shape_position_left',
			[
				'label' => esc_html__( 'Left Position', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .gt-blog-shape1' => 'left: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_responsive_control(
			'shape_position_right',
			[
				'label' => esc_html__( 'Right Position', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .gt-blog-shape1' => 'right: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->end_controls_section();


	}


	protected function render() {
	$settings = $this->get_settings_for_display();?>
        <span class="gt-blog-shape1 position-absolute <?php if(!empty($settings['anim_class'])){ echo esc_attr($settings['anim_class']);}?>">
            <img src="<?php echo esc_url($settings['shape_img']['url']);?>" alt="<?php if(!empty($settings['shape_img']['alt'])){ echo esc_attr($settings['shape_img']['alt']);}?>">
        </span>
    <?php
        
    }


}


Plugin::instance()->widgets_manager->register( new Goyto_Animated_Shape() );