<?php

/**
 * Elementor Single Widget
 * @package goyto Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Goyto_Blog extends Widget_Base {



	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'goyto-post-grid';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Goyto Blog Post', 'goyto-plugin' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'goyto-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'goyto_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'int_layout_opt',
			[
				'label' => esc_html__( 'Blog Layout Option', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'style',
			[
				'label' => esc_html__( 'Style', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'1'  => esc_html__( 'Style 1', 'goyto-plugin' ),
					'2'  => esc_html__( 'Style 2', 'goyto-plugin' ),
					'3'  => esc_html__( 'Style 3', 'goyto-plugin' ),
					'4'  => esc_html__( 'Style 4', 'goyto-plugin' ),
					'5'  => esc_html__( 'Style 5', 'goyto-plugin' ),
					'6'  => esc_html__( 'Style 6', 'goyto-plugin' ),
					'7'  => esc_html__( 'Style 7', 'goyto-plugin' )
				]
			]
		);
		$this->add_control(
			'description',
			[
				'label' => esc_html__( 'Description', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
				'placeholder' => esc_html__( 'Type your description here', 'goyto-plugin' ),
				'condition' => [
					'style' => ['2', '4', '5'],
				],
			]
		);

        	
		$this->end_controls_section();

        $this->start_controls_section(
			'post_sec_h_option',
			[
				'label' => esc_html__( 'Post Option', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'post_order',
			[
				'label'     => esc_html__( 'Post Order', 'goyto-plugin' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'ASC',
				'options'   => [
					'ASC'  => esc_html__( 'Ascending', 'goyto-plugin' ),
					'DESC' => esc_html__( 'Descending', 'goyto-plugin' ),
				],
			]
		);
		
		$this->add_control(
			'post_per_page',
			[
				'label'   => __( 'Posts Per Page', 'goyto-plugin' ),
				'type'    => Controls_Manager::NUMBER,
				'min'     => 1,
				'default' => 5,
			]
		);
        $this->add_control(
			'post_categories',
			[
				'type'        => Controls_Manager::SELECT2,
				'label'       => esc_html__( 'Select Categories', 'goyto-plugin' ),
				'options'     => Goyto_Blog_category(),
				'label_block' => true,
				'multiple'    => true,
			]
		);
		$this->add_control(
			'title_length',
			[
				'label'     => __( 'Title Length', 'goyto-tools' ),
				'type'      => Controls_Manager::NUMBER,
				'step'      => 1,
				'default'   => 20,
			]
		);
		$this->add_control(
			'excerpt_length',
			[
				'label'     => __( 'Excerpt Length', 'goyto-tools' ),
				'type'      => Controls_Manager::NUMBER,
				'step'      => 1,
				'default'   => 20,
			]
		);
        $this->add_control(
			'button_label', [
				'label' => esc_html__( 'Readmore Button', 'goyto-plugin' ),
				'default' => esc_html__( 'Read more', 'goyto-plugin' ),
				'type' => Controls_Manager::TEXT,
			]
		);
		

		$this->end_controls_section();
        $this->start_controls_section(
			'blog_style',
			[
				'label' => esc_html__( 'Blog Style', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
        
        $this->add_control(
			'post_title',
			[
				'label' => esc_html__( 'Post Title Style', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        $this->add_control(
			'post_list_title_color',
			[
				'label' => esc_html__( 'Post Title Color', 'goyto-plugin' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-blog-item .blog-text .blog_title' => 'color: {{VALUE}}'
				],
			]
		);
       
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'post_title_typography',
				'selector' => '
					{{WRAPPER}} .gt-blog-item .blog-text .blog_title
				',
			]
		);
        
        $this->add_control(
			'post_date_title',
			[
				'label' => esc_html__( 'Post Date Style', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        
        $this->add_control(
			'post_date_bg_color',
			[
				'label' => esc_html__( 'Post Date Color', 'goyto-plugin' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-blog-item .blog-text .blog-meta' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'post_date_typography',
				'selector' => '
					{{WRAPPER}} .gt-blog-item .blog-text .blog-meta
				',
			]
		);
		
        $this->add_control(
			'post_desc_title',
			[
				'label' => esc_html__( 'Post Description Style', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        $this->add_control(
			'post_desc_color',
			[
				'label' => esc_html__( 'Post Description Color', 'goyto-plugin' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .pera-content p' => 'color: {{VALUE}}'
				],
			]
		);
        
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'post_desc_typography',
				'selector' => '
				{{WRAPPER}} .pera-content p
				',
			]
		);
        $this->add_control(
			'post_authore_title',
			[
				'label' => esc_html__( 'Post Authore Style', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        $this->add_control(
			'post_authore_color',
			[
				'label' => esc_html__( 'Post Authore Color', 'goyto-plugin' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-blog-item .blog-author .inner-text' => 'color: {{VALUE}}'
				],
			]
		);
        
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'post_authore_typography',
				'selector' => '
				{{WRAPPER}} .gt-blog-item .blog-author .inner-text
				',
			]
		);
        
		$this->end_controls_section();
        
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	

        $args = array(
			'post_type'           => 'post',
			'posts_per_page'      => !empty( $settings['post_per_page'] ) ? $settings['post_per_page'] : 1,
			'post_status'         => 'publish',
			'ignore_sticky_posts' => 1,
			'order'               => $settings['post_order'],
		);
		if( ! empty($settings['post_categories'] ) ){
			$args['category_name'] = implode(',', $settings['post_categories']);
		}
		
		$query = new \WP_Query( $args );
        require __DIR__ . '/view/blog/blog-' . $settings['style'] . '.php';
    }
    protected function goyto_category_name(){
        $catgorys = get_the_category();
    
        // Shuffle the array of categories
        shuffle($catgorys);
    
        // Select a random category
        $random_category = array_rand($catgorys, 1);
        $category = $catgorys[$random_category];
    
        $meta = get_term_meta($category->term_id, 'barfii_cate_meta', true);
        $catemeta = !empty( $meta['cate-color'] )? $meta['cate-color'] : '#3b60fe';
        ?>
        <a href="<?php echo esc_url(get_category_link($category->term_id)); ?>">
            <span><?php echo esc_html($category->cat_name); ?></span> 
        </a>
    <?php
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Goyto_Blog() );