<?php

/**
 * Elementor Single Widget
 * @package goyto Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Goyto_Category extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'go-category';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Destination Category', 'goyto-plugin' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'goyto-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'goyto_widgets' ];
	}


	protected function register_controls() {

        $this->start_controls_section(
			'int_main_section_opt',
			[
				'label' => esc_html__( 'Features Option', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        
        $this->add_control(
			'animation_delay', [
				'label' => esc_html__( 'Animation Delay', 'gesto-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $this->add_control(
			'category_img', [
				'label' => esc_html__( 'Category Image', 'gesto-plugin' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
       
        $this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'gtbus-plugin' ),
				'default' => esc_html__( 'Marhattan', 'gtbus-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $this->add_control(
			'count', [
				'label' => esc_html__( 'Count', 'gtbus-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $this->add_control(
			'link', [
				'label' => esc_html__( 'Link', 'gtbus-plugin' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
		$this->end_controls_section();
        
        


	}


	protected function render() {
	$settings = $this->get_settings_for_display();?>
        <div class="gt-fvt-place-item text-center headline wow fadeInUp" <?php if(!empty($settings['animation_delay'])):?> data-wow-delay="<?php echo esc_attr($settings['animation_delay']);?>ms" data-wow-duration="1200ms" <?php endif;?>>
            <div class="fvt-place-img text-center position-relative">
                <?php if(!empty($settings['category_img']['url'])):?>
                    <div class="inner-img">
                        <img src="<?php echo esc_url($settings['category_img']['url']);?>" alt="<?php if(!empty($settings['category_img']['alt'])){ echo esc_attr($settings['category_img']['alt']);} ?>">
                    </div>
                <?php endif;?>
                <?php if(!empty($settings['count'])):?>
                    <div class="tour-count text-capitalize">
                        <span><?php echo esc_html($settings['count']);?></span>
                    </div>
                <?php endif;?>
            </div>
            <?php if(!empty($settings['title'])):?>
                <h3 class="fvt_title"><a href="<?php echo esc_url($settings['link']['url']);?>"><?php echo esc_html($settings['title']);?></a></h3>
            <?php endif;?>
        </div>
    <?php
    }


}


Plugin::instance()->widgets_manager->register( new Goyto_Category() );