<?php

/**
 * Elementor Single Widget
 * @package goyto Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Goyto_Feature_Box extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'go-feature-box';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Feature Box', 'goyto-plugin' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'goyto-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'goyto_widgets' ];
	}


	protected function register_controls() {

        $this->start_controls_section(
			'int_widget_opt',
			[
				'label' => esc_html__( 'Feature Select', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'style',
			[
				'label' => esc_html__( 'Style', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'1'  => esc_html__( 'Style 1', 'goyto-plugin' ),
				]
			]
		);
        $this->end_controls_section();

        $this->start_controls_section(
			'int_main_section_opt',
			[
				'label' => esc_html__( 'Features Option', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
			'icon_img', [
				'label' => esc_html__( 'Image', 'gesto-plugin' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
       
        $repeater->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'gtbus-plugin' ),
				'default' => esc_html__( 'Africa', 'gtbus-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'custom_clas', [
				'label' => esc_html__( 'Custom Class', 'gtbus-plugin' ),
				'type' => Controls_Manager::TEXT,
			]
		);

        $this->add_control(
			'countrys',
			[
				'label' => esc_html__( 'Add Item', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
			]
		);
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
			'icon_img', [
				'label' => esc_html__( 'Image', 'gesto-plugin' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
       
        $repeater->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'gtbus-plugin' ),
				'default' => esc_html__( 'Africa', 'gtbus-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'custom_clas', [
				'label' => esc_html__( 'Custom Class', 'gtbus-plugin' ),
				'type' => Controls_Manager::TEXT,
			]
		);

        $this->add_control(
			'countrys2',
			[
				'label' => esc_html__( 'Add Item', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
			]
		);
		$this->end_controls_section();
        
        


	}


	protected function render() {
		$settings = $this->get_settings_for_display();
        require __DIR__ . '/view/feature-box/feature-' . $settings['style'] . '.php';
    }


}


Plugin::instance()->widgets_manager->register( new Goyto_Feature_Box() );