<?php

/**
 * Elementor Single Widget
 * @package goyto Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Goyto_Footer_Content extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'go-footer-content';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Footer Content', 'goyto-plugin' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'goyto-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'goyto_widgets' ];
	}


	protected function register_controls() {

        $this->start_controls_section(
			'int_widget_opt',
			[
				'label' => esc_html__( 'Footer Style Select', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'style',
			[
				'label' => esc_html__( 'Style', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'1'  => esc_html__( 'Style 1', 'goyto-plugin' ),
					'2'  => esc_html__( 'Style 2', 'goyto-plugin' ),
				]
			]
		);
        $this->end_controls_section();

        $this->start_controls_section(
			'int_heading_opt',
			[
				'label' => esc_html__( 'Footer Newsletter Option', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        
        $this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'goyto-plugin' ),
				'default' => esc_html__( 'Section Title', 'goyto-plugin' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
        

        $this->add_control(
			'newsletter_shortcode', [
				'label' => esc_html__( 'Footer Newsletter Shortcode', 'goyto-plugin' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
				'condition' => [
					'style' => '1',
				],
			]
		);
        
		$this->end_controls_section();
        $this->start_controls_section(
			'footer__about',
			[
				'label' => esc_html__( 'Footer Info Option', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        
        $this->add_control(
			'footer_gallery', [
				'label' => esc_html__( 'Footer Gallery', 'goyto-plugin' ),
				'type' => Controls_Manager::GALLERY,
				'condition' => [
					'style' => '1',
				],
			]
		);
       

        $repeater = new \Elementor\Repeater();
       
        $repeater->add_control(
			'icon', [
				'label' => esc_html__( 'Icon', 'gtbus-plugin' ),
				'type' => Controls_Manager::ICONS,
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'gtbus-plugin' ),
				'type' => Controls_Manager::TEXT,
			]
		);

        $repeater->add_control(
			'text', [
				'label' => esc_html__( 'Text', 'goyto-plugin' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'link', [
				'label' => esc_html__( 'Link', 'gtbus-plugin' ),
				'type' => Controls_Manager::URL,
			]
		);

        $this->add_control(
			'infos',
			[
				'label' => esc_html__( 'Add Info Item', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
			]
		);
        
		$this->end_controls_section();
        
	}


	protected function render() {
		$settings = $this->get_settings_for_display();
        require __DIR__ . '/view/footer-content/footer-' . $settings['style'] . '.php';
    }


}


Plugin::instance()->widgets_manager->register( new Goyto_Footer_Content() );