<?php

/**
 * Elementor Single Widget
 * @package goyto Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Goyto_Gallery extends Widget_Base {

	/**
	 * Slider Style Dependency
	 *
	 * @return void
	 */
	public function get_style_depends()
	{
		return ['gallery'];
	}

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'go-gallery';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Gallery', 'goyto-plugin' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'goyto-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'goyto_widgets' ];
	}


	protected function register_controls() {

        $this->start_controls_section(
			'int_widget_opt',
			[
				'label' => esc_html__( 'Gallery Style Select', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'style',
			[
				'label' => esc_html__( 'Style', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'1'  => esc_html__( 'Style 1', 'goyto-plugin' ),
					'2'  => esc_html__( 'Style 2', 'goyto-plugin' ),
					'3'  => esc_html__( 'Style 3', 'goyto-plugin' ),
					'4'  => esc_html__( 'Style 4', 'goyto-plugin' )
				]
			]
		);
        $this->end_controls_section();

        $this->start_controls_section(
			'int_main_section_opt',
			[
				'label' => esc_html__( 'Gallery Option', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'layout',
			[
				'label' => esc_html__( 'Layout', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'1'  => esc_html__( 'Style 1', 'goyto-plugin' ),
					'2'  => esc_html__( 'Style 2', 'goyto-plugin' ),
					'3'  => esc_html__( 'Style 3', 'goyto-plugin' ),
					'4'  => esc_html__( 'Style 4', 'goyto-plugin' ),
				]
			]
		);
		$repeater->add_control(
			'grid_size', [
				'label' => esc_html__( 'Grid Size', 'goyto-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
				'condition' => [
					'layout' => '2',
				],
			]
		);
        $repeater->add_control(
			'icon', [
				'label' => esc_html__( 'Gallery Icon', 'goyto-plugin' ),
				'type' => Controls_Manager::MEDIA,
				'condition' => [
					'layout!' => '4',
				],
			]
		);
        $repeater->add_control(
			'gallery', [
				'label' => esc_html__( 'Gallery', 'goyto-plugin' ),
				'type' => Controls_Manager::MEDIA,
                'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

        $this->add_control(
			'gallerys',
			[
				'label' => esc_html__( 'Add gallerys Item', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
			]
		);
		$this->end_controls_section();
        
        


	}


	protected function render() {
		$settings = $this->get_settings_for_display();
        require __DIR__ . '/view/gallery/gallery-' . $settings['style'] . '.php';
    }


}


Plugin::instance()->widgets_manager->register( new Goyto_Gallery() );