<?php

/**
 * Elementor Single Widget
 * @package goyto Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Goyto_Hero_Three extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'go-hero-three';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Hero Three', 'goyto-plugin' );
	}
    
	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'goyto-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'goyto_widgets' ];
	}


	protected function register_controls() {

        $this->start_controls_section(
			'int_search_opt',
			[
				'label' => esc_html__( 'Hero Search Option', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'img_1', [
				'label' => esc_html__( 'Hero Image 1', 'goyto-plugin' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
        $this->add_control(
			'img_2', [
				'label' => esc_html__( 'Hero Image 2', 'goyto-plugin' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
        $this->add_control(
			'img_3', [
				'label' => esc_html__( 'Hero Image 3', 'goyto-plugin' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->end_controls_section();
        $this->start_controls_section(
			'int_heading_opt',
			[
				'label' => esc_html__( 'Heading Option', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'title_shape',
			[
				'label' => esc_html__( 'Title Shape Image', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
			]
		);
		
        $this->add_control(
			'subtitle', [
				'label' => esc_html__( 'Sub Title', 'goyto-plugin' ),
				'default' => esc_html__( 'Get To Know Us', 'goyto-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        
        $this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'goyto-plugin' ),
				'default' => esc_html__( 'Section Title', 'goyto-plugin' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		
        $this->add_control(
			'description', [
				'label' => esc_html__( 'Description', 'goyto-plugin' ),
				'type' => Controls_Manager::WYSIWYG,
                'label_block' => true,
			]
		);
		$repeater = new \Elementor\Repeater();
        $repeater->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'gtbus-plugin' ),
				'default' => esc_html__( 'Best of Hotel', 'gtbus-plugin' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
        $this->add_control(
			'infos',
			[
				'label' => esc_html__( 'Add Info Item', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
                'title_field' => '{{{ title }}}',
			]
		);
		$this->end_controls_section();

        $this->start_controls_section(
			'--video-option',
			[
				'label' => esc_html__( 'Video Option', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'video_link', [
				'label' => esc_html__( 'Video Link', 'goyto-plugin' ),
				'description' => esc_html__( 'If you want to remove Video Section then remove url link please', 'goyto-plugin' ),
				'type' => Controls_Manager::URL,
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'--search-option',
			[
				'label' => esc_html__( 'Search Option', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'location_label', [
				'label' => esc_html__( 'Location Label', 'goyto-plugin' ),
				'default' => esc_html__( 'Location', 'goyto-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $this->add_control(
			'l_d_value', [
				'label' => esc_html__( 'Location Option Default Value', 'goyto-plugin' ),
				'default' => esc_html__( 'Where To Next?', 'goyto-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $this->add_control(
			'l_icon', [
				'label' => esc_html__( 'Location Icon', 'goyto-plugin' ),
				'type' => Controls_Manager::ICONS,
                'label_block' => true,
			]
		);
        $this->add_control(
			'activity_options',
			[
				'label' => esc_html__( 'Activity Option', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        $this->add_control(
			'activity_label', [
				'label' => esc_html__( 'Activity Label', 'goyto-plugin' ),
				'default' => esc_html__( 'Activity', 'goyto-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $this->add_control(
			'a_d_value', [
				'label' => esc_html__( 'Activity Default Value', 'goyto-plugin' ),
				'default' => esc_html__( 'Select Activity', 'goyto-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $this->add_control(
			'a_icon', [
				'label' => esc_html__( 'Activity Icon', 'goyto-plugin' ),
				'type' => Controls_Manager::ICONS,
                'label_block' => true,
			]
		);
        $this->add_control(
			'type_options',
			[
				'label' => esc_html__( 'Type Option', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        $this->add_control(
			'type_label', [
				'label' => esc_html__( 'Type Label', 'goyto-plugin' ),
				'default' => esc_html__( 'Tour Type', 'goyto-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $this->add_control(
			't_d_value', [
				'label' => esc_html__( 'Type Default Value', 'goyto-plugin' ),
				'default' => esc_html__( 'Select Type', 'goyto-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $this->add_control(
			't_icon', [
				'label' => esc_html__( 'Location Icon', 'goyto-plugin' ),
				'type' => Controls_Manager::ICONS,
                'label_block' => true,
			]
		);
		$this->end_controls_section();


        $this->start_controls_section(
			'brand__carousel_opt',
			[
				'label' => esc_html__( 'Sponsor Option', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
			'partner_logo', [
				'label' => esc_html__( 'Partner Logo', 'gtbus-plugin' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
        
        $this->add_control(
			'partners',
			[
				'label' => esc_html__( 'Add Partners Item', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
			]
		);
        
		$this->end_controls_section();


        $this->start_controls_section(
			'slider_setting',
			[
				'label' => esc_html__( 'Slider Setting Option', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'sub_title_show',
			[
				'label' => esc_html__( 'Show Sub Title', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'goyto-plugin' ),
				'label_off' => esc_html__( 'Hide', 'goyto-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
        $this->add_control(
			'title_show',
			[
				'label' => esc_html__( 'Show Title', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'goyto-plugin' ),
				'label_off' => esc_html__( 'Hide', 'goyto-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
        $this->add_control(
			'desc_show',
			[
				'label' => esc_html__( 'Show Description', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'goyto-plugin' ),
				'label_off' => esc_html__( 'Hide', 'goyto-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
       
        $this->add_control(
			'partner_logo_show',
			[
				'label' => esc_html__( 'Show Partner', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'goyto-plugin' ),
				'label_off' => esc_html__( 'Hide', 'goyto-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->end_controls_section();
        

		// Sub title style
		$this->start_controls_section(
			'slider_sub_title_style',
			[
				'label' => esc_html__( 'Sub Title Style', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_responsive_control(
			'margin',
			[
				'label' => esc_html__( 'Sub Title Margin', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .elementor-goyto-sub' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        $this->add_control(
			'sub_title_color',
			[
				'label' => esc_html__( 'Sub Title Color', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .elementor-goyto-sub' => 'color: {{VALUE}}',
				],
			]
		);
		// typography
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[

				'name' => 'm_s_typography',
				'selector' => '{{WRAPPER}} .elementor-goyto-sub',
			]
		);


		$this->end_controls_section();

		// title style
		$this->start_controls_section(
			'slider_title_style',
			[
				'label' => esc_html__( 'Title Style', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_responsive_control(
			'title_margin',
			[
				'label' => esc_html__( 'Sub Title Margin', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .elementor-gt-heading' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[

				'name' => 'm_t_typography',
				'selector' => '{{WRAPPER}} .elementor-gt-heading',
			]
		);
		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Title Color', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .elementor-gt-heading' => 'color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();

		// description style
		$this->start_controls_section(
			'slider_description_style',
			[
				'label' => esc_html__( 'Description Style', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_responsive_control(
			'desc_margin',
			[
				'label' => esc_html__( 'Desc Margin', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .elementor-gt-desc p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		// typography
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[

				'name' => 'm_d_typography',
				'selector' => '{{WRAPPER}} .elementor-gt-desc p',
			]
		);

		// description color
		$this->add_control(
			'description_color',
			[
				'label' => esc_html__( 'Description Color', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .elementor-gt-desc p' => 'color: {{VALUE}}',
				],
			]
		);

		// end
		$this->end_controls_section();


		// feature style
		$this->start_controls_section(
			'slider_button_one',
			[
				'label' => esc_html__( 'Button Style', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'm_b_typography',
				'selector' => '{{WRAPPER}} .gt-btn-1 a',
			]
		);
        $this->add_control(
			'padding',
			[
				'label' => esc_html__( 'Padding', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .gt-btn-1 a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        $this->add_control(
			'b_round',
			[
				'label' => esc_html__( 'Border Radius', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .gt-btn-1 a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);


        $this->start_controls_tabs(
			'style_tabs'
		);

		$this->start_controls_tab(
			'style_normal_tab',
			[
				'label' => esc_html__( 'Normal', 'goyto-plugin' ),
			]
		);
        $this->add_control(
			'btn_text',
			[
				'label' => esc_html__( 'Text Color', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-btn-1 a' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'button_bg_color',
				'types' => [ 'gradient' ],
				'exclude' => [ 'image' ],
				'selector' => '{{WRAPPER}} .gt-btn-1 a',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__( 'Button BG Color ', 'goyto-plugin' ),
                        'description' => esc_html__( 'Choose background type and style.', 'goyto-plugin' ),
                        'separator' => 'before',
                    ]
                ]
			]
		);
        $this->end_controls_tab();
        $this->start_controls_tab(
			'style_hover_tab',
			[
				'label' => esc_html__( 'Hover', 'goyto-plugin' ),
			]
		);
        
        $this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'button_bg_hover_color',
				'types' => [ 'gradient' ],
				'exclude' => [ 'image' ],
				'selector' => '{{WRAPPER}} .gt-btn-1 a:before',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__( 'Button Hover BG Color ', 'goyto-plugin' ),
                        'description' => esc_html__( 'Choose background type and style.', 'goyto-plugin' ),
                        'separator' => 'before',
                    ]
                ]
			]
		);
        $this->end_controls_tab();
		$this->end_controls_tabs();
        $this->end_controls_section();


		// feature style
		$this->start_controls_section(
			'slider_video_opt',
			[
				'label' => esc_html__( 'Video Style', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_control(
			'video_btn_text',
			[
				'label' => esc_html__( 'Video Text Color', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-banner-text .gt-play-btn-grp .gt-play span' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'video_btn_typography',
				'selector' => '{{WRAPPER}} .gt-banner-text .gt-play-btn-grp .gt-play span',
			]
		);
        $this->add_control(
			'video_btn_round',
			[
				'label' => esc_html__( 'Border Radius', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .gt-banner-text .gt-play-btn-grp .gt-play i' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);


        $this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'video_btn_bg_color',
				'types' => [ 'gradient' ],
				'exclude' => [ 'image' ],
				'selector' => '{{WRAPPER}} .gt-banner-text .gt-play-btn-grp .gt-play i',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__( 'Video BG Color ', 'goyto-plugin' ),
                        'description' => esc_html__( 'Choose background type and style.', 'goyto-plugin' ),
                        'separator' => 'before',
                    ]
                ]
			]
		);
        
        $this->end_controls_section();


	}


	protected function render() {
		$settings = $this->get_settings_for_display();
        
        ?>
        <section id="gt-banner-4" class="gt-banner-section-4">
            <div class="gt-banner-content-4 position-relative">
                <?php if(!empty($settings['img_1']['url'])):?>
                    <div class="banner_plane  position-absolute wow slideInRight"  data-wow-delay="1200ms" data-wow-duration="2000ms"><img src="<?php echo esc_url($settings['img_1']['url']);?>" alt="<?php if(!empty($settings['img_1']['alt'])){ echo esc_attr($settings['img_1']['alt']);}?>"></div>
                <?php endif;?>

                <?php if(!empty($settings['img_2']['url'])):?>
                    <div class="gt-banner-img-4 position-absolute wow slideInRight"  data-wow-delay="800ms" data-wow-duration="1500ms"><img src="<?php echo esc_url($settings['img_2']['url']);?>" alt="<?php if(!empty($settings['img_2']['alt'])){ echo esc_attr($settings['img_2']['alt']);}?>"></div>
                <?php endif;?>

                <?php if(!empty($settings['img_3']['url'])):?>
                    <div class="gt-banner-bg-img position-absolute img-parallax"><img src="<?php echo esc_url($settings['img_3']['url']);?>" alt="<?php if(!empty($settings['img_3']['alt'])){ echo esc_attr($settings['img_3']['alt']);}?>"></div>
                <?php endif;?>

                <div class="container">
                    <div class="gt-banner-text-4 headline txt-text-anim pera-content">
                        <?php if($settings['sub_title_show'] === 'yes'):?>
                            <div class="banner-slug cursive-font-2 text-uppercase wow fadeInRight"  data-wow-delay="500ms" data-wow-duration="1000ms">
                                <?php if(!empty($settings['title_shape']['url'])):?>
                                    <img src="<?php echo esc_url($settings['title_shape']['url']);?>" alt="<?php if(!empty($settings['title_shape']['alt'])){ echo esc_attr($settings['title_shape']['alt']);}?>"> 
                                <?php endif;?>    
                                <span><?php echo wp_kses($settings['subtitle'], true);?></span>  
                                <?php if(!empty($settings['title_shape']['url'])):?>
                                    <img src="<?php echo esc_url($settings['title_shape']['url']);?>" alt="<?php if(!empty($settings['title_shape']['alt'])){ echo esc_attr($settings['title_shape']['alt']);}?>"> 
                                <?php endif;?>   
                            </div>
                        <?php endif;?>
                        <?php if($settings['title_show'] === 'yes'):?>
                        <h1 class="elementor-gt-heading banner_title cd-headline letters scale wow fadeInUp"  data-wow-delay="700ms" data-wow-duration="1000ms">
                            <?php echo wp_kses($settings['title'], true);?>
                            <span class="cd-words-wrapper">
                                <?php $i =0; foreach($settings['infos'] as $item): $i++?>
                                    <b <?php if($i == 1):?> class="is-visible" <?php endif;?>><?php echo esc_html($item['title']);?></b>
                                <?php endforeach;?>
                            </span>
                        </h1>
                        <?php endif;?>
                        <?php if($settings['desc_show'] === 'yes'):?>
                            <div class="elementor-gt-desc">
                                <p><?php echo wp_kses($settings['description'], true);?></p>
                            </div>
                        <?php endif;?>
                    </div>
                </div>
                <div class="gt-banner-search-box-4 position-relative wow fadeInUp"  data-wow-delay="900ms" data-wow-duration="1000ms">
                    <div class="gt-banner-search-option-4">
						<form action="<?php echo esc_url( wp_travel_engine_get_page_permalink( 'search' ) ); ?>">
							<div class="gt-booking-option  d-flex align-items-center justify-content-between">
								<div class="option_action ver_2 position-relative headline">
								<h3><?php \Elementor\Icons_Manager::render_icon( $settings['l_icon'], [ 'aria-hidden' => 'true' ] ); ?></i><?php echo wp_kses($settings['location_label'], true)?></h3>
									<select name="destination">
									<?php if(!empty($settings['l_d_value'])):?>
										<option value=""><?php echo wp_kses($settings['l_d_value'], true)?></option>
									<?php endif;?>
										<?php
											// Get all terms from the "destination" taxonomy
											$terms = get_terms( array(
												'taxonomy' => 'destination',
												'hide_empty' => false,
											) );

											// Loop through each term and create an option for the select dropdown
											foreach ( $terms as $term ) {
												echo '<option value="' . $term->slug . '">' . $term->name . '</option>';
											}
										?>
									</select>
								</div>
								<div class="option_action ver_2 position-relative headline">
								<h3><?php \Elementor\Icons_Manager::render_icon( $settings['a_icon'], [ 'aria-hidden' => 'true' ] ); ?></i><?php echo wp_kses($settings['activity_label'], true)?></h3>
								<select name="activities">
									<?php if(!empty($settings['a_d_value'])):?>
										<option value=""><?php echo wp_kses($settings['a_d_value'], true)?></option>
									<?php endif;?>
									<?php
										// Get all terms from the "destination" taxonomy
										$terms = get_terms( array(
											'taxonomy' => 'activities',
											'hide_empty' => false,
										) );

										// Loop through each term and create an option for the select dropdown
										foreach ( $terms as $term ) {
											echo '<option value="' . $term->slug . '">' . $term->name . '</option>';
										}
									?>
								</select>
								</div>
								<div class="option_action ver_2 position-relative headline">
									<h3><?php \Elementor\Icons_Manager::render_icon( $settings['t_icon'], [ 'aria-hidden' => 'true' ] ); ?></i><?php echo wp_kses($settings['type_label'], true)?></h3>
									<select name="trip_types">
										<?php if(!empty($settings['t_d_value'])):?>
											<option value=""><?php echo wp_kses($settings['t_d_value'], true)?></option>
										<?php endif;?>
										<?php
											// Get all terms from the "destination" taxonomy
											$terms = get_terms( array(
												'taxonomy' => 'trip_types',
												'hide_empty' => false,
											) );

											// Loop through each term and create an option for the select dropdown
											foreach ( $terms as $term ) {
												echo '<option value="' . $term->slug . '">' . $term->name . '</option>';
											}
										?>
									</select>
								</div>
								<div class="submit-btn ver_2">
									<button type="submit"><i class="far fa-search"></i></button>
								</div>
							</div>
						</form>
                    </div>
                    <div class="gt-banner-video-area ">
                        <video autoplay muted loop playsinline preload="metadata"><source src="<?php echo esc_url($settings['video_link']['url']);?>">
                        </video>
                    </div>
                </div>
                <?php if($settings['partner_logo_show'] === 'yes'):?>
                <div class="gt-banner-sponsor-4">
                    <div class="gt-partner-slider-2 swiper-container">
                        <div class="swiper-wrapper">

                            <?php foreach($settings['partners'] as $item):?>
                                <div class="swiper-slide">
                                    <div class="gt-sponsor-item">
                                        <img src="<?php echo esc_url($item['partner_logo']['url']);?>" alt="<?php if(!empty($settings['partner_logo']['alt'])){ echo esc_attr($settings['partner_logo']['alt']);}?>">
                                    </div>
                                </div>
                            <?php endforeach;?>
                            
                        </div>
                    </div>
                </div>
                <?php endif;?>
            </div>
        </section>
    <?php 
    }


}


Plugin::instance()->widgets_manager->register( new Goyto_Hero_Three() );