<?php

/**
 * Elementor Single Widget
 * @package goyto Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Goyto_Listing_Banner extends Widget_Base {



	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'goyto-listing-banner';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Listing Banner', 'goyto-plugin' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'goyto-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'goyto_widgets' ];
	}

	
	protected function register_controls() {
        $this->start_controls_section(
			'shape__imge',
			[
				'label' => esc_html__( 'Shape Image Option', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'shape_1',
			[
				'label' => esc_html__( 'Shape 1', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
			]
		);
        $this->add_control(
			'shape_2',
			[
				'label' => esc_html__( 'Shape 2', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
			]
		);
        $this->end_controls_section();

		$this->start_controls_section(
			'int_layout_opt',
			[
				'label' => esc_html__( 'Heading Option', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'title_shape',
			[
				'label' => esc_html__( 'Title Shape Image', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
			]
		);
		
        $this->add_control(
			'subtitle', [
				'label' => esc_html__( 'Sub Title', 'goyto-plugin' ),
				'default' => esc_html__( 'Get To Know Us', 'goyto-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        
        $this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'goyto-plugin' ),
				'default' => esc_html__( 'Section Title', 'goyto-plugin' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		$this->add_control(
            'title_tag',
            [
                'label'   => __( 'Title HTML Tag', 'goyto-plugin' ),
                'type'    => Controls_Manager::CHOOSE,
                'options' => [
                    'h1' => [
                        'title' => __( 'H1', 'goyto-plugin' ),
                        'icon'  => 'eicon-editor-h1',
                    ],
                    'h2' => [
                        'title' => __( 'H2', 'goyto-plugin' ),
                        'icon'  => 'eicon-editor-h2',
                    ],
                    'h3' => [
                        'title' => __( 'H3', 'goyto-plugin' ),
                        'icon'  => 'eicon-editor-h3',
                    ],
                    'h4' => [
                        'title' => __( 'H4', 'goyto-plugin' ),
                        'icon'  => 'eicon-editor-h4',
                    ],
                    'h5' => [
                        'title' => __( 'H5', 'goyto-plugin' ),
                        'icon'  => 'eicon-editor-h5',
                    ],
                    'h6' => [
                        'title' => __( 'H6', 'goyto-plugin' ),
                        'icon'  => 'eicon-editor-h6',
                    ],
                ],
                'default' => 'h1',
                'toggle'  => false,
            ]
        );
        $this->add_control(
			'description', [
				'label' => esc_html__( 'Description', 'goyto-plugin' ),
				'type' => Controls_Manager::WYSIWYG,
                'label_block' => true,
			]
		);
		$this->add_responsive_control(
			'align',
			[
				'label' => esc_html__( 'Alignment', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'goyto-plugin' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'goyto-plugin' ),
						'icon' => 'eicon-text-align-center',
					],
					'end' => [
						'title' => esc_html__( 'Right', 'goyto-plugin' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'center',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .prthalign' => 'text-align: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();
        $this->start_controls_section(
			'int_tour_btn_opt',
			[
				'label' => esc_html__( 'Tour Button Option', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'type',
            [
                'label'          => __( 'Icon Type', 'gesto-core' ),
                'type'           => Controls_Manager::CHOOSE,
                'label_block'    => false,
                'options'        => [
                    'icon'  => [
                        'title' => __( 'Icon', 'gesto-core' ),
                        'icon'  => 'far fa-smile',
                    ],
                    'image' => [
                        'title' => __( 'Image', 'gesto-core' ),
                        'icon'  => 'fa fa-image',
                    ],
                ],
                'default'        => 'icon',
                'toggle'         => false,
                'style_transfer' => true,
                
            ]
        );
        $repeater->add_control(
			'icon', [
				'label' => esc_html__( 'Icon', 'gesto-plugin' ),
				'type' => Controls_Manager::ICONS,
                'label_block' => true,
                'condition'      => [
                    'type' => 'icon',
                ],
			]
		);
        $repeater->add_control(
			'icon_img', [
				'label' => esc_html__( 'Icon Image', 'gesto-plugin' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
                'condition'      => [
                    'type' => 'image',
                ],
			]
		);
        $repeater->add_control(
			'btn_label', [
				'label' => esc_html__( 'Button Label', 'goyto-plugin' ),
				'type' => Controls_Manager::TEXT,
			]
		);
        $repeater->add_control(
			'btn_link', [
				'label' => esc_html__( 'Button Link', 'goyto-plugin' ),
				'type' => Controls_Manager::URL,
			]
		);

        $this->add_control(
			'buttons',
			[
				'label' => esc_html__( 'Add Button Item', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
			]
		);
        $this->add_control(
			'btn_label', [
				'label' => esc_html__( 'Button Label', 'goyto-plugin' ),
				'type' => Controls_Manager::TEXT,
			]
		);
        $this->add_control(
			'btn_link', [
				'label' => esc_html__( 'Button Link', 'goyto-plugin' ),
				'type' => Controls_Manager::URL,
			]
		);
        $this->add_control(
			'btn_icon', [
				'label' => esc_html__( 'Button Icon', 'goyto-plugin' ),
				'type' => Controls_Manager::MEDIA,
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'btn_hover_bg_img',
				'types' => [ 'classic' ],
				'exclude' => [ 'color' ],
				'selector' => '{{WRAPPER}} .gt-btn-3 a:after',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__( 'Button Hover Icon ', 'goyto-plugin' ),
                        'description' => esc_html__( 'Choose Button Hover Icon', 'goyto-plugin' ),
                        'separator' => 'before',
                    ]
                ]
			]
		);
		$this->end_controls_section();

        $this->start_controls_section(
			'post_sec_h_option',
			[
				'label' => esc_html__( 'Listing Option', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        
		$this->add_control(
			'selected_trip',
			[
				'label' => __( 'Select Indivisual Trip', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'options' => $this->get_all_posts(),
				'multiple' => true,
				'label_block' => true,
			]
		);
		$this->add_control(
			'exclude_trip',
			[
				'label' => __( 'Exclude Trip', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'options' => $this->get_all_posts(),
				'multiple' => true,
				'label_block' => true,
			]
		);
		$this->add_control(
			'post_order',
			[
				'label'     => esc_html__( 'Post Order', 'goyto-plugin' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'ASC',
				'options'   => [
					'ASC'  => esc_html__( 'Ascending', 'goyto-plugin' ),
					'DESC' => esc_html__( 'Descending', 'goyto-plugin' ),
				],
			]
		);
		
		$this->add_control(
			'post_per_page',
			[
				'label'   => __( 'Posts Per Page', 'goyto-plugin' ),
				'type'    => Controls_Manager::NUMBER,
				'min'     => 1,
				'default' => 5,
			]
		);
        $this->add_control(
			'activities',
			[
				'type'        => Controls_Manager::SELECT2,
				'label'       => esc_html__( 'Select Activities', 'goyto-plugin' ),
				'options' => goyto_select_cat('activities'),
				'label_block' => true,
				'multiple'    => true,
			]
		);
        $this->add_control(
			'destination',
			[
				'type'        => Controls_Manager::SELECT2,
				'label'       => esc_html__( 'Select Destination', 'goyto-plugin' ),
				'options' => goyto_select_cat('destination'),
				'label_block' => true,
				'multiple'    => true,
			]
		);
        $this->add_control(
			'tags',
			[
				'type'        => Controls_Manager::SELECT2,
				'label'       => esc_html__( 'Toure Type', 'goyto-plugin' ),
				'options' => goyto_select_cat('trip_types'),
				'label_block' => true,
				'multiple'    => true,
			]
		);
		$this->add_control(
            'price_label',
            [
                'label' => __('Price Label', 'goyto-plugin'),
                'default' => __('Starting Form', 'goyto-plugin'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,                                            
            ]
        );
		$this->add_control(
            'currency',
            [
                'label' => __('Currency', 'goyto-plugin'),
                'default' => __('$', 'goyto-plugin'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,                                            
            ]
        );
        $this->add_control(
            'duration_label',
            [
                'label' => __('Duration Label', 'goyto-plugin'),
                'default' => __('days Trip', 'goyto-plugin'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,                                            
            ]
        );

		$this->add_control(
			'tour_desc',
			[
				'label' => esc_html__( 'Tour Description', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
				'condition' => [
					'style' => '4',
				],
			]
		);
		
		$this->end_controls_section();
        $this->start_controls_section(
			'slider_setting',
			[
				'label' => esc_html__( 'Slider Setting Option', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'sub_title_show',
			[
				'label' => esc_html__( 'Show Sub Title', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'goyto-plugin' ),
				'label_off' => esc_html__( 'Hide', 'goyto-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
        
        $this->add_control(
			'desc_show',
			[
				'label' => esc_html__( 'Show Description', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'goyto-plugin' ),
				'label_off' => esc_html__( 'Hide', 'goyto-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
       
		$this->end_controls_section();
        $this->start_controls_section(
			'blog_style',
			[
				'label' => esc_html__( 'Blog Style', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
        
        $this->add_control(
			'post_title',
			[
				'label' => esc_html__( 'Post Title Style', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        $this->add_control(
			'post_list_title_color',
			[
				'label' => esc_html__( 'Post Title Color', 'goyto-plugin' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-blog-item .blog-text .blog_title' => 'color: {{VALUE}}'
				],
			]
		);
       
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'post_title_typography',
				'selector' => '
					{{WRAPPER}} .gt-blog-item .blog-text .blog_title
				',
			]
		);
        
        $this->add_control(
			'post_date_title',
			[
				'label' => esc_html__( 'Post Date Style', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        
        $this->add_control(
			'post_date_bg_color',
			[
				'label' => esc_html__( 'Post Date Color', 'goyto-plugin' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-blog-item .blog-text .blog-meta' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'post_date_typography',
				'selector' => '
					{{WRAPPER}} .gt-blog-item .blog-text .blog-meta
				',
			]
		);
		
        $this->add_control(
			'post_desc_title',
			[
				'label' => esc_html__( 'Post Description Style', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        $this->add_control(
			'post_desc_color',
			[
				'label' => esc_html__( 'Post Description Color', 'goyto-plugin' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .pera-content p' => 'color: {{VALUE}}'
				],
			]
		);
        
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'post_desc_typography',
				'selector' => '
				{{WRAPPER}} .pera-content p
				',
			]
		);
        $this->add_control(
			'post_authore_title',
			[
				'label' => esc_html__( 'Post Authore Style', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        $this->add_control(
			'post_authore_color',
			[
				'label' => esc_html__( 'Post Authore Color', 'goyto-plugin' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-blog-item .blog-author .inner-text' => 'color: {{VALUE}}'
				],
			]
		);
        
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'post_authore_typography',
				'selector' => '
				{{WRAPPER}} .gt-blog-item .blog-author .inner-text
				',
			]
		);
        
		$this->end_controls_section();
        
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	

        $args = array(
			'post_type'           => 'at_biz_dir',
			'posts_per_page'      => !empty( $settings['post_per_page'] ) ? $settings['post_per_page'] : 3,
			'post_status'         => 'publish',
			'order'               => $settings['post_order'],
		);
		if(!empty($settings['categories'][0])) {
			$args['tax_query'] = array(
				array(
				'taxonomy' => 'at_biz_dir-category',
				'field'    => 'ids',
				'terms'    => $settings['categories']
				)
			);
		}
		if(!empty($settings['location'][0])) {
			$args['tax_query'] = array(
				array(
				'taxonomy' => 'at_biz_dir-location',
				'field'    => 'ids',
				'terms'    => $settings['location']
				)
			);
		}
		if(!empty($settings['tags'][0])) {
			$args['tax_query'] = array(
				array(
				'taxonomy' => 'at_biz_dir-tags',
				'field'    => 'ids',
				'terms'    => $settings['tags']
				)
			);
		}
		
		$query = new \WP_Query( $args );
        require __DIR__ . '/view/listing-banner/listing-1.php';
    }

	protected function get_all_posts() {
        $posts = get_posts( array( 'post_type' => 'trip', 'numberposts' => -1 ) );
        $post_options = array();
        foreach ( $posts as $post ) {
            $post_options[ $post->ID ] = $post->post_title;
        }
        return $post_options;
    }
    
		
	
}


Plugin::instance()->widgets_manager->register( new Goyto_Listing_Banner() );