<?php

/**
 * Elementor Single Widget
 * @package goyto Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Goyto_Listing_Filter extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'go-list-filter';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Listing Filter', 'goyto-plugin' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'goyto-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'goyto_widgets' ];
	}


	protected function register_controls() {

        $this->start_controls_section(
			'int_widget_opt',
			[
				'label' => esc_html__( 'List Style Select', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'style',
			[
				'label' => esc_html__( 'Style', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'1'  => esc_html__( 'Style 1', 'goyto-plugin' ),
				]
			]
		);
        $this->end_controls_section();

        $this->start_controls_section(
			'int_main_section_opt',
			[
				'label' => esc_html__( 'Sponsor Option', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
			'filter_id', [
				'label' => esc_html__( 'Filter ID', 'goyto-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);

        $repeater->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'goyto-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);

        $this->add_control(
			'filters',
			[
				'label' => esc_html__( 'Add Filter Item', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
                'title_field' => '{{{ title }}}',
			]
		);

		$this->end_controls_section();
        $this->start_controls_section(
			'int_listing_opt',
			[
				'label' => esc_html__( 'Listing Option', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
			'cate_id', [
				'label' => esc_html__( 'Filter ID', 'binsro-plugin' ),
				'placeholder' => esc_html__( 'Add ID: 1, 2, 3', 'binsro-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $repeater->add_control(
            'img_size',
            [
                'label' => __('Image size', 'goyto-plugin'),
                'type' => Controls_Manager::SELECT,
                'label_block' => true,
                'options' =>  goyto_img_size_control(), 
                'multiple' => false,                                                
            ]
        );
		$repeater->add_control(
			'post_order',
			[
				'label'     => esc_html__( 'Post Order', 'goyto-plugin' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'ASC',
				'options'   => [
					'ASC'  => esc_html__( 'Ascending', 'goyto-plugin' ),
					'DESC' => esc_html__( 'Descending', 'goyto-plugin' ),
				],
			]
		);
		
		$repeater->add_control(
			'post_per_page',
			[
				'label'   => __( 'Posts Per Page', 'goyto-plugin' ),
				'type'    => Controls_Manager::NUMBER,
				'min'     => 1,
				'default' => 5,
			]
		);
        $repeater->add_control(
			'location',
			[
				'type'        => Controls_Manager::SELECT2,
				'label'       => esc_html__( 'Select Location', 'goyto-plugin' ),
				'options' => goyto_select_cat('at_biz_dir-location'),
				'label_block' => true,
				'multiple'    => true,
			]
		);
        $repeater->add_control(
			'categories',
			[
				'type'        => Controls_Manager::SELECT2,
				'label'       => esc_html__( 'Select Categories', 'goyto-plugin' ),
				'options' => goyto_select_cat('at_biz_dir-category'),
				'label_block' => true,
				'multiple'    => true,
			]
		);
        $repeater->add_control(
			'tags',
			[
				'type'        => Controls_Manager::SELECT2,
				'label'       => esc_html__( 'Select Tags', 'goyto-plugin' ),
				'options' => goyto_select_cat('at_biz_dir-tags'),
				'label_block' => true,
				'multiple'    => true,
			]
		);

        $this->add_control(
			'listings',
			[
				'label' => esc_html__( 'Add Listing Item', 'binsro-plugin' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
			]
		);
		$this->end_controls_section();
        
        


	}


	protected function render() {
		$settings = $this->get_settings_for_display();
        require __DIR__ . '/view/listing-filter/filter-' . $settings['style'] . '.php';
    }


}


Plugin::instance()->widgets_manager->register( new Goyto_Listing_Filter() );