<?php

/**
 * Elementor Single Widget
 * @package goyto Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Goyto_Parallax_Bannar extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'go-parlx-banner';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Parallax Banner', 'goyto-plugin' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'goyto-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'goyto_widgets' ];
	}


	protected function register_controls() {

        $this->start_controls_section(
			'int_main_section_opt',
			[
				'label' => esc_html__( 'Background Option', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'bg_img', [
				'label' => esc_html__( 'Background Image', 'gesto-plugin' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'gesto-plugin' ),
				'default' => esc_html__( 'Famous Photo Gallery', 'gesto-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'btn_label', [
				'label' => esc_html__( 'Button Label', 'gesto-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'btn_link', [
				'label' => esc_html__( 'Button Link', 'gesto-plugin' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
		$this->add_control(
			'btn_img', [
				'label' => esc_html__( 'Button Shape Image', 'gesto-plugin' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->end_controls_section();
        
        


	}


	protected function render() {
		$settings = $this->get_settings_for_display();?>
        <section id="gt-cta-4" class="gt-cta-section-4 position-relative">
            <?php if(!empty($settings['bg_img']['url'])):?>
                <div class="gt-cta-bg-img img-parallax">
                    <img src="<?php echo esc_url($settings['bg_img']['url']);?>" alt="<?php if(!empty($settings['bg_img']['url'])){ echo esc_attr($settings['bg_img']['url']);}?>">
                </div>
            <?php endif;?>
            <div class="gt-cta-content-4 text-center headline">
                <h2 class="tx-split-text split-in-up"><?php echo wp_kses($settings['title'], true);?></h2>
                <?php if(!empty($settings['btn_label'])):?>
                    <div class="gt-btn-3 mt-35 text-uppercase">
                        <a href="<?php echo esc_url($settings['btn_link']['url']);?>"><?php echo wp_kses($settings['btn_label'], true);?> 
                            <img src="<?php echo esc_url($settings['btn_img']['url']);?>" alt="<?php if(!empty($settings['btn_img']['url'])){ echo esc_attr($settings['btn_img']['url']);}?>">
                        </a>
                    </div>
                <?php endif;?>
            </div>
        </section>
    <?php
    }


}


Plugin::instance()->widgets_manager->register( new Goyto_Parallax_Bannar() );