<?php

/**
 * Elementor Single Widget
 * @package goyto Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Goyto_Testimonial extends Widget_Base {

	/**
	 * Slider Style Dependency
	 *
	 * @return void
	 */
	public function get_style_depends()
	{
		return ['testimonial'];
	}

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'go-testimonial';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Testimonial', 'goyto-plugin' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'goyto-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'goyto_widgets' ];
	}


	protected function register_controls() {

        $this->start_controls_section(
			'int_widget_opt',
			[
				'label' => esc_html__( 'Testimonial Style Select', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'style',
			[
				'label' => esc_html__( 'Style', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'1'  => esc_html__( 'Style 1', 'goyto-plugin' ),
					'2'  => esc_html__( 'Style 2', 'goyto-plugin' ),
					'3'  => esc_html__( 'Style 3', 'goyto-plugin' ),
					'4'  => esc_html__( 'Style 4', 'goyto-plugin' ),
					'5'  => esc_html__( 'Style 5', 'goyto-plugin' )
				]
			]
		);
        $this->end_controls_section();

        $this->start_controls_section(
			'int_main_section_opt',
			[
				'label' => esc_html__( 'Testimonial Option', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'quote_icon', [
				'label' => esc_html__( 'Quote Image', 'goyto-plugin' ),
				'type' => Controls_Manager::MEDIA,
				'condition' => [
					'style' => ['2', '3'],
				],
			]
		);
		$this->add_control(
			'shape', [
				'label' => esc_html__( 'Shape Image', 'goyto-plugin' ),
				'type' => Controls_Manager::MEDIA,
				'condition' => [
					'style' => '3',
				],
			]
		);
		$this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'goyto-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
				'condition' => [
					'style' => '2',
				],
			]
		);
        $repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'layout',
			[
				'label' => esc_html__( 'Layout', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'1'  => esc_html__( 'Style 1', 'goyto-plugin' ),
					'2'  => esc_html__( 'Style 2', 'goyto-plugin' ),
					'3'  => esc_html__( 'Style 3', 'goyto-plugin' ),
					'4'  => esc_html__( 'Style 4', 'goyto-plugin' ),
					'5'  => esc_html__( 'Style 5', 'goyto-plugin' ),
				]
			]
		);
        $repeater->add_control(
			'thubm_id', [
				'label' => esc_html__( 'Thumb ID', 'goyto-plugin' ),
				'type' => Controls_Manager::TEXT,
				'condition' => [
					'layout!' => '5',
				],
			]
		);
        $repeater->add_control(
			'authore_navigation', [
				'label' => esc_html__( 'Authore Navigation Image', 'goyto-plugin' ),
				'type' => Controls_Manager::MEDIA,
                'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'condition' => [
					'layout' => '4',
				],
			]
		);
        $repeater->add_control(
			'authore_large', [
				'label' => esc_html__( 'Authore Large Image', 'goyto-plugin' ),
				'type' => Controls_Manager::MEDIA,
                'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'condition' => [
					'layout' => ['4', '5'],
				],
			]
		);
        $repeater->add_control(
			'authore', [
				'label' => esc_html__( 'Authore Image', 'goyto-plugin' ),
				'type' => Controls_Manager::MEDIA,
                'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_control(
			'feedback', [
				'label' => esc_html__( 'Feedback', 'goyto-plugin' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'name', [
				'label' => esc_html__( 'Name', 'goyto-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'designtaion', [
				'label' => esc_html__( 'Designation', 'goyto-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'rating',
			[
				'label' => esc_html__( 'Rating', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 5,
				'step' => 1,
				'default' => 5,
			]
		);
        $this->add_control(
			'testimonials',
			[
				'label' => esc_html__( 'Add Testimonial Item', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'slider_setting',
			[
				'label' => esc_html__( 'Slider Setting Option', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'nav_show',
			[
				'label' => esc_html__( 'Show Slider Nav', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'goyto-plugin' ),
				'label_off' => esc_html__( 'Hide', 'goyto-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
        
        $this->add_control(
			'rating_show',
			[
				'label' => esc_html__( 'Show Rating', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'goyto-plugin' ),
				'label_off' => esc_html__( 'Hide', 'goyto-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
        
		$this->end_controls_section();
		// title style
		$this->start_controls_section(
			'slider_feedback_style',
			[
				'label' => esc_html__( 'Feedback Style', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_responsive_control(
			'feedback_margin',
			[
				'label' => esc_html__( 'Feedback Margin', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .gt-testimonial-innerbox-item .gt-testimonial-text p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[

				'name' => 'feedback_typography',
				'selector' => '{{WRAPPER}} .gt-testimonial-innerbox-item .gt-testimonial-text p',
			]
		);
		$this->add_control(
			'feedback_color',
			[
				'label' => esc_html__( 'Feedback Color', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-testimonial-innerbox-item .gt-testimonial-text p' => 'color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'slider_name_style',
			[
				'label' => esc_html__( 'Name Style', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_responsive_control(
			'name_margin',
			[
				'label' => esc_html__( 'Name Margin', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .gt-testimonial-innerbox-item .gt-testimonial-meta-rate .gt-testimonial-meta h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[

				'name' => 'name_typography',
				'selector' => '{{WRAPPER}} .gt-testimonial-innerbox-item .gt-testimonial-meta-rate .gt-testimonial-meta h3',
			]
		);
		$this->add_control(
			'name_color',
			[
				'label' => esc_html__( 'Name Color', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-testimonial-innerbox-item .gt-testimonial-meta-rate .gt-testimonial-meta h3' => 'color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'slider_designation_style',
			[
				'label' => esc_html__( 'Designtaion Style', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_responsive_control(
			'deg_margin',
			[
				'label' => esc_html__( 'Designation Margin', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .gt-testimonial-innerbox-item .gt-testimonial-meta-rate .gt-testimonial-meta span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[

				'name' => 'desig_typography',
				'selector' => '{{WRAPPER}} .gt-testimonial-innerbox-item .gt-testimonial-meta-rate .gt-testimonial-meta span',
			]
		);
		$this->add_control(
			'desig_color',
			[
				'label' => esc_html__( 'Designation Color', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-testimonial-innerbox-item .gt-testimonial-meta-rate .gt-testimonial-meta span' => 'color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'slider_box_style',
			[
				'label' => esc_html__( 'Box Style', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
        
		$this->add_control(
			'box_bg_color',
			[
				'label' => esc_html__( 'Box BG Color', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}}.gt-testimonial-slider .choose_slider_items .next_item .gt-testimonial-innerbox-item' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'box_active_color',
			[
				'label' => esc_html__( 'Box Active BG Color', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-testimonial-innerbox-item' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();
        
        


	}


	protected function render() {
		$settings = $this->get_settings_for_display();
        require __DIR__ . '/view/testimonial/testimonial-' . $settings['style'] . '.php';
    }


}


Plugin::instance()->widgets_manager->register( new Goyto_Testimonial() );