<?php

/**
 * Elementor Single Widget
 * @package goyto Tools
 * @since 1.0.0
 */

 namespace Elementor;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Goyto_Toure extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'go-toure';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Goyto Toure', 'goyto-plugin' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'goyto-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'goyto_widgets' ];
	}


	protected function register_controls() {

        $this->start_controls_section(
			'int_widget_opt',
			[
				'label' => esc_html__( 'Tour Select', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'style',
			[
				'label' => esc_html__( 'Style', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'1'  => esc_html__( 'Style 1', 'goyto-plugin' ),
					'2'  => esc_html__( 'Style 2', 'goyto-plugin' ),
					'3'  => esc_html__( 'Style 3', 'goyto-plugin' ),
					'4'  => esc_html__( 'Style 4', 'goyto-plugin' ),
					'5'  => esc_html__( 'Style 5', 'goyto-plugin' )
				]
			]
		);
        $this->end_controls_section();

        $this->start_controls_section(
			'int_main_section_opt',
			[
				'label' => esc_html__( 'Features Option', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'price_label',
			[
				'label' => esc_html__( 'Pricing Label', 'goyto-plugin' ),
				'default' => esc_html__( 'Per Night', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::TEXT,
			]
		);
        $this->add_control(
			'durations',
			[
				'label' => esc_html__( 'Duration Label', 'goyto-plugin' ),
				'default' => esc_html__( 'Days', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::TEXT,
			]
		);
		$this->add_control(
			'selected_trip',
			[
				'label' => __( 'Select Indivisual Trip', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'options' => $this->get_all_posts(),
				'multiple' => true,
				'label_block' => true,
			]
		);
		$this->add_control(
			'exclude_trip',
			[
				'label' => __( 'Exclude Trip', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'options' => $this->get_all_posts(),
				'multiple' => true,
				'label_block' => true,
			]
		);
		$this->add_control(
			'post_order',
			[
				'label'     => esc_html__( 'Post Order', 'goyto-plugin' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'ASC',
				'options'   => [
					'ASC'  => esc_html__( 'Ascending', 'goyto-plugin' ),
					'DESC' => esc_html__( 'Descending', 'goyto-plugin' ),
				],
			]
		);
		
		$this->add_control(
			'post_per_page',
			[
				'label'   => __( 'Posts Per Page', 'goyto-plugin' ),
				'type'    => Controls_Manager::NUMBER,
				'min'     => 1,
				'default' => 5,
			]
		);
        $this->add_control(
			'activities',
			[
				'type'        => Controls_Manager::SELECT2,
				'label'       => esc_html__( 'Select Activities', 'goyto-plugin' ),
				'options' => goyto_select_cat('activities'),
				'label_block' => true,
				'multiple'    => true,
			]
		);
        $this->add_control(
			'destination',
			[
				'type'        => Controls_Manager::SELECT2,
				'label'       => esc_html__( 'Select Destination', 'goyto-plugin' ),
				'options' => goyto_select_cat('destination'),
				'label_block' => true,
				'multiple'    => true,
			]
		);
        $this->add_control(
			'tags',
			[
				'type'        => Controls_Manager::SELECT2,
				'label'       => esc_html__( 'Toure Type', 'goyto-plugin' ),
				'options' => goyto_select_cat('trip_types'),
				'label_block' => true,
				'multiple'    => true,
			]
		);
		$this->add_control(
            'currency',
            [
                'label' => __('Currency', 'goyto-plugin'),
                'default' => __('$', 'goyto-plugin'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,                                            
            ]
        );
        $this->add_control(
            'duration_label',
            [
                'label' => __('Duration Label', 'goyto-plugin'),
                'default' => __('days Trip', 'goyto-plugin'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,                                            
            ]
        );

		$this->add_control(
			'tour_desc',
			[
				'label' => esc_html__( 'Tour Description', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
				'condition' => [
					'style' => '4',
				],
			]
		);
		$this->end_controls_section();
        // feature style
		$this->start_controls_section(
			'slider_button_one',
			[
				'label' => esc_html__( 'Gradient BG Style', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'overlay_bg_color',
			[
				'label' => esc_html__( 'Overlay BG Color', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-explor-item .item-img-price:before' => 'background: {{VALUE}}',
				],
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'button_bg_hover_color',
				'types' => [ 'gradient' ],
				'exclude' => [ 'image' ],
				'selector' => '
					{{WRAPPER}} .gt-explor-item .item-img-price .inner-price,
					{{WRAPPER}} .gt-explor-item .item-text-area .ex-location,
					{{WRAPPER}} .gt-explor-nav .gt-explor-prev:before, .gt-explor-nav .gt-explor-next:before
				',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__( 'Gradient BG Color ', 'goyto-plugin' ),
                        'description' => esc_html__( 'Choose background type and style.', 'goyto-plugin' ),
                        'separator' => 'before',
                    ]
                ]
			]
		);
        $this->end_controls_section();
        


	}


	protected function render() {
		$settings = $this->get_settings_for_display();
        require __DIR__ . '/view/toure/toure-' . $settings['style'] . '.php';
    }

	protected function get_all_posts() {
        $posts = get_posts( array( 'post_type' => 'trip', 'numberposts' => -1 ) );
        $post_options = array();
        foreach ( $posts as $post ) {
            $post_options[ $post->ID ] = $post->post_title;
        }
        return $post_options;
    }


}


Plugin::instance()->widgets_manager->register( new Goyto_Toure() );