<?php

/**
 * Elementor Single Widget
 * @package goyto Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Goyto_Video_Gallery extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'go-video-gallery';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Video Gallery', 'goyto-plugin' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'goyto-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'goyto_widgets' ];
	}


	protected function register_controls() {

        $this->start_controls_section(
			'int_widget_opt',
			[
				'label' => esc_html__( 'Video Gallery Select', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'style',
			[
				'label' => esc_html__( 'Style', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'1'  => esc_html__( 'Style 1', 'goyto-plugin' ),
				]
			]
		);
        $this->end_controls_section();

        $this->start_controls_section(
			'int_main_section_opt',
			[
				'label' => esc_html__( 'Video Option', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'video_img', [
				'label' => esc_html__( 'Video Image', 'goyto-plugin' ),
				'type' => Controls_Manager::MEDIA,
			]
		);
		$repeater->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'goyto-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'video_link', [
				'label' => esc_html__( 'Video Link', 'goyto-plugin' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        
        $this->add_control(
			'gallerys',
			[
				'label' => esc_html__( 'Add Gallery Item', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
			]
		);
		$this->end_controls_section();

		// title style
		$this->start_controls_section(
			'slider_feedback_style',
			[
				'label' => esc_html__( 'Feedback Style', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_responsive_control(
			'feedback_margin',
			[
				'label' => esc_html__( 'Feedback Margin', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .gt-testimonial-innerbox-item .gt-testimonial-text p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[

				'name' => 'feedback_typography',
				'selector' => '{{WRAPPER}} .gt-testimonial-innerbox-item .gt-testimonial-text p',
			]
		);
		$this->add_control(
			'feedback_color',
			[
				'label' => esc_html__( 'Feedback Color', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-testimonial-innerbox-item .gt-testimonial-text p' => 'color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'slider_name_style',
			[
				'label' => esc_html__( 'Name Style', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_responsive_control(
			'name_margin',
			[
				'label' => esc_html__( 'Name Margin', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .gt-testimonial-innerbox-item .gt-testimonial-meta-rate .gt-testimonial-meta h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[

				'name' => 'name_typography',
				'selector' => '{{WRAPPER}} .gt-testimonial-innerbox-item .gt-testimonial-meta-rate .gt-testimonial-meta h3',
			]
		);
		$this->add_control(
			'name_color',
			[
				'label' => esc_html__( 'Name Color', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-testimonial-innerbox-item .gt-testimonial-meta-rate .gt-testimonial-meta h3' => 'color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'slider_designation_style',
			[
				'label' => esc_html__( 'Designtaion Style', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_responsive_control(
			'deg_margin',
			[
				'label' => esc_html__( 'Designation Margin', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .gt-testimonial-innerbox-item .gt-testimonial-meta-rate .gt-testimonial-meta span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[

				'name' => 'desig_typography',
				'selector' => '{{WRAPPER}} .gt-testimonial-innerbox-item .gt-testimonial-meta-rate .gt-testimonial-meta span',
			]
		);
		$this->add_control(
			'desig_color',
			[
				'label' => esc_html__( 'Designation Color', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-testimonial-innerbox-item .gt-testimonial-meta-rate .gt-testimonial-meta span' => 'color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'slider_box_style',
			[
				'label' => esc_html__( 'Box Style', 'goyto-plugin' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
        
		$this->add_control(
			'box_bg_color',
			[
				'label' => esc_html__( 'Box BG Color', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}}.gt-testimonial-slider .choose_slider_items .next_item .gt-testimonial-innerbox-item' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'box_active_color',
			[
				'label' => esc_html__( 'Box Active BG Color', 'goyto-plugin' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-testimonial-innerbox-item' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();
        
        


	}


	protected function render() {
		$settings = $this->get_settings_for_display();
        require __DIR__ . '/view/video-gallery/video-' . $settings['style'] . '.php';
    }


}


Plugin::instance()->widgets_manager->register( new Goyto_Video_Gallery() );