<?php 
    $this->add_render_attribute( 'title', 'class', 'elementor-gt-heading section_title ver_2 tx-split-text split-in-right' );
    if ( ! empty( $settings['btn_link']['url'] ) ) {
        $this->add_link_attributes( 'btn_link', $settings['btn_link'] );
    }
?>
<section id="gt-why-choose-3" class="gt-why-choose-section-3 position-relative pt-150 pb-150" data-background="<?php echo esc_url($settings['img_1']['url']);?>">
    <?php if(!empty($settings['img_2']['url'])):?>
        <div class="gt-why-choose-side-img position-absolute img-parallax"><img src="<?php echo esc_url($settings['img_2']['url']);?>" alt="<?php if(!empty($settings['img_2']['alt'])){ echo esc_attr($settings['img_2']['alt']);} ?>"></div>
    <?php endif;?>

    <?php if(!empty($settings['img_3']['url'])):?>
        <span class="gt-why-choose-line appear_right position-absolute"><img src="<?php echo esc_url($settings['img_3']['url']);?>" alt="<?php if(!empty($settings['img_3']['alt'])){ echo esc_attr($settings['img_3']['alt']);} ?>"></span>
    <?php endif;?>
    <?php if(!empty($settings['img_4']['url'])):?>
        <span class="gt-wc-inner-img appear_bottom position-absolute"><img src="<?php echo esc_url($settings['img_4']['url']);?>" alt="<?php if(!empty($settings['img_4']['alt'])){ echo esc_attr($settings['img_4']['alt']);} ?>"></span>
    <?php endif;?>
    <div class="container">
        <div class="gt-why-choose-content-3">
            <div class="gt-why-choose-text-3">
                <div class="gt-section-title-1 ver_2 pera-content txt-text-anim headline">
                    <?php if($settings['sub_title_show'] === 'yes'):?>
                    <div class="subtitle cursive-font wow fadeInRight"  data-wow-delay="200ms" data-wow-duration="1200ms">
                        <?php if(!empty($settings['title_shape']['url'])):?>
                            <img src="<?php echo esc_url($settings['title_shape']['url']);?>" alt="<?php if(!empty($settings['title_shape']['alt'])){ echo esc_attr($settings['title_shape']['alt']);}?>"> 
                        <?php endif;?> 
                        <?php echo wp_kses($settings['subtitle'], true);?>
                    </div>
                    <?php endif;?>
                    <?php printf('<%1$s %2$s>%3$s</%1$s>',
                        tag_escape($settings['title_tag']),
                        $this->get_render_attribute_string('title'),
                        $settings['title']
                    ); ?>
                    <?php if($settings['desc_show'] === 'yes'):?>
                        <p><?php echo wp_kses($settings['description'], true);?></p>
                    <?php endif;?>
                </div>
                <div class="gt-item-list mt-30 ul-li-block">
                    <ul>
                        <?php foreach($settings['lists'] as $item):?>
                            <li class="wow" data-splitting="">
                                <?php if ($item['type'] === 'image' && ($item['icon_img']['url'])) :?>
                                    <img src="<?php echo esc_url($item['icon_img']['url']);?>" alt="<?php if(!empty($item['icon_img']['alt'])){ echo esc_attr($item['icon_img']['alt']);}else{esc_attr_e('List', 'goyto-plugin');}?>">
                                <?php else:?>
                                    <?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                <?php endif;?>
                                <?php echo wp_kses($item['title'], true);?>
                            </li>
                        <?php endforeach;?>
                    </ul>
                </div>
                <div class="gt-btn-2 btn-spin mt-45 wow fadeInUp"  data-wow-delay="200ms" data-wow-duration="1200ms">
                    <a <?php echo $this->get_render_attribute_string( 'btn_link' ); ?>><?php echo wp_kses($settings['btn_label'], true);?></a>
                </div>
            </div>
        </div>
    </div>
</section>