<?php 
$this->add_render_attribute( 'title', 'class', 'elementor-gt-heading section_title ver_2 tx-split-text split-in-up' );
if ( ! empty( $settings['btn_link']['url'] ) ) {
    $this->add_link_attributes( 'btn_link', $settings['btn_link'] );
}
?>

<div class="gt-discount-area position-relative">
    <?php if(!empty($settings['banner_img'])):?>
        <div class="gt-discount-img position-absolute appear_top">
            <img src="<?php echo esc_url($settings['banner_img']['url']);?>" alt="<?php if(!empty($settings['banner_img']['alt'])){ echo esc_url($settings['banner_img']['alt']);}?>">
        </div>
    <?php endif;?>
    <div class="container">
        <div class="gt-discount-content pt-115 pb-110 d-flex justify-content-between">
            <div class="gt-discount-text-area">
                <div class="gt-section-title-1 ver_2 pera-content txt-text-anim headline">
                    <?php if($settings['sub_title_show'] === 'yes'):?>
                        <div class="subtitle cursive-font wow fadeInRight"  data-wow-delay="200ms" data-wow-duration="1200ms">
                            <?php if(!empty($settings['title_shape']['url'])):?>
                                <img src="<?php echo esc_url($settings['title_shape']['url']);?>" alt="<?php if(!empty($settings['title_shape']['alt'])){ echo esc_attr($settings['title_shape']['alt']);}?>"> 
                            <?php endif;?>  
                            <?php echo wp_kses($settings['subtitle'], true);?>
                        </div>
                    <?php endif;?>
                    <?php printf('<%1$s %2$s>%3$s</%1$s>',
                        tag_escape($settings['title_tag']),
                        $this->get_render_attribute_string('title'),
                        $settings['title']
                    ); ?>
                    <?php if($settings['desc_show'] === 'yes'):?>
                        <p><?php echo wp_kses($settings['description'], true);?></p>
                    <?php endif;?>
                </div>
                <div class="gt-btn-2 btn-spin mt-35 wow fadeInUp"  data-wow-delay="300ms" data-wow-duration="1200ms">
                    <a <?php echo $this->get_render_attribute_string( 'btn_link' ); ?>><?php echo wp_kses($settings['btn_label'], true);?></a>
                </div>
            </div>
            <div class="gt-discount-amount headline">
                <?php if(!empty($settings['discount_text'])):?>
                    <h3 class="text-uppercase "><?php echo __($settings['discount_text']);?></h3>
                <?php endif;?>
                <div class="gt-explor-visit-info mt-25 headline ul-li-block">
                    <ul>
                        <?php foreach($settings['lists'] as $item):?>
                            <li class="wow" data-splitting="">
                                <?php if ($item['type'] === 'image' && ($item['icon_img']['url'])) :?>
                                    <img src="<?php echo esc_url($item['icon_img']['url']);?>" alt="<?php if(!empty($item['icon_img']['alt'])){ echo esc_attr($item['icon_img']['alt']);}else{esc_attr_e('List', 'goyto-plugin');}?>">
                                <?php else:?>
                                    <?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                <?php endif;?>
                                <?php echo wp_kses($item['title'], true);?>
                            </li>
                        <?php endforeach;?>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
