<?php 
    $this->add_render_attribute( 'title', 'class', 'elementor-gt-heading section_title tx-split-text split-in-right' );
    if ( ! empty( $settings['btn_link']['url'] ) ) {
        $this->add_link_attributes( 'btn_link', $settings['btn_link'] );
    }
?>
<section id="gt-offer" class="gt-offer-section position-relative">

    <?php if(!empty($settings['banner_img'])):?>
        <span class="gt-offer-img1 appear_left position-absolute">
            <img src="<?php echo esc_url($settings['banner_img']['url']);?>" alt="<?php if(!empty($settings['banner_img']['alt'])){ echo esc_url($settings['banner_img']['alt']);}?>">
        </span>
    <?php endif;?>
    <?php if(!empty($settings['banner_img2'])):?>
        <span class="gt-offer-img2  appear_right position-absolute"><img src="<?php echo esc_url($settings['banner_img2']['url']);?>" alt="<?php if(!empty($settings['banner_img2']['alt'])){ echo esc_url($settings['banner_img2']['alt']);}?>"></span>
    <?php endif;?>
    <?php if(!empty($settings['banner_img3'])):?>
        <div class="gt-offer-shape txt_item_active position-absolute"><img src="<?php echo esc_url($settings['banner_img3']['url']);?>" alt="<?php if(!empty($settings['banner_img3']['alt'])){ echo esc_url($settings['banner_img3']['alt']);}?>"></div>
    <?php endif;?>
    <div class="container">
        <div class="gt-offer-concent position-relative">
            <div class="gt-offer-text-area">
                <div class="gt-section-title-2 txt-text-anim headline pera-content">
                    <div class="subtitle d-inline-block cursive-font-2 text-uppercase wow fadeInRight"  data-wow-delay="300ms" data-wow-duration="1000ms">
                        <?php if(!empty($settings['title_shape']['url'])):?>
                            <img src="<?php echo esc_url($settings['title_shape']['url']);?>" alt="<?php if(!empty($settings['title_shape']['alt'])){ echo esc_attr($settings['title_shape']['alt']);}?>"> 
                        <?php endif;?>  
                        <span><?php echo wp_kses($settings['subtitle'], true);?></span>
                        <?php if(!empty($settings['title_shape']['url'])):?>
                            <img src="<?php echo esc_url($settings['title_shape']['url']);?>" alt="<?php if(!empty($settings['title_shape']['alt'])){ echo esc_attr($settings['title_shape']['alt']);}?>"> 
                        <?php endif;?>  
                    </div>
                    <?php printf('<%1$s %2$s>%3$s</%1$s>',
                        tag_escape($settings['title_tag']),
                        $this->get_render_attribute_string('title'),
                        $settings['title']
                    ); ?>
                    <?php if($settings['desc_show'] === 'yes'):?>
                        <div class="elementor-gt-desc">
                            <?php echo wpautop($settings['description']);?>
                        </div>
                    <?php endif;?>
                </div>
                <div class="gt-btn-3 mt-35 text-uppercase">
                    <a <?php echo $this->get_render_attribute_string( 'btn_link' ); ?>><?php echo wp_kses($settings['btn_label'], true);?> </a>
                </div>
            </div>
            <?php if(!empty($settings['discount_text'])):?>
                <div class="gt-offer-amount headline position-absolute text-uppercase wow fadeInRight"  data-wow-delay="300ms" data-wow-duration="1000ms">
                    <h3><?php echo __($settings['discount_text']);?></h3>
                </div>
            <?php endif;?>
        </div>
    </div>
</section>