<?php 
    $rand__id = rand( 457788, 45785 );
    $this->add_render_attribute( 'title', 'class', 'elementor-gt-heading section_title ver_2' );
?>
<div class="gt-contact-faq-content d-flex">
    <div class="gt-faq-content">
        <div class="accordion" id="accordionExample_<?php echo esc_attr( $rand__id );?>">
            <?php foreach($settings['accordions'] as $id => $item):
                $collapsed_tab = ($id == 0) ? '' : 'collapsed';
                $area_expanded = ($id == 0) ? 'true' : 'false';
                $active_show_tab = ($id == 0) ? 'show' : '';    
                $active_show_bg = ($id == 0) ? 'faq_active' : '';    
            ?>
            <div class="accordion-item <?php echo esc_attr($active_show_bg); ?>  wow fadeInUp"  data-wow-delay="300ms" data-wow-duration="1000ms">
                <h2 class="accordion-header" id="heading<?php echo esc_attr( $rand__id );?>-<?php echo esc_attr($item['_id'] ); ?>">
                    <button class="accordion-button <?php echo esc_attr($collapsed_tab); ?>" type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo esc_attr( $rand__id );?>-<?php echo esc_attr($item['_id'] ); ?>" aria-expanded="<?php echo esc_attr($area_expanded); ?>" aria-controls="collapse<?php echo esc_attr( $rand__id );?>-<?php echo esc_attr($item['_id'] ); ?>">
                        <span>	<?php echo wp_kses($item['title'], true);?></span>
                    </button>
                </h2>
                <div id="collapse<?php echo esc_attr( $rand__id );?>-<?php echo esc_attr($item['_id'] ); ?>" class="accordion-collapse collapse <?php echo esc_attr($active_show_tab); ?>" aria-labelledby="heading<?php echo esc_attr( $rand__id );?>-<?php echo esc_attr($item['_id'] ); ?>" data-bs-parent="#accordionExample_<?php echo esc_attr( $rand__id );?>">
                    <div class="accordion-body ">
                        <div class="gt-faq-text-img d-flex align-items-center">
                            <?php if(!empty($item['img_1']['url'])):?>
                                <div class="faq-img">
                                    <div class="inner-img">
                                        <img src="<?php echo esc_url($item['img_1']['url']);?>" alt="<?php if(!empty($item['img_1']['alt'])){ echo esc_attr($item['img_1']['alt']);}else{esc_attr_e('Shape', 'goyto-plugin');}?>">
                                    </div>
                                </div>
                            <?php endif;?>
                            <div class="faq-text pera-content ul-li-block">
                                <?php if(!empty($item['description'])):?>
                                    <p><?php echo wp_kses($item['description'], true);?></p>
                                <?php endif;?>
                                <ul>
                                    <?php 
                                        $list_item = $item['list_description'];
                                        $list_item = explode("\n", ($list_item));
                                        foreach($list_item as $list):
                                    ?>
                                        <li><i class="fas fa-arrow-alt-right"></i> <?php echo wp_kses($list, true);?></li>
                                    <?php endforeach;?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach;?>
        </div>
    </div>
    <div class="gt-contact-content-3">
        <div class="gt-section-title-1 ver_2 pera-content  headline">
            <div class="subtitle cursive-font">
                <?php if(!empty($settings['title_shape']['url'])):?>
                    <img src="<?php echo esc_url($settings['title_shape']['url']);?>" alt="<?php if(!empty($settings['title_shape']['alt'])){ echo esc_attr($settings['title_shape']['alt']);}?>"> 
                <?php endif;?>    
                <?php echo wp_kses($settings['subtitle'], true);?>
            </div>
            <?php printf('<%1$s %2$s>%3$s</%1$s>',
                tag_escape($settings['title_tag']),
                $this->get_render_attribute_string('title'),
                $settings['title']
            ); ?>
        </div>
        <?php if(!empty($settings['contact_shortcode'])):?>
            <div class="gt-contact-form mt-25">
                <?php echo do_shortcode($settings['contact_shortcode']);?>
            </div>
        <?php endif;?>
    </div>
</div>