<?php 
    $this->add_render_attribute( 'title', 'class', 'elementor-gt-heading section_title tx-split-text split-in-up' );
?>
<section id="gt-favorite-place" class="gt-favorite-place-section position-relative pt-190 pb-130" data-background="<?php echo esc_url($settings['bg_image']['url']);?>">
    <?php if(!empty($settings['image']['url'])):?>
        <div class="gt-favorite-place-img appear_right img-parallax position-absolute"><img src="<?php echo esc_url($settings['image']['url']);?>" alt="<?php if(!empty($settings['image']['alt'])){ echo esc_attr($settings['image']['alt']);}?>"></div>
    <?php endif;?>
    <div class="container">
        <div class="gt-favorite-place-content d-flex">
            <div class="gt-favorite-place-text-area">
                <div class="gt-section-title-1 ver_2 pera-content txt-text-anim headline">
                    <?php if($settings['sub_title_show'] === 'yes'):?>
                    <div class="elementor-goyto-sub subtitle cursive-font wow fadeInRight"  data-wow-delay="200ms" data-wow-duration="1000ms">
                        <?php if(!empty($settings['title_shape']['url'])):?>
                            <img src="<?php echo esc_url($settings['title_shape']['url']);?>" alt="<?php if(!empty($settings['title_shape']['alt'])){ echo esc_attr($settings['title_shape']['alt']);}?>"> 
                        <?php endif;?>    
                        <?php echo wp_kses($settings['subtitle'], true);?>
                    </div>
                <?php endif;?>
                    <?php printf('<%1$s %2$s>%3$s</%1$s>',
                        tag_escape($settings['title_tag']),
                        $this->get_render_attribute_string('title'),
                        $settings['title']
                    ); ?>
                    <?php if($settings['desc_show'] === 'yes'):?>
                        <div class="elementor-gt-desc">
                            <p><?php echo wp_kses($settings['description'], true);?></p>
                        </div>
                    <?php endif;?>
                </div>
                <?php if($settings['count_box_show'] === 'yes'):?>
                    <div class="gt-fv-discount mt-35 d-flex align-items-center wow fadeInUp"  data-wow-delay="300ms" data-wow-duration="1000ms">
                        <div class="inner-amount d-flex align-items-center justify-content-center">
                            <div class="amount-value text-center headline text-uppercase">
                                <h3><?php echo wp_kses($settings['count'], true);?></h3>
                                <span><?php echo wp_kses($settings['count_label'], true);?></span>
                            </div>
                        </div>
                        <?php if(!empty($settings['count_title'])):?>
                            <div class="inner-text">
                                <?php echo wp_kses($settings['count_title'], true);?>
                            </div>
                        <?php endif;?>
                    </div>
                <?php endif;?>

                <?php if($settings['list_show'] === 'yes'):?>
                <div class="gt-explor-visit-info mt-35 headline ul-li">
                    <ul>
                        <?php foreach($settings['lists'] as $item):?>
                        <li class="wow" data-splitting="">
                            <?php if ($item['type'] === 'image' && ($item['icon_img']['url'])) :?>
                                <img src="<?php echo esc_url($item['icon_img']['url']);?>" alt="<?php if(!empty($item['icon_img']['alt'])){ echo esc_attr($item['icon_img']['alt']);}else{esc_attr_e('List', 'goyto-plugin');}?>">
                            <?php else:?>
                                <?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                            <?php endif;?>
                            <?php echo wp_kses($item['title'], true);?>
                        </li>
                    <?php endforeach;?>
                    </ul>
                </div>
                <?php endif;?>
                <?php if($settings['btn_show'] === 'yes'):?>
                <div class="gt-btn-2 mt-25 btn-spin">
                    <a <?php echo $this->get_render_attribute_string( 'btn_link' ); ?>><?php echo wp_kses($settings['btn_label'], true);?></a>
                </div>
                <?php endif;?>
            </div>
            <div class="gt-favorite-place-item-area pt-60">
                <div class="gt-explor-slider-2 swiper-container">
                    <div class="swiper-wrapper">
                    <?php

                    $filter_query = array();

                    if (isset($_GET['location']) && $_GET['location'] !== '') {
                        $filter_query[] = array(
                            'key'     => 'tour_country',
                            'value'   => $_GET['location'],
                            'compare' => '='
                        );
                    }

                    $selected_categories_query = [];

                    $args = array(
                        'post_type'     => 'trip',
                        'posts_per_page'=> $settings['post_per_page'],
                        'order'			=> $settings['post_order'],
                    );
                    if(!empty($settings['location'][0])) {
                        $args['tax_query'] = array(
                            array(
                                'taxonomy' => 'activities',
                                'field'    => 'ids',
                                'terms'    => $settings['location']
                            )
                        );
                    }
                    if(!empty($settings['categories'][0])) {
                        $args['tax_query'] = array(
                            array(
                                'taxonomy' => 'destination',
                                'field'    => 'ids',
                                'terms'    => $settings['categories']
                            )
                        );
                    }
                    if(!empty($settings['tags'][0])) {
                        $args['tax_query'] = array(
                        array(
                            'taxonomy' => 'trip_types',
                            'field'    => 'ids',
                            'terms'    => $settings['tags'],
                        )
                        );
                    }

                    $query = new \WP_Query($args);
                    if ($query->have_posts()) :
                        $count = 0;
                        while ($query->have_posts()) : $query->the_post();
                        $goyto_tour_price = get_post_meta( get_the_ID(), 'wp_travel_engine_setting_trip_actual_price', true );
                        $goyto_tour_location = get_post_meta(get_the_ID(),'tour_location',true);
                        $goyto_tour_duration = get_post_meta( get_the_ID(), 'wp_travel_engine_setting_trip_duration', true );
                        $goyto_tour_duration_unit = get_post_meta( get_the_ID(), 'wp_travel_engine_setting', true );
                        $video_url = get_post_meta( get_the_ID(), 'wp_travel_engine_setting_enable_video_gallery', true );                        
                        $trip_post_feature_image = get_post_meta(get_the_ID(),'trip_post_feature_image',true);

                        $destination_terms = get_the_terms(get_the_ID(), 'destination');
                        if (!empty($destination_terms)) {
                            $destination = $destination_terms[0]->name;
                        } else {
                            $destination = ''; 
                        }
                        
                        $activities_terms = get_the_terms(get_the_ID(), 'activities');
                        if (!empty($activities_terms)) {
                            $activities = $activities_terms[0]->slug;
                        } else {
                            $activities = ''; 
                        }
                        $locations = get_the_terms(get_the_ID(), 'destination');

                    ?>
                        <div class="swiper-slide">
                            <div class="gt-explor-item ver_2">
                                <div class="item-img-price">
                                    <div class="inner-img">
                                        <?php the_post_thumbnail(); ?>
                                    </div>
                                    <div class="inner-price">
                                    <?php if(!empty($settings['currency'])){ echo esc_html($settings['currency']);}?> <?php echo esc_html($goyto_tour_price);?> <?php if(!empty($settings['price_label'])){ echo esc_attr($settings['price_label']); }?>
                                    </div>
                                </div>
                                <div class="item-text-area headline">
                                <?php if ($locations && !is_wp_error($locations)) {
                                    foreach ($locations as $loc) {    
                                    ?>
                                    <span class="ex-location"><i class="fas fa-map-marker-alt"></i> <?php echo esc_html( $loc->name);?></span>
                                    <?php } }?>
                                    <h3 class="ex_title"><a href="<?php the_permalink()?>"><?php the_title();?></a></h3>
                                    <div class="ex-review d-flex justify-content-between ul-li align-items-center">
                                        <span>
                                        <i class="fas fa-location-arrow"></i>
                                        <?php echo wp_kses_post($goyto_tour_duration_unit['trip_duration']);  ?> 
                                                <?php  
                                                    if($goyto_tour_duration_unit['trip_duration'] > 1){
                                                    $duration_type = isset( $goyto_tour_duration_unit[ 'trip_duration_unit' ] ) && in_array( $goyto_tour_duration_unit[ 'trip_duration_unit' ], array(
                                                        'days',
                                                        'hours',
                                                    ), true ) ? $goyto_tour_duration_unit[ 'trip_duration_unit' ] : 'days';

                                                    if ( 'hours' === $duration_type ) {
                                                        echo __('Hours', 'wp-travel-engine' );
                                                    } else {
                                                        echo __( 'Days', 'wp-travel-engine' );
                                                    }
                                                }else{
                                                    $duration_type = isset( $goyto_tour_duration_unit[ 'trip_duration_unit' ] ) && in_array( $goyto_tour_duration_unit[ 'trip_duration_unit' ], array(
                                                        'day',
                                                        'hour',
                                                    ), true ) ? $goyto_tour_duration_unit[ 'trip_duration_unit' ] : 'day';

                                                    if ( 'hour' === $duration_type ) {
                                                        echo __('Hour', 'wp-travel-engine' );
                                                    } else {
                                                        echo __( 'Day', 'wp-travel-engine' );
                                                    }
                                                }
                                                ?>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php
                            $count += 0.4;
                            endwhile;
                            wp_reset_postdata();
                            else:
                                echo '<p>No tours found.</p>';
                        endif;
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>	