<footer id="gt-footer-4" class="gt-footer-section">
    <div class="gt-footer-content-4 d-flex">
        <div class="gt-footer-content-warpper">
            <div class="gt-footer-newslatter-4 d-flex justify-content-between">
                <?php if(!empty($settings['title'])):?>
                    <div class="newsletter-text-4 headline">
                        <h3><?php echo wp_kses($settings['title'], true);?></h3>
                    </div>
                <?php endif;?>
                <?php if(!empty($settings['newsletter_shortcode'])):?>
                    <div class="newsletter-form-4">
                        <?php echo do_shortcode($settings['newsletter_shortcode']);?>
                    </div>
                <?php endif;?>
            </div>
            <div class="gt-footer-widget-area-4">
                <div class="gt-footer-widget-content-4 d-flex">
                    <div class="gt-footer-widget-4 headline pera-content">
                        <div class="logo-widget">
                            <div class="brand-logo">
                                <a href="<?php echo esc_url(home_url());?>">
                                    <img src="<?php echo esc_url($settings['footer_logo']['url']);?>" alt="<?php if(!empty($settings['footer_logo']['url'])){ echo esc_attr($settings['footer_logo']['url']);} ?>">
                                </a>
                            </div>
                            <?php if(!empty($settings['short_about'])):?>
                                <p><?php echo wp_kses($settings['short_about'], true);?></p>
                            <?php endif;?>
                            <?php if(!empty($settings['socials'])):?>
                                <div class="footer-social d-flex">
                                    <?php foreach($settings['socials'] as $item):?>
                                        <a href="<?php echo esc_url($item['link']['url']);?>">
                                            <?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                        </a>
                                    <?php endforeach;?>
                                </div>
                            <?php endif;?>
                        </div>
                    </div>
                    <div class="gt-footer-widget-4 headline">
                        <div class="menu-widget ul-li">
                            <?php if(!empty($settings['link_title'])):?>
                                <h3 class="widget-title"><span><?php echo wp_kses($settings['link_title'], true)?></span><i></i></h3>
                            <?php endif;?>
                            <ul>
                                <?php foreach($settings['links'] as $item):?>
                                    <li><a href="<?php echo esc_url($item['link']['url']);?>"><?php echo wp_kses($item['title'], true);?></a></li>
                                <?php endforeach;?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php if(!empty($settings['footer_img']['url'])):?>
            <div class="gt-footer-img-4">
                <img src="<?php echo esc_url($settings['footer_img']['url']);;?>" alt="<?php if(!empty($item['footer_img']['alt'])){ echo esc_attr($item['footer_img']['alt']);}?>">
            </div>
        <?php endif;?>
    </div>
    <?php if(!empty($settings['footer_copyright'])):?>
        <div class="gt-footer-copyright-text-4">
            <div class="container text-center pera-content">
                <p><?php echo wp_kses($settings['footer_copyright'], true);?></p>
            </div>
        </div>
    <?php endif;?>
</footer>