<?php 
if ( ! empty( $settings['website_link']['url'] ) ) {
    $this->add_link_attributes( 'btn_link', $settings['btn_link'] );
}
?>
<header id="gt-header" class="gt-header-section header_style_one ver_2" data-txstickyheader>
    <div class="gt-header-content d-flex justify-content-between align-items-center">
        <div class="brand-logo">
            <a href="<?php echo esc_url(home_url());?>">
                <img class="logo_site-size" src="<?php echo esc_url($settings['rzlogo']['url']);?>" alt="<?php if(!empty($settings['rzlogo']['alt'])){ echo esc_attr($settings['rzlogo']['alt']);}?>">
            </a>
        </div>
        <nav class="main-navigation clearfix ul-li">
            <?php
                echo str_replace(['menu-item-has-children', 'sub-menu'], ['dropdown', 'dropdown-menu clearfix'], wp_nav_menu( array(
                    'echo'           => false,
                    'menu' => !empty($settings['choose-menu']) ? $settings['choose-menu'] : 'menu-1',
                    'menu_id'        =>'main-nav',
                    'menu_class'        =>'nav navbar-nav clearfix',
                    'container'=>false,
                    'fallback_cb'    => 'Navwalker_Class::fallback',
                    'walker'         => class_exists( 'Rs_Mega_Menu_Walker' ) ? new \Rs_Mega_Menu_Walker : '',
                )) );
            ?>
        </nav>
            <div class="header-cta-btn">
                <?php if(!empty($settings['btn_label'])):?>
                    <a <?php echo $this->get_render_attribute_string( 'btn_link' ); ?>>
                    <?php 
                        if($settings['btn_icon_enable'] === 'yes'){
                            \Elementor\Icons_Manager::render_icon( $settings['btn_icon'], [ 'aria-hidden' => 'true' ] ); 
                        }                    
                    ?>
                    <span><?php echo esc_html($settings['btn_label']);?></span></a>
                <?php endif;?>
                <button class="search-btn"> <i class="far fa-search"></i></button>
                <button class="mobile-menu-btn mobile_menu_button open_mobile_menu"> <?php echo esc_html__( 'MENU', 'goyto-plugin' );?></button>
            </div>
    </div>
</header>
<?php $this->__mobile_menu(); $this->___search_body();?>