<?php 
    if ( ! empty( $settings['btn_link']['url'] ) ) {
        $this->add_link_attributes( 'btn_link', $settings['btn_link'] );
    }
?>
<section id="gt-banner-2" class="gt-banner-section-2 position-relative">
    <div class="gt-banner-img position-absolute">
        <div class="background_overlay"></div>
        <video autoplay muted loop playsinline preload="metadata"><source src="<?php echo esc_url($settings['video_link']);?>" type="video/mp4">
			</video>
    </div>
    <?php if(!empty($settings['hero_img']['url'])):?>
        <div class="gt-banner-img-2 position-absolute">
            <img src="<?php echo esc_url($settings['hero_img']['url']);?>" alt="<?php if(!empty($item['hero_img']['alt'])){ echo esc_attr($item['hero_img']['alt']);}?>">
        </div>
    <?php endif;?>
    <div class="gt-banner-content-2">
        <div class="container">
            <div class="gt-banner-text-2 headline">
                <?php if(!empty($settings['sub_title'])):?>
                    <div class="gt-banner-slug cursive-font">
                        <?php echo wp_kses($settings['sub_title'], true);?>
                    </div>
                <?php endif;?>
                <h1 class="banner_title cd-headline clip is-full-width">
                        <?php echo wp_kses($settings['title'], true);?> <span class="cd-words-wrapper">
                        <?php $i =0; foreach($settings['infos'] as $item): $i++?>
                            <b <?php if($i == 1):?> class="is-visible" <?php endif;?>><?php echo esc_html($item['title']);?></b>
                        <?php endforeach;?>
                    </span>
                </h1>
            </div>
            <div class="gt-banner-search-bar position-relative">
                <form action="<?php echo esc_url(home_url( '/' ));?>">
                    <input type="text" name="search" placeholder="<?php esc_attr_e( 'Where are you going?', 'goyto-plugin' );?>" value="<?php echo get_search_query();?>">
                    <button type="submit"><i class="far fa-search"></i></button>
                </form>
            </div>
            <div class="gt-banner-tour-type d-flex mt-60">
                <div class="gt-section-title-1 headline pt-40">
                    <?php if(!empty($settings['cate_sub_title'])):?>
                        <div class="subtitle cursive-font wow fadeInRight"  data-wow-delay="200ms" data-wow-duration="1000ms">
                            <?php if(!empty($settings['cate_sub_icon']['url'])):?>
                                <img src="<?php echo esc_url($settings['cate_sub_icon']['url']);?>" alt="<?php if(!empty($item['cate_sub_icon']['alt'])){ echo esc_attr($item['cate_sub_icon']['alt']);}?>"> 
                            <?php endif;?>
                            <?php echo wp_kses($settings['cate_sub_title'], true);?>
                        </div>
                    <?php endif;?>
                    <?php if(!empty($settings['cate_title'])):?>
                        <h2 class="section_title tx-split-text split-in-scale"><?php echo wp_kses($settings['cate_title'], true);?></h2>
                    <?php endif;?>
                    <?php if(!empty($settings['btn_label'])):?>
                        <div class="gt-btn-2 mt-30 btn-spin ">
                            <a <?php echo $this->get_render_attribute_string( 'btn_link' ); ?> href="<?php ?>"><?php echo esc_html($settings['btn_label']);?></a>
                        </div>
                    <?php endif;?>
                </div>
                <div class="gt-banner-tour-type-content d-flex">
                    <?php foreach($settings['locations'] as $item):?>
                        <div class="gt-tour-type-item wow fadeInUp"  data-wow-delay="200ms" data-wow-duration="1000ms">
                            <?php if(!empty($item['image']['url'])):?>
                                <div class="inner-img">
                                    <img src="<?php echo esc_url($item['image']['url']);?>" alt="<?php if(!empty($item['image']['alt'])){ echo esc_attr($item['image']['alt']);}?>">
                                </div>
                            <?php endif;?>
                            <div class="inner-text d-flex align-items-center headline">
                                <div class="tr-icon d-flex align-items-center justify-content-center">
                                    <?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                </div>
                                <div class="tr-text">
                                    <?php if(!empty($item['title'])):?>
                                        <h3><a href="<?php echo esc_url($item['link']['url']);?>"><?php echo esc_html($item['title']);?></a></h3>
                                    <?php endif;?>
                                    <?php if(!empty($item['desitnation'])):?>
                                        <span><?php echo wp_kses($item['desitnation'], true);?></span>
                                    <?php endif;?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach;?>
                </div>
            </div>
        </div>
    </div>
</section>