<?php 
$this->add_render_attribute( 'title', 'class', 'elementor-gt-heading txt-banner-title banner-title-text banner_title' );
?>
<section id="gt-banner" class="gt-banner-section txt_item_active position-relative">
    <?php if(!empty($settings['shape1']['url'])):?>
        <div class="gt-banenr-shape1 position-absolute"><img src="<?php echo esc_url($settings['shape1']['url']);?>" alt="<?php if(!empty($settings['shape1']['alt'])){ echo esc_attr($settings['shape1']['alt']);}?>"></div>
    <?php endif;?>

    <?php if(!empty($settings['shape2']['url'])):?>
        <div class="gt-banenr-shape2 position-absolute"><img src="<?php echo esc_url($settings['shape2']['url']);?>" alt="<?php if(!empty($settings['shape2']['alt'])){ echo esc_attr($settings['shape2']['alt']);}?>"></div>
    <?php endif;?>

    <?php if(!empty($settings['shape3']['url'])):?>
        <div class="gt-banenr-shape3 position-absolute"><img src="<?php echo esc_url($settings['shape3']['url']);?>" alt="<?php if(!empty($settings['shape3']['alt'])){ echo esc_attr($settings['shape3']['alt']);}?>"></div>
    <?php endif;?>
    <div class="gt-banner-content txt_item_active position-relative">
        <div class="container">
            <div class="gt-banner-text headline pera-content txt-banner-anim">
                <?php if($settings['sub_title_show'] === 'yes'):?>
                    <div class="elementor-goyto-sub gt-cursive-text cursive-font wow fadeInRight"  data-wow-delay="200ms" data-wow-duration="1000ms">
                        <?php if(!empty($settings['title_shape']['url'])):?>
                            <img src="<?php echo esc_url($settings['title_shape']['url']);?>" alt="<?php if(!empty($settings['title_shape']['alt'])){ echo esc_attr($settings['title_shape']['alt']);}?>"> 
                        <?php endif;?>
                        <?php echo wp_kses($settings['subtitle'], true);?>
                    </div>
                <?php endif;?>

                <?php if($settings['title_show'] === 'yes'):?>
                    <?php printf('<%1$s %2$s>%3$s</%1$s>',
                        tag_escape($settings['title_tag']),
                        $this->get_render_attribute_string('title'),
                        $settings['title']
                    ); ?>
                <?php endif;?>

                <?php if($settings['desc_show'] === 'yes'):?>
                    <div class="elementor-gt-desc">
                        <p><?php echo wp_kses($settings['description'], true);?></p>
                    </div>
                <?php endif;?>
                <div class="gt-play-btn-grp mt-55 d-flex align-items-center wow fadeInUp"  data-wow-delay="800ms" data-wow-duration="1000ms">
                    <?php 
                        if ( ! empty( $settings['btn_link']['url'] ) ) {
                            $this->add_link_attributes( 'btn_link', $settings['btn_link'] );
                        }
                    ?>
                    <?php if($settings['btn_show'] === 'yes'):?>
                        <div class="gt-btn-1 btn-spin text-uppercase">
                            <a <?php echo $this->get_render_attribute_string( 'btn_link' ); ?>><?php echo wp_kses($settings['btn_label'], true);?></a>
                        </div>
                    <?php endif;?>

                    <?php if($settings['video_show'] === 'yes'):?>
                    <div class="gt-play">
                        <a class="d-flex align-items-center video_box" href="<?php echo esc_url($settings['video_link']['url']);?>">
                            <i class="fas fa-play"></i>
                            <span><?php echo wp_kses($settings['video_text'], true);?></span>
                        </a>
                    </div>
                    <?php endif;?>
                </div>
            </div>
        </div>
        <?php if(!empty($settings['hero_image']['url'])):?>
            <div class="gt-banner-img position-absolute">
                <img src="<?php echo esc_url($settings['hero_image']['url']);?>" alt="<?php if(!empty($settings['hero_image']['alt'])){ echo esc_attr($settings['hero_image']['alt']);}?>">
            </div>
        <?php endif;?>
    </div> 
</section>    