<?php 
    $this->add_render_attribute( 'title', 'class', 'elementor-gt-heading gt-hero-8-title tx-split-text split-in-right' );
    if ( ! empty( $settings['btn_link']['url'] ) ) {
        $this->add_link_attributes( 'btn_link', $settings['btn_link'] );
    }
?>
<div class="gt-hero-8-area txt_item_active img-parallax" data-background="<?php echo esc_url($settings['hero_bg']['url']);?>">
    <?php if(!empty($settings['shape1']['url'])):?>
        <div class="section-bg-1">
            <img src="<?php echo esc_url($settings['shape1']['url']);?>" alt="<?php if(!empty($settings['shape1']['alt'])){ echo esc_attr($settings['shape1']['alt']);}?>">
        </div>
    <?php endif;?>
    <?php if(!empty($settings['shape2']['url'])):?>
        <div class="skey-img">
            <img src="<?php echo esc_url($settings['shape2']['url']);?>" alt="<?php if(!empty($settings['shape2']['alt'])){ echo esc_attr($settings['shape2']['alt']);}?>">
        </div>
    <?php endif;?>
    <?php if(!empty($settings['shape3']['url'])):?>
        <div class="biman-img">
            <img src="<?php echo esc_url($settings['shape3']['url']);?>" alt="<?php if(!empty($settings['shape3']['alt'])){ echo esc_attr($settings['shape3']['alt']);}?>">
        </div>
    <?php endif;?>

    <?php if(!empty($settings['shape4']['url'])):?>
        <div class="shape-1">
            <img src="<?php echo esc_url($settings['shape4']['url']);?>" alt="<?php if(!empty($settings['shape4']['alt'])){ echo esc_attr($settings['shape4']['alt']);}?>">
        </div>
    <?php endif;?>

    <div class="container">
        <div class="gt-hero-8-wrap">
            <div class="gt-hero-8-left">
                <div class="main-img-wrap">

                    <?php if(!empty($settings['shape5']['url'])):?>
                        <div class="main-img">
                            <img src="<?php echo esc_url($settings['shape5']['url']);?>" alt="<?php if(!empty($settings['shape5']['alt'])){ echo esc_attr($settings['shape5']['alt']);}?>">
                        </div>
                    <?php endif;?>
                    <?php if(!empty($settings['shape6']['url'])):?>
                        <div class="main-img-bg">
                            <img src="<?php echo esc_url($settings['shape6']['url']);?>" alt="<?php if(!empty($settings['shape6']['alt'])){ echo esc_attr($settings['shape6']['alt']);}?>">
                        </div>
                    <?php endif;?>
                </div>
                <?php if(!empty($settings['shape7']['url'])):?>
                    <div class="shape-2">
                        <img src="<?php echo esc_url($settings['shape7']['url']);?>" alt="<?php if(!empty($settings['shape7']['alt'])){ echo esc_attr($settings['shape7']['alt']);}?>">
                    </div>
                <?php endif;?>
                <?php if(!empty($settings['shape8']['url'])):?>
                    <div class="shape-3">
                        <img src="<?php echo esc_url($settings['shape8']['url']);?>" alt="<?php if(!empty($settings['shape8']['alt'])){ echo esc_attr($settings['shape8']['alt']);}?>">
                    </div>
                <?php endif;?>
            </div>
            <div class="gt-hero-8-right">
                <?php if($settings['sub_title_show'] === 'yes'):?>
                    <h5 class="gt-subtitle-8"><?php echo wp_kses($settings['subtitle'], true);?></h5>
                <?php endif;?>
                <?php if($settings['title_show'] === 'yes'):?>
                    <?php printf('<%1$s %2$s>%3$s</%1$s>',
                        tag_escape($settings['title_tag']),
                        $this->get_render_attribute_string('title'),
                        __($settings['title'])
                    ); ?>
                <?php endif;?>
                <div class="content">
                    <?php if($settings['video_show'] === 'yes'):?>
                        <a href="<?php echo esc_url($settings['video_link']['url']);?>" class="video-popoup video_box">
                            <?php if(!empty($settings['video_img']['url'])):?>
                                <div class="img">
                                    <img src="<?php echo esc_url($settings['video_img']['url']);?>" alt="<?php if(!empty($settings['video_img']['alt'])){ echo esc_attr($settings['video_img']['alt']);}?>">
                                </div>
                            <?php endif;?>
                            <span class="icon-1"><i class="fas fa-play"></i></span>
                        </a>
                    <?php endif;?>
                    <?php if($settings['desc_show'] === 'yes'):?>
                        <div class="elementor-gt-desc gt-para-8 disc">
                            <p><?php echo wp_kses($settings['description'], true);?></p>
                        </div>
                    <?php endif;?>
                </div>
                <?php if($settings['btn_show'] === 'yes'):?>
                    <div class="btn-wrap">
                        <a <?php echo $this->get_render_attribute_string( 'btn_link' ); ?> class="gt-btn-8">
                            <span class="btn-icon-1"><i class="flaticon-plane"></i></span>
                            <span class="btn-text"><?php echo wp_kses($settings['btn_label'], true);?></span>
                            <span class="btn-icon"><i class="flaticon-plane"></i></span>
                        </a>
                    </div>
                <?php endif;?>
                <div class="content-bottom">
                    <div class="customer">
                        <h3 class="number"><span class="counter">100</span>K</h3>
                        <span class="title">Happy Customers</span>
                    </div>
                    <div class="review">
                        <h3 class="number"><span class="counter">1.6</span>M</h3>
                        <div class="review-star">
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                        </div>
                    </div>
                </div>
                <form action="#" class="hero-form wow fadeInUp" data-wow-duration="1s" data-wow-delay="1s">
                    <div class="option_action">
                        <h5 class="label">Place <span class="req">*</span></h5>
                        <select>
                            <option>Where To Next?</option>
                            <option>London</option>
                            <option>Paris</option>
                            <option>New York</option>
                        </select>
                    </div>
                    <div class="option_action">
                        <h5 class="label">Check In / Check Out <span class="req">*</span></h5>
                        <select>
                            <option>Check In /  Out</option>
                            <option>Check Out /  In</option>
                        </select>
                    </div>
                    <div class="option_action">
                        <h5 class="label">Travellers <span class="req">*</span></h5>
                        <select>
                            <option>2 Person / 1 Kid</option>
                            <option>3 Person / 1 Kid</option>
                            <option>4 Person / 1 Kid</option>
                            <option>4 Person / 2 Kid</option>
                            <option>5 Person / 2 Kid</option>
                        </select>
                    </div>
                    <button class="btn-submit" type="submit">Plan A Trip</button>
                </form>
            </div>
        </div>
    </div>
</div>