<?php 
    $this->add_render_attribute( 'title', 'class', 'elementor-gt-heading section_title tx-split-text split-in-right' );
?>
<section id="gt-explore-world" class="gt-explore-world-section">
    <div class="gt-explore-world-content d-flex position-relative justify-content-between">
        <?php if(!empty($settings['shape_1']['url'])):?>
            <span class="gt-explor-world-img appear_left position-absolute">
                <img src="<?php echo esc_url($settings['shape_1']['url']);?>" alt="<?php if(!empty($settings['shape_1']['alt'])){ echo esc_attr($settings['shape_1']['alt']);}?>">
            </span>
        <?php endif;?>

        <?php if(!empty($settings['shape_2']['url'])):?>
            <span class="gt-explor-world-shape appear_top position-absolute">
                <img src="<?php echo esc_url($settings['shape_2']['url']);?>" alt="<?php if(!empty($settings['shape_2']['alt'])){ echo esc_attr($settings['shape_2']['alt']);}?>">
            </span>
        <?php endif;?>

        <div class="gt-explore-world-text-area position-relative">
            <div class="gt-explore-world-text-wrap">
                <div class="gt-section-title-1  headline-3 pera-content">
                    <?php if($settings['sub_title_show'] === 'yes'):?>
                        <div class="elementor-goyto-sub subtitle cursive-font wow fadeInRight"  data-wow-delay="200ms" data-wow-duration="1000ms">
                            <?php if(!empty($settings['title_shape']['url'])):?>
                                <img src="<?php echo esc_url($settings['title_shape']['url']);?>" alt="<?php if(!empty($settings['title_shape']['alt'])){ echo esc_attr($settings['title_shape']['alt']);}?>"> 
                            <?php endif;?>    
                            <?php echo wp_kses($settings['subtitle'], true);?>
                        </div>
                    <?php endif;?>
                        <?php printf('<%1$s %2$s>%3$s</%1$s>',
                            tag_escape($settings['title_tag']),
                            $this->get_render_attribute_string('title'),
                            $settings['title']
                        ); ?>
                    <?php if($settings['desc_show'] === 'yes'):?>
                        <div class="elementor-gt-desc">
                            <?php echo wpautop($settings['description']);?>
                        </div>
                    <?php endif;?>
                </div> 
                <div class="gt-explore-world-list ul-li">
                    <ul>
                        <?php foreach($settings['buttons'] as $item):?>
                        <li>
                            <a href="<?php echo esc_url($item['btn_link']['url']);?>">
                                <?php if ($item['type'] === 'image' && ($item['icon_img']['url'])) :?>
                                    <img src="<?php echo esc_url($item['icon_img']['url']);?>" alt="<?php if(!empty($item['icon_img']['alt'])){ echo esc_attr($item['icon_img']['alt']);}else{esc_attr_e('List', 'goyto-plugin');}?>">
                                <?php else:?>
                                    <?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                <?php endif;?>
                                <?php echo wp_kses($item['btn_label'], true);?>
                            </a>
                        </li>
                        <?php endforeach;?>
                    </ul>
                </div>
            </div>
            <?php if(!empty($settings['btn_label'])):?>                 
                <div class="gt-btn-3 ver_2  d-flex justify-content-end text-uppercase">
                    <a href="<?php echo esc_url($settings['btn_link']['url']);?>">
                        <?php echo wp_kses($settings['btn_label'], true);?>
                        <?php if(!empty($settings['btn_icon']['url'])):?>
                            <img src="<?php echo esc_url($settings['btn_icon']['url']);?>" alt="<?php if(!empty($settings['btn_icon']['alt'])){ echo esc_attr($settings['btn_icon']['alt']);}?>">
                        <?php endif;?>
                    </a>
                </div>
            <?php endif;?>
        </div>
        <div class="gt-explore-world-feed-area lenis lenis-smooth">
            <div class="row">
            <?php
            $args = array(
                'post_type' => 'trip',    
                'posts_per_page'=> $settings['post_per_page'],
                'order'			=> $settings['post_order'],
                'post__in'      => $settings['selected_trip'],
                'post__not_in'  => $settings['exclude_trip'],
            );

            if(!empty($settings['activities'][0])) {
                $args['tax_query'] = array(
                    array(
                        'taxonomy' => 'activities',
                        'field'    => 'ids',
                        'terms'    => $settings['activities']
                    )
                );
            }
            if(!empty($settings['destination'][0])) {
                $args['tax_query'] = array(
                    array(
                        'taxonomy' => 'destination',
                        'field'    => 'ids',
                        'terms'    => $settings['destination']
                    )
                );
            }

            $query = new \WP_Query( $args );

            if ($query->have_posts()) :
                $count = 0;
                while ($query->have_posts()) : $query->the_post();
                $goyto_tour_price = get_post_meta( get_the_ID(), 'wp_travel_engine_setting_trip_actual_price', true );
                $goyto_tour_location = get_post_meta(get_the_ID(),'tour_location',true);
                $goyto_tour_duration = get_post_meta( get_the_ID(), 'wp_travel_engine_setting_trip_duration', true );
                $goyto_tour_duration_unit = get_post_meta( get_the_ID(), 'wp_travel_engine_setting', true );
                $video_url = get_post_meta( get_the_ID(), 'wp_travel_engine_setting_enable_video_gallery', true );
                $goyto_tour_ratings = get_post_meta(get_the_ID(),'tour_ratings',true);
                $trip_post_feature_image = get_post_meta(get_the_ID(),'trip_post_feature_image',true);


                $destination_terms = get_the_terms(get_the_ID(), 'destination');
                if (!empty($destination_terms)) {
                    $destination = $destination_terms[0]->name;
                } else {
                    $destination = ''; 
                }
                
                $activities_terms = get_the_terms(get_the_ID(), 'activities');
                if (!empty($activities_terms)) {
                    $activities = $activities_terms[0]->slug;
                } else {
                    $activities = ''; 
                }
                $locations = get_the_terms(get_the_ID(), 'destination');
            ?>         
                <div class="col-md-6 wow fadeInUp"  data-wow-delay="200ms" data-wow-duration="1000ms">
                    <div class="gt-explore-world-item">
                        <div class="item-img-area  position-relative">
                            <div class="inner-img">
                                <?php the_post_thumbnail(); ?>
                            </div>
                            <div class="item-location position-absolute">
                                <i class="fas fa-map-marker-alt"></i> <?php if ($locations && !is_wp_error($locations)) {
                                    foreach ($locations as $loc) {    
                                ?>
                                <?php echo esc_html( $loc->name);?>
                                <?php } }?>
                            </div>
                        </div>
                        <div class="item-text-area headline-3">
                            <h3 class="desti_title"><a href="<?php the_permalink()?>"><?php the_title();?></a></h3>
                            <div class="item-text-bottom-area headline-3 d-flex align-items-center justify-content-between">
                                <div class="item-desti-price">
                                    <?php if(!empty($settings['price_label'])):?>
                                        <span><?php echo esc_html($settings['price_label']);?></span>
                                    <?php endif;?>
                                    <h3><?php if(!empty($settings['currency'])){ echo esc_html($settings['currency']);}?><?php echo esc_html($goyto_tour_price);?></h3>
                                </div>
                                <div class="item-desti-tour">
                                    <h3>
                                    <?php echo wp_kses_post($goyto_tour_duration_unit['trip_duration']);  ?> 
                                    <?php  
                                        if($goyto_tour_duration_unit['trip_duration'] > 1){
                                        $duration_type = isset( $goyto_tour_duration_unit[ 'trip_duration_unit' ] ) && in_array( $goyto_tour_duration_unit[ 'trip_duration_unit' ], array(
                                            'days',
                                            'hours',
                                        ), true ) ? $goyto_tour_duration_unit[ 'trip_duration_unit' ] : 'days';

                                        if ( 'hours' === $duration_type ) {?>
                                            <span><?php echo __('Hours', 'wp-travel-engine' );?></span>
                                            <?php 
                                        } else {?>

                                            <span><?php echo __( 'Days', 'wp-travel-engine' );?></span>
                                            <?php 
                                        }
                                    }else{
                                        $duration_type = isset( $goyto_tour_duration_unit[ 'trip_duration_unit' ] ) && in_array( $goyto_tour_duration_unit[ 'trip_duration_unit' ], array(
                                            'day',
                                            'hour',
                                        ), true ) ? $goyto_tour_duration_unit[ 'trip_duration_unit' ] : 'day';

                                        if ( 'hour' === $duration_type ) { ?>
                                            <span><?php echo __('Hour', 'wp-travel-engine' );?></span>
                                        <?php
                                        } else { ?>

                                            <span><?php echo __( 'Day', 'wp-travel-engine' );?></span>
                                            <?php
                                        }
                                    }
                                    ?>
                                    </h3>
                                </div>
                                <div class="item-desti-link">
                                    <a href="<?php the_permalink()?>"><i class="far fa-long-arrow-right"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php
                $count += 0.4;
                    endwhile;
                    wp_reset_postdata();
                    else:
                        echo '<p>No tours found.</p>';
                endif;
                ?>
            </div>
        </div>
    </div>
    </section>