<div class="gt-pricing-8-card <?php if($settings['active'] === 'yes'){ echo esc_attr('active');}?> ">
    <div class="card-left">
        <div class="price-box">
            <h4 class="price"><?php echo esc_html($settings['currency']);?><?php echo esc_html($settings['price']);?></h4>
            <span class="price-type"><?php echo esc_html($settings['period']);?></span>
        </div>
        <div class="plan">
            <h5 class="title"><?php echo wp_kses($settings['title'], true);?></h5>
            <?php if(!empty($settings['description'])):?>
                <p class="disc"><?php echo wp_kses($settings['description'], true);?></p>
            <?php endif;?>
            <?php if(!empty($settings['btn_label'])):?>
                <a <?php echo $this->get_render_attribute_string( 'btn_link' ); ?> class="pricing-btn">
                    <?php echo esc_html($settings['btn_label']);?>
                </a>
            <?php endif;?>
        </div>
    </div>
    <div class="card-list">
        <ul class="list-unstyled">
            <?php foreach($settings['lists'] as $item):?>
                <li>
                    <?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                    <span><?php echo wp_kses($item['title'], true);?></span>
                </li>
            <?php endforeach;?>
        </ul>
    </div>
</div>