<section id="gt-slider-7" class="gt-slider-section-7">
    <div class="gt-slider-area-7 swiper-container">
        <div class="swiper-wrapper">
            <?php foreach($settings['sliders'] as $item):?>
            <div class="swiper-slide">
                <div class="gt-slide-item-7 position-relative">
                    <span class="slide-text-1 position-absolute"><?php echo esc_html($item['title']);?></span>
                    <span class="slide-text-2 position-absolute"> <?php echo esc_html($item['title']);?></span>
                    <?php if(!empty($item['slider_bg']['url'])):?>
                        <div class="slide-item-img position-absolute">
                            <img src="<?php echo esc_url($item['slider_bg']['url']);?>" alt="<?php if(!empty($item['slider_bg']['alt'])){ echo esc_attr($item['alt']);}?>">
                        </div>
                    <?php endif;?>
                    <div class="slide-item-text headline text-center">
                        <h2 class="text-uppercase"><?php echo esc_html($item['sub_title']);?></h2>
                        <h1><?php echo esc_html($item['title']);?></h1>
                        <?php if(!empty($item['btn_label'])):?>
                            <div class="slider-btn text-uppercase">
                                <a href="<?php echo esc_url($item['btn_link']['url']);?>"><?php echo esc_html($item['btn_label']);?> 
                                    <?php if(!empty($item['btn_arrow']['url'])):?>
                                        <img src="<?php echo esc_url($item['btn_arrow']['url']);?>" alt="">
                                    <?php endif;?>
                                </a>
                            </div>
                        <?php endif;?>
                    </div>
                </div>
            </div>
            <?php endforeach;?>
        </div>
        <div class="gt-main-slider-nav-2 d-flex align-items-center">
            <div class="gt-main-prev-7 slider-arrow d-flex justify-content-center align-items-center"><i class="fas fa-long-arrow-left"></i></div>
            <div class="gt-main-next-7 slider-arrow d-flex justify-content-center align-items-center"><i class="fas fa-long-arrow-right"></i></div>
        </div>
    </div>
</section>