<section id="gt-slider-6" class="gt-slider-section-6 position-relative">
    <div class="gt-slider-area-6 swiper-container position-relative">
        <div class="swiper-wrapper">
            <?php foreach($settings['sliders'] as $item):?>
            <div class="swiper-slide">
                <div class="gt-slider-item-6 position-relative">
                    <?php if(!empty($item['slider_bg']['url'])):?>
                        <div class="gt-slider-img-6">
                            <img src="<?php echo esc_url($item['slider_bg']['url']);?>" alt="<?php if(!empty($item['slider_bg']['url'])){ echo esc_attr($item['slider_bg']['alt']);}?>">
                        </div>
                    <?php endif;?>
                    <div class="gt-slider-text-6 headline-3 text-center">
                        <h2><?php echo wp_kses($item['sub_title'], true);?></h2>
                        <h1 class="text-uppercase"><?php echo wp_kses($item['title'], true);?></h1>
                    </div>
                </div>
            </div>
            <?php endforeach;?>
            
        </div>
        <div class="gt-main-slider-nav d-flex align-items-center">
            <div class="gt-main-prev-6 d-flex justify-content-center align-items-center"><i class="fas fa-chevron-left"></i></div>
            <div class="gt-main-next-6 d-flex justify-content-center align-items-center"><i class="fas fa-chevron-right"></i></div>
        </div>
    </div>
    <div class="gt-slider-search-box">
        <form action="<?php echo esc_url( wp_travel_engine_get_page_permalink( 'search' ) ); ?>">
            <div class="gt-booking-option-2  d-flex align-items-center justify-content-between">
                <div class="option_action ver_3 position-relative headline-3">
                    <?php if(!empty($settings['location_label'])):?>
                        <h3><?php echo wp_kses($settings['location_label'], true)?></h3>
                    <?php endif;?>
                    <div class="action-icon d-flex align-items-center justify-content-center position-absolute"><?php \Elementor\Icons_Manager::render_icon( $settings['l_icon'], [ 'aria-hidden' => 'true' ] ); ?></div>
                    <select name="destination">
                    <?php if(!empty($settings['l_d_value'])):?>
                        <option value=""><?php echo wp_kses($settings['l_d_value'], true)?></option>
                    <?php endif;?>
                        <?php
                            // Get all terms from the "destination" taxonomy
                            $terms = get_terms( array(
                                'taxonomy' => 'destination',
                                'hide_empty' => false,
                            ) );

                            // Loop through each term and create an option for the select dropdown
                            foreach ( $terms as $term ) {
                                echo '<option value="' . $term->slug . '">' . $term->name . '</option>';
                            }
                        ?>
                    </select>
                </div>
                <div class="option_action ver_3 position-relative headline-3">
                    <?php if(!empty($settings['activity_label'])):?>
                        <h3><?php echo wp_kses($settings['activity_label'], true)?></h3>
                    <?php endif;?>
                    <div class="action-icon d-flex align-items-center justify-content-center position-absolute"><?php \Elementor\Icons_Manager::render_icon( $settings['a_icon'], [ 'aria-hidden' => 'true' ] ); ?></div>
                    <select name="activities">
                        <?php if(!empty($settings['a_d_value'])):?>
                            <option value=""><?php echo wp_kses($settings['a_d_value'], true)?></option>
                        <?php endif;?>
                        <?php
                            // Get all terms from the "destination" taxonomy
                            $terms = get_terms( array(
                                'taxonomy' => 'activities',
                                'hide_empty' => false,
                            ) );

                            // Loop through each term and create an option for the select dropdown
                            foreach ( $terms as $term ) {
                                echo '<option value="' . $term->slug . '">' . $term->name . '</option>';
                            }
                        ?>
                    </select>
                </div>
                <div class="option_action ver_3 position-relative headline-3">
                    <?php if(!empty($settings['type_label'])):?>
                        <h3><?php echo wp_kses($settings['type_label'], true)?></h3>
                    <?php endif;?>
                    <div class="action-icon d-flex align-items-center justify-content-center position-absolute"><?php \Elementor\Icons_Manager::render_icon( $settings['t_icon'], [ 'aria-hidden' => 'true' ] ); ?></div>
                    <select name="trip_types">
                        <?php if(!empty($settings['t_d_value'])):?>
                            <option value=""><?php echo wp_kses($settings['t_d_value'], true)?></option>
                        <?php endif;?>
                        <?php
                            // Get all terms from the "destination" taxonomy
                            $terms = get_terms( array(
                                'taxonomy' => 'trip_types',
                                'hide_empty' => false,
                            ) );

                            // Loop through each term and create an option for the select dropdown
                            foreach ( $terms as $term ) {
                                echo '<option value="' . $term->slug . '">' . $term->name . '</option>';
                            }
                        ?>
                    </select>
                </div>
                <div class="submit-btn">
                    <button type="submit"><i class="far fa-search"></i></button>
                </div>
            </div>
        </form>
    </div>
</section> 