<div class="gt-testimonial-8-wrap">
    <div class="testimonial-action" id="nav-tab" role="tablist">
        <?php
            foreach( $settings['testimonials'] as $id => $item ) :

            $active = ($id == 0) ? 'active' : '';
            $aria_selected = ($id == 0) ? 'true' : 'false';

        ?>
        <button class="testimonial-btn <?php echo esc_attr($active); ?>" id="testimonial-1-tab<?php echo esc_attr($id); ?>" data-bs-toggle="tab" data-bs-target="#testimonial-<?php echo esc_attr($id); ?>" type="button" role="tab" aria-controls="testimonial-<?php echo esc_attr($id); ?>" aria-selected="true">
            <div class="img-wrap">
                <img src="<?php echo esc_url($item['authore']['url']);?>" alt="<?php if(!empty($item['authore']['alt'])){ echo esc_attr($item['authore']['alt']);}?>">
            </div>
            <div>
                <?php if(!empty($item['name'])):?>
                    <h5 class="title"><?php echo wp_kses($item['name'], true); ?></h5>
                <?php endif;?>
                <?php if(!empty($item['designtaion'])):?>
                    <p class="disc"><?php echo wp_kses($item['designtaion'], true); ?></p>
                <?php endif;?>
            </div>
        </button>
        <?php endforeach;?>

    </div>
    
    <!-- tab content -->
    <div class="tab-content" id="nav-tabContent">
        <?php
            foreach( $settings['testimonials'] as $id => $item ) :
            $active = ($id == 0) ? 'show active' : '';
        ?>
        <div class="tab-pane fade <?php echo esc_attr($active); ?>" id="testimonial-<?php echo esc_attr($id); ?>" role="tabpanel" aria-labelledby="testimonial-1-tab<?php echo esc_attr($id); ?>" tabindex="0">
            <div class="gt-testimonial-8-item">
                <?php if(!empty($item['authore']['url'])):?>
                <div class="main-img">
                    <img src="<?php echo esc_url($item['authore_large']['url']);?>" alt="<?php if(!empty($item['authore_large']['alt'])){ echo esc_attr($item['authore_large']['alt']);}?>">
                </div>
                <?php endif;?>
                <div class="content">
                    <span class="quote-icon">
                        <i class="flaticon-left-quote"></i>
                    </span>
                    <?php if(!empty($item['feedback'])):?>
                    <p class="quote-text"><?php echo wp_kses($item['feedback'], true); ?></p>
                    <?php endif;?>
                    <?php if($settings['rating_show'] === 'yes'):?>
                        <div class="rating">
                            <?php for($i = 0; $i < $item['rating']; $i++):?>
                                <i class="flaticon-star"></i>
                            <?php endfor;?>
                        </div>
                    <?php endif;?>
                </div>
            </div>
        </div>
        <?php endforeach;?>
    </div>
</div>