<?php 
    $this->add_render_attribute( 'title', 'class', 'elementor-gt-heading section_title ver_2 tx-split-text split-in-right' );
?>
<section id="gt-explore-event-3" class="gt-explore-event-section-3 pt-100 pb-100">
    <div class="container">
        <div class="gt-explore-event-top-content mb-40 d-flex justify-content-between align-items-end">
            <div class="gt-section-title-1 ver_2 pera-content  headline">
                <?php if($settings['sub_title_show'] === 'yes'):?>
                    <div class="elementor-goyto-sub subtitle cursive-font wow fadeInRight"  data-wow-delay="200ms" data-wow-duration="1000ms">
                        <?php if(!empty($settings['title_shape']['url'])):?>
                            <img src="<?php echo esc_url($settings['title_shape']['url']);?>" alt="<?php if(!empty($settings['title_shape']['alt'])){ echo esc_attr($settings['title_shape']['alt']);}?>"> 
                        <?php endif;?>    
                        <?php echo wp_kses($settings['subtitle'], true);?>
                    </div>
                <?php endif;?>
                <?php printf('<%1$s %2$s>%3$s</%1$s>',
                    tag_escape($settings['title_tag']),
                    $this->get_render_attribute_string('title'),
                    $settings['title']
                ); ?>
            </div>
            <div class="gt-explore-filter-btn mb-10 ul-li">
                <?php
                    $tripType = get_terms( 'trip_types', [
                        'orderby'=>'count',
                        'parent'   => 0,
                        'orderby' => 'count',
                        'order' => 'DESC',
                    ] );
                ?>
                <div class="button-group  clearfix">
                    <button class="filter-button is-checked" data-filter="*"><i class="fal fa-ball-pile"></i> All </button>
                    <?php 
                    if(!empty($tripType) && !is_wp_error($tripType)):
                    foreach($tripType as $trip):
                    ?>
                    <button class="filter-button" data-filter=".<?php echo esc_attr($trip->slug)?>"><i class="fal fa-globe-europe"></i> <?php echo esc_html($trip->name)?></button>
                    <?php endforeach; endif;?>
                </div>
            </div>
        </div>
        <div class="gt-explore-event-content-3">
            <div class="filtr-container-area grid clearfix" data-isotope="{ &quot;masonry&quot;: { &quot;columnWidth&quot;: 0 } }">
                <div class="grid-sizer"></div>
                <?php

                    $filter_query = array();

                    if (isset($_GET['location']) && $_GET['location'] !== '') {
                        $filter_query[] = array(
                            'key'     => 'tour_country',
                            'value'   => $_GET['location'],
                            'compare' => '='
                        );
                    }

                    $selected_categories_query = [];
                    $args = array(
                        'post_type'     => 'trip',
                        'posts_per_page'=> $settings['post_per_page'],
                        'order'			=> $settings['post_order'],
                    );
                    if(!empty($settings['categories'][0])) {
                        $args['tax_query'] = array(
                        array(
                            'taxonomy' => 'destination',
                            'field'    => 'ids',
                            'terms'    => $settings['categories'],
                        )
                        );
                    }
                    if(!empty($settings['location'][0])) {
                        $args['tax_query'] = array(
                        array(
                            'taxonomy' => 'activities',
                            'field'    => 'ids',
                            'terms'    => $settings['location'],
                        )
                        );
                    }
                    if(!empty($settings['tags'][0])) {
                        $args['tax_query'] = array(
                        array(
                            'taxonomy' => 'trip_types',
                            'field'    => 'ids',
                            'terms'    => $settings['tags'],
                        )
                        );
                    }
                    $query = new \WP_Query($args);

                    if ($query->have_posts()) :
                        $count = 0;
                        while ($query->have_posts()) : $query->the_post();
                        $goyto_tour_price = get_post_meta( get_the_ID(), 'wp_travel_engine_setting_trip_actual_price', true );
                        $goyto_tour_location = get_post_meta(get_the_ID(),'tour_location',true);
                        $goyto_tour_duration = get_post_meta( get_the_ID(), 'wp_travel_engine_setting_trip_duration', true );
                        $goyto_tour_duration_night = get_post_meta( get_the_ID(), 'wp_travel_engine_setting_trip_duration_nights', true );
                        $goyto_tour_duration_unit = get_post_meta( get_the_ID(), 'wp_travel_engine_setting', true );
                        $video_url = get_post_meta( get_the_ID(), 'wp_travel_engine_setting_enable_video_gallery', true );
                        $goyto_tour_ratings = get_post_meta(get_the_ID(),'tour_ratings',true);
                        $trip_post_feature_image = get_post_meta(get_the_ID(),'trip_post_feature_image',true);


                        $destination_terms = get_the_terms(get_the_ID(), 'destination');
                        if (!empty($destination_terms)) {
                            $destination = $destination_terms[0]->name;
                        } else {
                            $destination = ''; 
                        }
                        
                        $activities_terms = get_the_terms(get_the_ID(), 'activities');
                        if (!empty($activities_terms)) {
                            $activities = $activities_terms[0]->slug;
                        } else {
                            $activities = ''; 
                        }
                        $locations = get_the_terms(get_the_ID(), 'destination');
                        $tripTypes = get_the_terms(get_the_ID(), 'trip_types');

                        $tripTypeId = get_the_terms( get_the_ID(), 'trip_types' );
						if ( $tripTypeId && !is_wp_error( $tripTypeId ) ) {
							$product_cat_list = array();
							foreach ( $tripTypeId as $cate ) {
								$product_cat_list[] = $cate->slug;
							}
							$product_cate_asign_list = join( ' ', $product_cat_list );
						} else {
							$product_cate_asign_list = '';
						}
                    ?>
                <div class="grid-item grid-size-33 <?php echo esc_attr($product_cate_asign_list)?>" data-category="interiors design">
                    <div class="gt-explore-event-item">
                        <div class="explore-img-text-area headline">
                            <div class="explore-img-area position-relative">
                                <div class="inner-img">
                                    <?php the_post_thumbnail(); ?>
                                </div>
                                <div class="ex-location-rate position-absolute d-flex justify-content-between align-items-center ul-li">
                                    <?php if ($locations && !is_wp_error($locations)) {
                                        foreach ($locations as $loc) {    
                                    ?>
                                    <span><i class="fas fa-map-marker-alt"></i> <?php echo esc_html( $loc->name);?></span>
                                    <?php } }?>
                                </div>
                            </div>
                            <div class="explore-meta d-flex justify-content-between">
                                <span>
                                <i class="fas fa-location-arrow"></i>
                        <?php echo wp_kses_post($goyto_tour_duration_unit['trip_duration']);  ?> 
                                <?php  
                                    if($goyto_tour_duration_unit['trip_duration'] > 1){
                                    $duration_type = isset( $goyto_tour_duration_unit[ 'trip_duration_unit' ] ) && in_array( $goyto_tour_duration_unit[ 'trip_duration_unit' ], array(
                                        'days',
                                        'hours',
                                    ), true ) ? $goyto_tour_duration_unit[ 'trip_duration_unit' ] : 'days';

                                    if ( 'hours' === $duration_type ) {
                                        echo __('Hours', 'wp-travel-engine' );
                                    } else {
                                        echo __( 'Days', 'wp-travel-engine' );
                                    }
                                }else{
                                    $duration_type = isset( $goyto_tour_duration_unit[ 'trip_duration_unit' ] ) && in_array( $goyto_tour_duration_unit[ 'trip_duration_unit' ], array(
                                        'day',
                                        'hour',
                                    ), true ) ? $goyto_tour_duration_unit[ 'trip_duration_unit' ] : 'day';

                                    if ( 'hour' === $duration_type ) {
                                        echo __('Hour', 'wp-travel-engine' );
                                    } else {
                                        echo __( 'Day', 'wp-travel-engine' );
                                    }
                                }
                                ?>
                                </span>
                                <?php 
                                    if ($tripTypes && !is_wp_error($tripTypes)) {
                                        $tripTypesArray = array_values($tripTypes);
                                        shuffle($tripTypesArray);
                                    
                                        foreach ($tripTypesArray as $type) {    
                                    ?>
                                            <span><?php echo esc_html($type->name); ?></span>
                                    <?php 
                                        } 
                                    } 
                                ?>
                            </div>
                            <h3 class="exp_title">
                                <a href="<?php echo the_permalink()?>"><?php the_title();?></a>
                            </h3>
                        </div>
                        <div class="explore-price-btn headline d-flex justify-content-between align-items-center">
                            <div class="ex-price">
                                <span><?php if(!empty($settings['price_label'])){ echo esc_attr($settings['price_label']); }?></span>
                                <h3><?php if(!empty($settings['currency'])){ echo esc_html($settings['currency']);}?> <?php echo esc_html($goyto_tour_price);?> </h3>
                            </div>
                            <a class="ex_more" href="<?php echo the_permalink()?>">Explore Now</a>
                        </div>
                    </div>
                </div>
                <?php
                    $count += 0.4;
                    endwhile;
                    wp_reset_postdata();
                    else:
                        echo '<p>No tours found.</p>';
                endif;
                ?>
            </div>
        </div>
    </div>
</section>	