<div class="gt-travel-destination-section">
    
    <div class="gt-travel-destination-content mt-50 d-flex flex-wrap justify-content-center">
        <?php foreach($settings['tours'] as $item):?>
            <div class="travel-destination-item position-relative <?php if(!empty($item['custom_cls'])){ echo esc_attr($item['custom_cls']);}?>">

                <div class="item-img">
                    <?php if ($item['type'] === 'image' && ($item['icon_img']['url'])) :?>
                        <img src="<?php echo esc_url($item['icon_img']['url']);?>" alt="<?php if(!empty($item['icon_img']['alt'])){ echo esc_attr($item['icon_img']['alt']);}else{esc_attr_e('List', 'goyto-plugin');}?>">
                    <?php else:?>
                        <?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                    <?php endif;?>
                </div>

                <div class="item-text position-absolute headline pera-content text-center">
                    <h3 class="desti_title"><a href="<?php echo esc_url($item['link']['url']);?>"><i class="fas fa-map-marker-alt"></i><?php echo wp_kses($item['title'], true);?></a></h3>
                    <p><?php echo wp_kses($item['description'], true);?></p>
                </div>
            </div>
        <?php endforeach;?>
    </div>
    <?php if(!empty($settings['item_description'])):?>
        <div class="dest-bottom-text"><?php echo __($settings['item_description']);?></div>
    <?php endif;?>
</div>