<div class="gt-destination-sroller mt-20">
    <?php
    $args = array(
        'post_type' => 'trip',    
        'posts_per_page'=> $settings['post_per_page'],
        'order'			=> $settings['post_order'],
        'post__in'      => $settings['selected_trip'],
        'post__not_in'  => $settings['exclude_trip'],
    );

    if(!empty($settings['activities'][0])) {
        $args['tax_query'] = array(
            array(
                'taxonomy' => 'activities',
                'field'    => 'ids',
                'terms'    => $settings['activities']
            )
        );
    }
    if(!empty($settings['destination'][0])) {
        $args['tax_query'] = array(
            array(
                'taxonomy' => 'destination',
                'field'    => 'ids',
                'terms'    => $settings['destination']
            )
        );
    }

    $query = new \WP_Query( $args );

    if ($query->have_posts()) :
        $count = 0;
        while ($query->have_posts()) : $query->the_post();
        $goyto_tour_price = get_post_meta( get_the_ID(), 'wp_travel_engine_setting_trip_actual_price', true );
        $goyto_tour_location = get_post_meta(get_the_ID(),'tour_location',true);
        $goyto_tour_duration = get_post_meta( get_the_ID(), 'wp_travel_engine_setting_trip_duration', true );
        $goyto_tour_duration_unit = get_post_meta( get_the_ID(), 'wp_travel_engine_setting', true );
        $video_url = get_post_meta( get_the_ID(), 'wp_travel_engine_setting_enable_video_gallery', true );
        $goyto_tour_ratings = get_post_meta(get_the_ID(),'tour_ratings',true);
        $trip_post_feature_image = get_post_meta(get_the_ID(),'trip_post_feature_image',true);


        $destination_terms = get_the_terms(get_the_ID(), 'destination');
        if (!empty($destination_terms)) {
            $destination = $destination_terms[0]->name;
        } else {
            $destination = ''; 
        }
        
        $activities_terms = get_the_terms(get_the_ID(), 'activities');
        if (!empty($activities_terms)) {
            $activities = $activities_terms[0]->slug;
        } else {
            $activities = ''; 
        }
    ?>
    <div class="gt-top-destination-item">
        <div class="destination-img position-relative">
        <?php the_post_thumbnail(); ?>
            <div class="desti-btn-grp justify-content-center position-absolute d-flex">
            <?php echo do_shortcode("[wte_video_gallery trip_id='" . get_the_ID() . "' type='popup' label='']"); ?>

                <a href="<?php echo the_permalink()?>"><i class="far fa-link"></i></a>
            </div>
        </div>
        <div class="destination-text headline">
            <div class="dest-title-price position-relative d-flex justify-content-between align-items-center">
                <h3 class="dest_title"><a href="<?php echo the_permalink()?>"><?php the_title();?></a></h3>
                <span><?php if(!empty($settings['currency'])){ echo esc_html($settings['currency']);}?><?php echo esc_html($goyto_tour_price);?></span>
            </div>
            <div class="trip-time">
            <i class="fas fa-location-arrow"></i>
                        <?php echo wp_kses_post($goyto_tour_duration_unit['trip_duration']);  ?> 
                                <?php  
                                    if($goyto_tour_duration_unit['trip_duration'] > 1){
                                    $duration_type = isset( $goyto_tour_duration_unit[ 'trip_duration_unit' ] ) && in_array( $goyto_tour_duration_unit[ 'trip_duration_unit' ], array(
                                        'days',
                                        'hours',
                                    ), true ) ? $goyto_tour_duration_unit[ 'trip_duration_unit' ] : 'days';

                                    if ( 'hours' === $duration_type ) {
                                        echo __('Hours', 'wp-travel-engine' );
                                    } else {
                                        echo __( 'Days', 'wp-travel-engine' );
                                    }
                                }else{
                                    $duration_type = isset( $goyto_tour_duration_unit[ 'trip_duration_unit' ] ) && in_array( $goyto_tour_duration_unit[ 'trip_duration_unit' ], array(
                                        'day',
                                        'hour',
                                    ), true ) ? $goyto_tour_duration_unit[ 'trip_duration_unit' ] : 'day';

                                    if ( 'hour' === $duration_type ) {
                                        echo __('Hour', 'wp-travel-engine' );
                                    } else {
                                        echo __( 'Day', 'wp-travel-engine' );
                                    }
                                }
                                ?>
            </div>
        </div>
    </div>
    <?php
        $count += 0.4;
        endwhile;
        wp_reset_postdata();
        else:
            echo '<p>No tours found.</p>';
    endif;
    ?>
</div>