<div class="gt-explor-content position-relative">
    <div class="gt-explor-slider swiper-container">
        <div class="swiper-wrapper">
        <?php
        $args = array(
            'post_type' => 'trip',    
            'posts_per_page'=> $settings['post_per_page'],
            'order'			=> $settings['post_order'],
            'post__in'      => $settings['selected_trip'],
            'post__not_in'  => $settings['exclude_trip'],
        );

        if(!empty($settings['activities'][0])) {
            $args['tax_query'] = array(
                array(
                    'taxonomy' => 'activities',
                    'field'    => 'ids',
                    'terms'    => $settings['activities']
                )
            );
        }
        if(!empty($settings['destination'][0])) {
            $args['tax_query'] = array(
                array(
                    'taxonomy' => 'destination',
                    'field'    => 'ids',
                    'terms'    => $settings['destination']
                )
            );
        }
        if(!empty($settings['tags'][0])) {
            $args['tax_query'] = array(
            array(
                'taxonomy' => 'trip_types',
                'field'    => 'ids',
                'terms'    => $settings['tags'],
            )
            );
        }

        $query = new \WP_Query( $args );

        if ($query->have_posts()) :
            $count = 0;
            while ($query->have_posts()) : $query->the_post();
            $goyto_tour_price = get_post_meta( get_the_ID(), 'wp_travel_engine_setting_trip_actual_price', true );
            $goyto_tour_location = get_post_meta(get_the_ID(),'tour_location',true);
            $goyto_tour_duration = get_post_meta( get_the_ID(), 'wp_travel_engine_setting_trip_duration', true );
            $goyto_tour_duration_unit = get_post_meta( get_the_ID(), 'wp_travel_engine_setting', true );
            $video_url = get_post_meta( get_the_ID(), 'wp_travel_engine_setting_enable_video_gallery', true );
            $goyto_tour_ratings = get_post_meta(get_the_ID(),'tour_ratings',true);
            $trip_post_feature_image = get_post_meta(get_the_ID(),'trip_post_feature_image',true);


            $destination_terms = get_the_terms(get_the_ID(), 'destination');
            if (!empty($destination_terms)) {
                $destination = $destination_terms[0]->name;
            } else {
                $destination = ''; 
            }
            
            $activities_terms = get_the_terms(get_the_ID(), 'activities');
            if (!empty($activities_terms)) {
                $activities = $activities_terms[0]->slug;
            } else {
                $activities = ''; 
            }
            $locations = get_the_terms(get_the_ID(), 'destination');
        ?>
            <div class="swiper-slide">
                <div class="gt-explor-item">
                    <div class="item-img-price">
                        <div class="inner-img">
                            <?php the_post_thumbnail(); ?>
                        </div>
                        <div class="inner-price">
                            <?php if(!empty($settings['currency'])){ echo esc_html($settings['currency']);}?> <?php echo esc_html($goyto_tour_price);?> <?php if(!empty($settings['price_label'])){ echo esc_attr($settings['price_label']); }?>
                        </div>
                    </div>
                    <div class="item-text-area headline">
                        <?php if ($locations && !is_wp_error($locations)) {
                            foreach ($locations as $loc) {    
                        ?>
                        <span class="ex-location"><i class="fas fa-map-marker-alt"></i> <?php echo esc_html( $loc->name);?></span>
                        <?php } }?>
                        <h3 class="ex_title"><a href="<?php the_permalink()?>"><?php the_title();?></a></h3>
                        <div class="ex-review d-flex justify-content-between ul-li align-items-center">
                            <span>
                            <i class="fas fa-location-arrow"></i>
                        <?php echo wp_kses_post($goyto_tour_duration_unit['trip_duration']);  ?> 
                                <?php  
                                    if($goyto_tour_duration_unit['trip_duration'] > 1){
                                    $duration_type = isset( $goyto_tour_duration_unit[ 'trip_duration_unit' ] ) && in_array( $goyto_tour_duration_unit[ 'trip_duration_unit' ], array(
                                        'days',
                                        'hours',
                                    ), true ) ? $goyto_tour_duration_unit[ 'trip_duration_unit' ] : 'days';

                                    if ( 'hours' === $duration_type ) {
                                        echo __('Hours', 'wp-travel-engine' );
                                    } else {
                                        echo __( 'Days', 'wp-travel-engine' );
                                    }
                                }else{
                                    $duration_type = isset( $goyto_tour_duration_unit[ 'trip_duration_unit' ] ) && in_array( $goyto_tour_duration_unit[ 'trip_duration_unit' ], array(
                                        'day',
                                        'hour',
                                    ), true ) ? $goyto_tour_duration_unit[ 'trip_duration_unit' ] : 'day';

                                    if ( 'hour' === $duration_type ) {
                                        echo __('Hour', 'wp-travel-engine' );
                                    } else {
                                        echo __( 'Day', 'wp-travel-engine' );
                                    }
                                }
                                ?>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <?php
                $count += 0.4;
                endwhile;
                wp_reset_postdata();
                else:
                    echo '<p>No tours found.</p>';
            endif;
            ?>
        </div>
    </div>
    <div class="gt-explor-nav d-flex align-items-center">
        <div class="gt-explor-prev d-flex justify-content-center align-items-center"><i class="fas fa-arrow-left"></i></div>
        <div class="gt-explor-next d-flex justify-content-center align-items-center"><i class="fas fa-arrow-right"></i></div>
    </div>
    </div>