<div class="gt-top-destination-content-4 pera-content">
    <div class="gt-top-destination-scroller">
    <?php
$args = array(
    'post_type' => 'trip',
    'posts_per_page'=> $settings['post_per_page'],
    'order'			=> $settings['post_order'],
    'post__in'      => $settings['selected_trip'],
    'post__not_in'  => $settings['exclude_trip'],
);

if(!empty($settings['activities'][0])) {
    $args['tax_query'] = array(
        array(
            'taxonomy' => 'activities',
            'field'    => 'ids',
            'terms'    => $settings['activities']
        )
    );
}
if(!empty($settings['destination'][0])) {
    $args['tax_query'] = array(
        array(
            'taxonomy' => 'destination',
            'field'    => 'ids',
            'terms'    => $settings['destination']
        )
    );
}

$query = new \WP_Query( $args );
if ($query->have_posts()) :
    $count = 0;
    while ($query->have_posts()) : $query->the_post();
    $goyto_tour_price = get_post_meta( get_the_ID(), 'wp_travel_engine_setting_trip_actual_price', true );
    $goyto_tour_location = get_post_meta(get_the_ID(),'tour_location',true);
    $goyto_tour_duration_ct = get_post_meta( get_the_ID(), 'wp_travel_engine_setting_trip_duration', true );
    $goyto_tour_duration_night = get_post_meta( get_the_ID(), 'wp_travel_engine_setting_trip_duration_nights', true );
    $video_url = get_post_meta( get_the_ID(), 'wp_travel_engine_setting_enable_video_gallery', true );
    $goyto_tour_ratings = get_post_meta(get_the_ID(),'tour_ratings',true);
    $trip_post_feature_image = get_post_meta(get_the_ID(),'trip_post_feature_image',true);
    $goyto_tour_duration = get_post_meta( get_the_ID(), 'wp_travel_engine_setting_trip_duration', true );
            $goyto_tour_duration_unit = get_post_meta( get_the_ID(), 'wp_travel_engine_setting', true );

    $destination_terms = get_the_terms(get_the_ID(), 'destination');
    if (!empty($destination_terms)) {
        $destination = $destination_terms[0]->name;
    } else {
        $destination = '';
    }

    $activities_terms = get_the_terms(get_the_ID(), 'activities');
    if (!empty($activities_terms)) {
        $activities = $activities_terms[0]->slug;
    } else {
        $activities = '';
    }
    $locations = get_the_terms(get_the_ID(), 'destination');
?>
        <div class="top-destination-item-4 position-relative">
            <div class="item-img-price position-relative">
                <div class="item-img">
                    <?php the_post_thumbnail(); ?>
                </div>
                <div class="item-price position-absolute">
                    <?php if(!empty($settings['currency'])){ echo esc_html($settings['currency']);}?> <?php echo esc_html($goyto_tour_price);?>
                </div>
            </div>
            <div class="item-text-area headline pera-content position-absolute">
                <a class="more_arrow d-flex align-items-center justify-content-center" href="#"><i class="fas fa-long-arrow-right"></i></a>
                <h3 class="desti_title"><a href="<?php the_permalink()?>"><?php the_title();?></a> </h3>
                <p><?php the_excerpt();?></p>
                <div class="item-trip">
                    <a href="<?php the_permalink()?>"><i class="fas fa-location-arrow"></i>
                        <?php echo wp_kses_post($goyto_tour_duration_unit['trip_duration']);  ?> 
                                <?php  
                                    if($goyto_tour_duration_unit['trip_duration'] > 1){
                                    $duration_type = isset( $goyto_tour_duration_unit[ 'trip_duration_unit' ] ) && in_array( $goyto_tour_duration_unit[ 'trip_duration_unit' ], array(
                                        'days',
                                        'hours',
                                    ), true ) ? $goyto_tour_duration_unit[ 'trip_duration_unit' ] : 'days';

                                    if ( 'hours' === $duration_type ) {
                                        echo __('Hours', 'wp-travel-engine' );
                                    } else {
                                        echo __( 'Days', 'wp-travel-engine' );
                                    }
                                }else{
                                    $duration_type = isset( $goyto_tour_duration_unit[ 'trip_duration_unit' ] ) && in_array( $goyto_tour_duration_unit[ 'trip_duration_unit' ], array(
                                        'day',
                                        'hour',
                                    ), true ) ? $goyto_tour_duration_unit[ 'trip_duration_unit' ] : 'day';

                                    if ( 'hour' === $duration_type ) {
                                        echo __('Hour', 'wp-travel-engine' );
                                    } else {
                                        echo __( 'Day', 'wp-travel-engine' );
                                    }
                                }
                                ?></a>
                </div>
            </div>
        </div>
        <?php
            $count += 0.4;
            endwhile;
            wp_reset_postdata();
            else:
                echo '<p>No tours found.</p>';
        endif;
        ?>
    </div>
    <?php if(!empty($settings['tour_desc'])):?>
        <div class="dest-bottom-text">
            <?php echo __($settings['tour_desc']);?>
        </div>
    <?php endif;?>
</div>