<div class="gt-destination-8-area">
    <div class="gt-destination-8-wrap">
        <?php

        $args = array(
            'post_type' => 'trip',    
            'posts_per_page'=> $settings['post_per_page'],
            'order'			=> $settings['post_order'],
            'post__in'      => $settings['selected_trip'],
            'post__not_in'  => $settings['exclude_trip'],
        );

        if(!empty($settings['activities'][0])) {
            $args['tax_query'] = array(
                array(
                    'taxonomy' => 'activities',
                    'field'    => 'ids',
                    'terms'    => $settings['activities']
                )
            );
        }
        if(!empty($settings['destination'][0])) {
            $args['tax_query'] = array(
                array(
                    'taxonomy' => 'destination',
                    'field'    => 'ids',
                    'terms'    => $settings['destination']
                )
            );
        }

        $query = new \WP_Query( $args );

        if ($query->have_posts()) :
            $count = 0;
            while ($query->have_posts()) : $query->the_post();
            $goyto_tour_price = get_post_meta( get_the_ID(), 'wp_travel_engine_setting_trip_actual_price', true );
            $goyto_tour_location = get_post_meta(get_the_ID(),'tour_location',true);
            $goyto_tour_duration = get_post_meta( get_the_ID(), 'wp_travel_engine_setting_trip_duration', true );
            $goyto_tour_duration_unit = get_post_meta( get_the_ID(), 'wp_travel_engine_setting', true );
            $video_url = get_post_meta( get_the_ID(), 'wp_travel_engine_setting_enable_video_gallery', true );
            $goyto_tour_ratings = get_post_meta(get_the_ID(),'tour_ratings',true);
            $trip_post_feature_image = get_post_meta(get_the_ID(),'trip_post_feature_image',true);
            $categories = get_the_terms( get_the_ID(), 'destination' );
            $tripTypes = get_the_terms(get_the_ID(), 'trip_types');
            $destination_terms = get_the_terms(get_the_ID(), 'destination');
            if (!empty($destination_terms)) {
                $destination = $destination_terms[0]->name;
            } else {
                $destination = ''; 
            }
            
            $activities_terms = get_the_terms(get_the_ID(), 'activities');
            if (!empty($activities_terms)) {
                $activities = $activities_terms[0]->slug;
            } else {
                $activities = ''; 
            }
        ?>
        <div class="gt-destination-8-card">
            <div class="main-img">
                <?php the_post_thumbnail(); ?>
            </div>
            <div class="card-top">
                <span class="type">
                <?php echo wp_kses_post($goyto_tour_duration_unit['trip_duration']);  ?> 
                <?php  
                    if($goyto_tour_duration_unit['trip_duration'] > 1){
                    $duration_type = isset( $goyto_tour_duration_unit[ 'trip_duration_unit' ] ) && in_array( $goyto_tour_duration_unit[ 'trip_duration_unit' ], array(
                        'days',
                        'hours',
                    ), true ) ? $goyto_tour_duration_unit[ 'trip_duration_unit' ] : 'days';

                    if ( 'hours' === $duration_type ) {
                        echo __('Hours', 'wp-travel-engine' );
                    } else {
                        echo __( 'Days', 'wp-travel-engine' );
                    }
                }else{
                    $duration_type = isset( $goyto_tour_duration_unit[ 'trip_duration_unit' ] ) && in_array( $goyto_tour_duration_unit[ 'trip_duration_unit' ], array(
                        'day',
                        'hour',
                    ), true ) ? $goyto_tour_duration_unit[ 'trip_duration_unit' ] : 'day';

                    if ( 'hour' === $duration_type ) {
                        echo __('Hour', 'wp-travel-engine' );
                    } else {
                        echo __( 'Day', 'wp-travel-engine' );
                    }
                }
                ?>
                </span>
                <span class="type right-type">
                <?php 
                    if ($tripTypes && !is_wp_error($tripTypes)) {
                        $tripTypesArray = array_values($tripTypes);
                        shuffle($tripTypesArray);
                    
                        foreach ($tripTypesArray as $type) {    
                    ?>
                            <span><?php echo esc_html($type->name); ?></span>
                    <?php 
                        } 
                    } 
                ?>
                </span>
            </div>
            <div class="card-content">
                <div class="price-wrap">
                    <h5 class="price"><?php if(!empty($settings['currency'])){ echo esc_html($settings['currency']);}?><?php echo esc_html($goyto_tour_price);?> 
                        <?php if(!empty($settings['price_label'])):?>
                            <span class="person"><?php echo esc_html($settings['price_label']);?></span>
                        <?php endif;?>
                    </h5>
                </div>
                <h5 class="title">
                    <a href="<?php echo the_permalink()?>"><?php the_title();?></a>
                </h5>
                <div class="location">
                    <span class="icon">
                        <i class="flaticon-maps-and-flags"></i>
                    </span>
                    <span class="text"><?php if ( ! empty( $categories ) ) {
                                echo esc_html( $categories[0]->name );	
                            } ?></span>
                </div>
            </div>
        </div>
        <?php
            $count += 0.4;
            endwhile;
            wp_reset_postdata();
            else:
                echo '<p>No tours found.</p>';
        endif;
        ?>
    </div>
    <div class="bottom-btn-wrap">
        <span class="line-1 button-line-1"></span>
        <a href="#" class="gt-btn-8">
            <span class="btn-icon-1"><i class="flaticon-plane"></i></span>
            <span class="btn-text">View All More</span>
            <span class="btn-icon"><i class="flaticon-plane"></i></span>
        </a>
        <span class="line-2 button-line-2"></span>
    </div>
</div>