<?php 
    $this->add_render_attribute( 'title', 'class', 'elementor-gt-heading section_title tx-split-text split-in-right' );
?>
<section id="gt-working-stop" class="gt-working-stop-section pt-125 pb-90 position-relative">
    <?php if(!empty($settings['banner_img'])):?>
        <span class="gt-working-stop-img1 appear_top position-absolute"><img src="<?php echo esc_url($settings['banner_img']['url']);?>" alt="<?php if(!empty($settings['banner_img']['alt'])){ echo esc_url($settings['banner_img']['alt']);}?>"></span>
    <?php endif;?>

    <?php if(!empty($settings['banner_img2'])):?>
        <span class="gt-working-stop-img2 appear_left position-absolute">
            <img src="<?php echo esc_url($settings['banner_img2']['url']);?>" alt="<?php if(!empty($settings['banner_img2']['alt'])){ echo esc_url($settings['banner_img2']['alt']);}?>">
        </span>
    <?php endif;?>

    <?php if(!empty($settings['banner_img3'])):?>
        <div class="gt-section-bg img-parallax position-absolute"><img src="<?php echo esc_url($settings['banner_img3']['url']);?>" alt="<?php if(!empty($settings['banner_img3']['alt'])){ echo esc_url($settings['banner_img3']['alt']);}?>"></div>
    <?php endif;?>

    <div class="container">
        <div class="gt-working-stop-content">
            <div class="gt-section-title-2 headline pera-content">
                <div class="subtitle d-inline-block cursive-font-2 text-uppercase wow fadeInRight"  data-wow-delay="300ms" data-wow-duration="1000ms">
                    <?php if(!empty($settings['title_shape']['url'])):?>
                        <img src="<?php echo esc_url($settings['title_shape']['url']);?>" alt="<?php if(!empty($settings['title_shape']['alt'])){ echo esc_attr($settings['title_shape']['alt']);}?>"> 
                    <?php endif;?>  
                    <span><?php echo wp_kses($settings['subtitle'], true);?></span>
                    <?php if(!empty($settings['title_shape']['url'])):?>
                        <img src="<?php echo esc_url($settings['title_shape']['url']);?>" alt="<?php if(!empty($settings['title_shape']['alt'])){ echo esc_attr($settings['title_shape']['alt']);}?>"> 
                    <?php endif;?>  
                </div>
                <?php printf('<%1$s %2$s>%3$s</%1$s>',
                    tag_escape($settings['title_tag']),
                    $this->get_render_attribute_string('title'),
                    $settings['title']
                ); ?>
            </div>
            <div class="gt-working-stop-item-wrap mt-45">
                <div class="row justify-content-between">
                    <?php foreach($settings['features'] as $item):?>
                    <div class="col-lg-4 wow fadeInLeft"  data-wow-delay="300ms" data-wow-duration="1000ms">
                        <div class="gt-working-stop-item">
                            <div class="item-icon d-flex justify-content-center align-items-center">
                                <?php if ($item['type'] === 'image' && ($item['icon_img']['url'])) :?>
                                    <img src="<?php echo esc_url($item['icon_img']['url']);?>" alt="<?php if(!empty($item['icon_img']['alt'])){ echo esc_attr($item['icon_img']['alt']);}else{esc_attr_e('List', 'goyto-plugin');}?>">
                                <?php else:?>
                                    <?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                <?php endif;?>
                            </div>
                            <div class="item-text headline pera-content">
                                <h3><?php echo wp_kses($item['title'], true);?></h3>
                                <p><?php echo wp_kses($item['description'], true);?></p>
                            </div>
                        </div>
                    </div>
                    <?php endforeach;?>
                </div>
            </div>
        </div>
    </div>
</section>