<?php

class Goyto_Pakps{

    function __construct (){

        add_action( 'admin_enqueue_scripts', [ __CLASS__, 'script' ] );
        add_action( 'admin_footer', [ __CLASS__, 'footer_html' ] );
    }
 
    public static function script($hook){

        if ( 'goyto_page_one-click-demo-import' != $hook ) {
            return;
        }    
        wp_enqueue_script( 'pk-demo-admin', plugins_url('assets/js/active.js', __FILE__));
        wp_enqueue_style( 'pk-demo-admin', plugins_url('assets/css/active.css', __FILE__));

    }

    public static function footer_html(){

        $hook = get_current_screen();
        if ( 'goyto_page_one-click-demo-import' != $hook->base ) {
            return;
        }      
        echo '
            <div class="tx-notice">
                <span class="tx-close">x</span>
                <div class="tx-wrapper">
                    <h3>Please Activate Your license</h3>
                    <p>To import demo, please activate license <a class="button-primary" href="'.admin_url( 'admin.php?page=goyto-license', '' ).'">Click Here</a></p>
                </div>
            <div>    
        ';

    }
}
if ( !get_option("GoytoProver_lic_Key") ){
    new Goyto_Pakps();
}
