<?php
/*
 * Theme Metabox
 * @package goyto-tools
 * @since 1.0.0
 * */

if ( !defined( 'ABSPATH' ) ) {
    exit(); // exit if access directly
}

if ( class_exists( 'CSF' ) ) {

    $prefix = 'goyto';

    /*-------------------------------------
    Page Options
    -------------------------------------*/
    $post_metabox = 'goyto_page_meta';

    CSF::createMetabox( $post_metabox, array(
        'title'     => 'Page Options',
        'post_type' => array('plan', 'page', 'post', 'trip'),
    ) );

    // Header Section
    CSF::createSection( $post_metabox, array(
        'title'  => 'Header',
        'fields' => array(
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Header Option', 'goyto-tools' ),
            ),

            array(
				'id'       => 'meta_header_type',
				'type'     => 'switcher',
				'title'    => __( 'Header Style', 'goyto-plugin' ),
				'text_on'  => __( 'Yes', 'goyto-plugin' ),
				'text_off' => __( 'No', 'goyto-plugin' ),
				'default'  => false
			),
            array(
				'id'          => 'meta_header_style',
				'type'        => 'select',
				'title'       => __('Select Header Style', 'goyto-plugin' ),
				'options'     => goyto_Plugin_Helper::get_header_types(),
                'dependency' => array( 'meta_header_type', '==', 'true' ),
			),
            array(
				'id'       => 'page_header_disable',
				'type'     => 'switcher',
				'title'    => __( 'DIsable This page Header?', 'goyto-plugin' ),
				'text_on'  => __( 'Yes', 'goyto-plugin' ),
				'text_off' => __( 'No', 'goyto-plugin' ),
				'default'  => false
			),
        ),
    ) );

    CSF::createSection( $post_metabox, array(
        'title'  => 'Page Breadcrumb',
        'fields' => array(
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Page Breadcrumb', 'goyto-tools' ),
            ),
            array(
				'id'       => 'enable_page_preadcrumb',
				'type'     => 'switcher',
				'title'    => __( 'Page Breadcrumb', 'goyto-plugin' ),
				'text_on'  => __( 'Yes', 'goyto-plugin' ),
				'text_off' => __( 'No', 'goyto-plugin' ),
				'default'  => true
			),
            array(
				'id'       => 'hide_bg_img',
				'type'     => 'switcher',
				'title'    => __( 'Hide Breadcrumb Page Image', 'goyto-plugin' ),
				'text_on'  => __( 'Yes', 'goyto-plugin' ),
				'text_off' => __( 'No', 'goyto-plugin' ),
				'default'  => true
			),
            array(
                'id'    => 'bg_img_from_page',
                'type'  => 'media',
                'title' => esc_html__( 'Page Breadcrumb Background Image', 'goyto-tools' ),
                'dependency' => array( 'enable_page_preadcrumb', '==', 'true' ),
                
            ),
            array(
				'id'       => 'enable_custom_title',
				'type'     => 'switcher',
				'title'    => __( 'Enable Page Custom Title', 'goyto-plugin' ),
				'text_on'  => __( 'Yes', 'goyto-plugin' ),
				'text_off' => __( 'No', 'goyto-plugin' ),
				'default'  => false
			),
            
            array(
                'id'    => 'page_custom_title',
                'type'  => 'text',
                'title' => esc_html__( 'Page Custom Title', 'goyto-tools' ),
                'dependency' => array( 'enable_custom_title', '==', 'true' ),
            ),
            
        )
    ) );

    CSF::createSection( $post_metabox, array(
        'title'  => 'Page Style',
        'fields' => array(
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Page Style', 'goyto-tools' ),
            ),
            array(
                'id'     => 'scroll-bar',
                'type'   => 'color',
                'title'  => 'Page Scroll Bar Color',
                'output'      => 'body::-webkit-scrollbar-thumb',
                'output_mode' => 'background',
            ),
            array(
                'id'     => 'scroll-up',
                'type'   => 'color',
                'title'  => 'Page Scroll UP BUtton Color',
                'output'      => '.scroll-top',
                'output_mode' => 'background',
            ),
            array(
                'id'      => 'enable_boxed_layout',
                'type'    => 'switcher',
                'title'   => 'Enable Boxed Layout',
                'label'   => 'Do you want Enable Boxed Layout ?',
                'default' => false
            ),
            array(
                'id'    => 'box_bg_image',
                'type'  => 'media',
                'title' => 'Media',
                'dependency' => array( 'enable_boxed_layout', '==', 'true' ),
            ),
            
        )
    ) );
    

    // Header Section
    CSF::createSection( $post_metabox, array(
        'title'  => 'Footer',
        'fields' => array(
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Footer Option', 'goyto-tools' ),
            ),

            array(
				'id'       => 'meta_footer_type',
				'type'     => 'switcher',
				'title'    => __( 'Footer Style', 'goyto-plugin' ),
				'text_on'  => __( 'Yes', 'goyto-plugin' ),
				'text_off' => __( 'No', 'goyto-plugin' ),
				'default'  => false
			),
            array(
				'id'          => 'meta_footer_style',
				'type'        => 'select',
				'title'       => __('Select Footer Style', 'goyto-plugin' ),
				'options'     => goyto_Plugin_Helper::get_footer_types(),
                'dependency' => array( 'meta_footer_type', '==', 'true' ),
			),
            array(
				'id'       => 'page_footer_disable',
				'type'     => 'switcher',
				'title'    => __( 'DIsable This page Footer?', 'goyto-plugin' ),
				'text_on'  => __( 'Yes', 'goyto-plugin' ),
				'text_off' => __( 'No', 'goyto-plugin' ),
				'default'  => false
			),

        ),
    ) );

     /*-------------------------------------
    Page Options
    -------------------------------------*/
    $post_metabox = 'goyto_pricing_meta';

    CSF::createMetabox( $post_metabox, array(
        'title'     => 'Pricing Options',
        'post_type' => 'goyto_pricing',
    ) );

    // Header Section
    CSF::createSection( $post_metabox, array(
        'title'  => 'goyto Pricing Table ',
        'fields' => array(
            array(
                'id'      => 'populer_item',
                'type'    => 'checkbox',
                'title'   => 'Select Populer Item',
                'label'   => 'If you want to Populer Item then please check the box',
                'default' => false // or false
            ),
            array(
                'id'    => 'offer_text',
                'type'  => 'text',
                'title' => esc_html__( 'Offer Text', 'goyto-tools' ),
            ),
            array(
                'id'    => 'currency',
                'type'  => 'text',
                'title' => esc_html__( 'Currency', 'goyto-tools' ),
                'default' => '$',
            ),
            array(
                'id'    => 'monthly_price',
                'type'  => 'text',
                'title' => esc_html__( 'Monthly Price ', 'goyto-tools' ),
            ),
            array(
                'id'    => 'yearly_price',
                'type'  => 'text',
                'title' => esc_html__( 'Yearly Price ', 'goyto-tools' ),
            ),
            array(
                'id'    => 'mon_period',
                'type'  => 'text',
                'title' => esc_html__( 'Monthly Period ', 'goyto-tools' ),
                'default' => esc_html__( '/ Monthly', 'goyto-tools' ),
            ),
            array(
                'id'    => 'yr_period',
                'type'  => 'text',
                'title' => esc_html__( 'Yearly Period ', 'goyto-tools' ),
                'default' => esc_html__( '/ Yearly', 'goyto-tools' ),
            ),
            array(
                'id'         => 'pricing_lists',
                'type'       => 'group',
                'title'      => 'Add Pricing List Item',
                'fields'     => array(
                    
                    array(
                        'id'    => 'list-item',
                        'type'  => 'text',
                        'title' => esc_html__( 'Pricing List Item', 'goyto-tools' ),
                    ),
                    array(
                        'id'      => 'exclude-in-package',
                        'title'   => esc_html__( 'Exclude In This Package', 'goyto-tools' ),
                        'type'    => 'switcher',
                        'default' => false,
                    ),
                )

            ),
            array(
                'id'    => 'pricing_btn',
                'type'  => 'link',
                'title' => esc_html__( 'Pricing Button', 'goyto-tools' ),
            ),
            array(
                'id'    => 'pricing_txt',
                'type'  => 'text',
                'title' => esc_html__( 'Pricing Text', 'goyto-tools' ),
            ),

        ),
    ) );

    /*-------------------------------------
    Page Options
    -------------------------------------*/
    $post_metabox = 'goyto_career_meta';

    CSF::createMetabox( $post_metabox, array(
        'title'     => 'Career Options',
        'post_type' => 'goyto_career',
    ) );

    // Header Section
    CSF::createSection( $post_metabox, array(
        'fields' => array(
            
            array(
                'id'    => 'icon',
                'type'  => 'icon',
                'title' => esc_html__( 'Job Icon', 'goyto-tools' ),
            ),
           
            array(
                'id'    => 'job_type',
                'type'  => 'text',
                'title' => esc_html__( 'Job Type', 'goyto-tools' ),
                'desc' => esc_html__( 'Job Type Means Full Time Job or Part Time Job', 'goyto-tools' ),
            ),
            array(
                'id'    => 'job_location',
                'type'  => 'text',
                'title' => esc_html__( 'Job Location', 'goyto-tools' ),
                'desc' => esc_html__( 'Type Yor Job Location', 'goyto-tools' ),
            ),
            array(
                'id'    => 'job_date',
                'type'  => 'date',
                'title' => esc_html__( 'Job Date', 'goyto-tools' ),
                'desc' => esc_html__( 'Type Yor Job Ending Date Here', 'goyto-tools' ),
            ),
            array(
                'id'    => 'job_salary',
                'type'  => 'text',
                'title' => esc_html__( 'Job Salary', 'goyto-tools' ),
                'desc' => esc_html__( 'Type Yor Job Salary Range Here', 'goyto-tools' ),
            ),
            array(
                'id'    => 'job_excerpt',
                'type'  => 'textarea',
                'title' => esc_html__( 'Job Excerpt', 'goyto-tools' ),
                'desc' => esc_html__( 'Type Yor Job Short Description Here', 'goyto-tools' ),
            ),
        ),
    ) );
    /*-------------------------------------
    Page Options
    -------------------------------------*/
    $post_metabox = 'goyto_trip_meta';

    CSF::createMetabox( $post_metabox, array(
        'title'     => 'Trip Info Options',
        'post_type' => 'trip',
    ) );

    // Header Section
    CSF::createSection( $post_metabox, array(
        'fields' => array(
            array(
                'id'     => 'trips_infos',
                'type'   => 'repeater',
                'title'  => 'Repeater',
                'fields' => array(
                
                    array(
                        'id'    => 'info_title',
                        'type'  => 'textarea',
                        'title' => esc_html__( 'Title', 'goyto-tools' ),
                    ),
                    array(
                        'id'    => 'info_info',
                        'type'  => 'textarea',
                        'title' => esc_html__( 'Info', 'goyto-tools' ),
                    ),
                    
                    array(
                        'id'    => 'image',
                        'type'  => 'media',
                        'title' => esc_html__( 'Upload Image', 'goyto-tools' ),
                    ),
                
                ),
            ),
            
        ),
    ) );



    /*-------------------------------------
    Page Options
    -------------------------------------*/
    $goyto_temp_meta = 'goyto_temp_meta';

    CSF::createMetabox( $goyto_temp_meta, array(
        'title'     => 'Template Type',
        'post_type' => array('goyto_template'),
        'data_type' => 'unserialize'
    ) );

     // Header Section
     CSF::createSection( $goyto_temp_meta, array(
        'fields' => array(
            array(
                'id'          => 'goyto_template_type',
                'type'        => 'select',
                'title'       => 'Select Template Type',
                'placeholder' => 'Select Template Type',
                'options'     => array(
                  'tf_header_key'  => 'Header',
                  'tf_footer_key'  => 'Footer',
                ),
                'default'     => ''
            ),
        ),
    ) );


    /*-------------------------------------
    Portfolio Options
    -------------------------------------*/
    $goyto_port_meta = 'goyto_portfolio_meta';

    CSF::createMetabox( $goyto_port_meta, array(
        'title'     => 'Portfolio Option',
        'post_type' => array('goyto_portfolio'),
    ) );

     // Header Section
     CSF::createSection( $goyto_port_meta, array(
        'fields' => array(
            array(
                'id'          => 'port-column',
                'type'        => 'select',
                'title'       => 'Select Portfolio Column',
                'options'     => array(
                  '12'  => 'Full Column',
                  '6'   => 'Two Column',
                  '3'   => 'Four Column',
                  '4'   => 'Three Column',
                ),
                'default'     => '12'
            ),
            array(
                'id'    => 'cl_no',
                'type'  => 'text',
                'title' => esc_html__( 'Job Salary', 'goyto-tools' ),
                'desc' => esc_html__( 'Type Yor Job Salary Range Here', 'goyto-tools' ),
            ),
        ),
    ) );

    

} //endif
