<?php
/*
 * Theme Options
 * @package goyto
 * @since 1.0.0
 * */

if ( !defined( 'ABSPATH' ) ) {
    exit(); // exit if access directly
}

if ( class_exists( 'CSF' ) ) {

    //
    // Set a unique slug-like ID
    $prefix = 'goyto';

    //
    // Create options
    CSF::createOptions( $prefix . '_theme_options', array(
        'menu_title'         => 'goyto Option',
        'menu_slug'          => 'goyto-theme-option',
        'menu_type'          => 'menu',
        'enqueue_webfont'    => true,
        'show_in_customizer' => true,
        'menu_icon' => 'dashicons-category',
        'menu_position' => 50,
        'theme'                   => 'dark',
        'framework_title'    => wp_kses_post( 'Haptic Options <small>by Raziul <br/> Version: 1.0</small> ' ),
        'footer_text'    => wp_kses_post( 'The Theme will Created By Themexriver ' ),
    ) );

    // Create a top-tab
    CSF::createSection( $prefix . '_theme_options', array(
        'id'    => 'header_opts', // Set a unique slug-like ID
        'title' => 'Header',
    ) );


    /*-------------------------------------------------------
     ** Logo Settings  Options
    --------------------------------------------------------*/

    /*-------------------------------------------------------
     ** Header  Options
    --------------------------------------------------------*/

    CSF::createSection( $prefix . '_theme_options', array(
        'title'  => 'General Settings',
        'id'     => 'general_settings',
        'icon'   => 'fa fa-refresh',
        'fields' => array(

            array(
                'id'      => 'preloader_enable',
                'title'   => esc_html__( 'Enable Preloader', 'goyto-tools' ),
                'type'    => 'switcher',
                'desc'    => esc_html__( 'Enable or Disable Preloader', 'goyto-tools' ),
                'default' => true,
            ),

            array(
                'id'      => 'goyto_custom_preloader',
                'title'   => esc_html__( 'Upload Custom Preloader Logo', 'goyto-tools' ),
                'type'    => 'media',
                'desc'    => esc_html__( 'If you Want to Upload Svg or png logo for preloader? them at first remove preloader logo text and then upload logo here', 'goyto-tools' ),
                'dependency' => array(
                    'preloader_enable', '==', 'true',
                ),
            ),
            array(
                'id'      => 'scroll_up_btn',
                'title'   => esc_html__( 'Scroll Up HIDE/SHOW', 'goyto-tools' ),
                'type'    => 'switcher',
                'desc'    => esc_html__( 'Enable or Disable Scroll Up Button', 'goyto-tools' ),
                'default' => true,
            ),

        ),
    ) );

    CSF::createSection( $prefix . '_theme_options', array(
        'title'  => esc_html__( 'Header', 'goyto-tools' ),
        'parent'     => 'header_opts',
        'icon'   => 'fa fa-header',
        'fields' => array(
            array(
                'type'    => 'subheading',
                'content' => '<h3>' . esc_html__( 'Header Layout', 'goyto-tools' ) . '</h3>',
            ),

            array(
                'id'          => 'header_style',
                'type'        => 'select',
                'title'       => __('Select Header Style', 'goyto-tools' ),
                'options'     => goyto_Plugin_Helper::get_header_types(),
            ),
            array(
                'id'      => 'goyto_logo',
                'title'   => esc_html__( 'Default Logo', 'goyto-tools' ),
                'type'    => 'media',
                'desc'    => esc_html__( 'Upload Logo', 'goyto-tools' ),
                'default' => true,
            ),

        ),
    ) );


    /*-------------------------------------
     ** Typography Options
    -------------------------------------*/
    CSF::createSection( $prefix . '_theme_options', array(
        'title'  => esc_html__( 'Typography', 'goyto-tools' ),
        'id'     => 'typography_options',
        'icon'   => 'fa fa-font',
        'fields' => array(

            array(
                'type'    => 'subheading',
                'content' => '<h3>' . esc_html__( 'Body', 'goyto-tools' ) . '</h3>',
            ),

            array(
                'id'     => 'body-typography',
                'type'   => 'typography',
                'output' => 'body',

            ),

            array(
                'type'    => 'subheading',
                'content' => '<h3>' . esc_html__( 'Heading', 'goyto-tools' ) . '</h3>',
            ),

            array(
                'id'     => 'heading-gl-typo',
                'type'   => 'typography',
                'output' => 'h1, h2, h3, h4, h5, h6',
            ),

        ),
    ) );

    // Product
    CSF::createSection( $prefix . '_theme_options', array(
        'title'  => esc_html__( 'Woocommerce Option', 'goyto-tools' ),
        'id'     => 'woo_option',
        'icon'   => 'fa fa-header',
        'fields' => array(
            array(
                'type'    => 'subheading',
                'content' => '<h3>' . esc_html__( 'Woocommerce Option', 'goyto-tools' ) . '</h3>',
            ),

            array(
                'id'      => 'product_count',
                'title'   => esc_html__( 'Product Count', 'goyto-tools' ),
                'type'    => 'text',
                'default' => '12',
            ),
            array(
				'id'       => 'enable_shop_preadcrumb',
				'type'     => 'switcher',
				'title'    => __( 'Page Breadcrumb', 'goyto-plugin' ),
				'text_on'  => __( 'Yes', 'goyto-plugin' ),
				'text_off' => __( 'No', 'goyto-plugin' ),
				'default'  => true
			),
            array(
                'id'      => 'shop_breadcrumb_bg',
                'title'   => esc_html__( 'Shop Breadcrumb BG', 'goyto-tools' ),
                'type'    => 'media',
                'dependency' => array( 'enable_shop_preadcrumb', '==', 'true' ),
            ),
            array(
                'id'      => 'shop_breadcrumb_title',
                'title'   => esc_html__( 'Shop Breadcrumb Title', 'goyto-tools' ),
                'type'    => 'text',
                'dependency' => array( 'enable_shop_preadcrumb', '==', 'true' ),
            ),
            array(
				'id'       => 'enable_single_product_preadcrumb',
				'type'     => 'switcher',
				'title'    => __( 'Shop Enable Breadcrumb', 'goyto-plugin' ),
				'text_on'  => __( 'Yes', 'goyto-plugin' ),
				'text_off' => __( 'No', 'goyto-plugin' ),
				'default'  => true
			),
            array(
                'id'      => 'product_single_breadcrumb_bg',
                'title'   => esc_html__( 'Product Single Breadcrumb BG', 'goyto-tools' ),
                'type'    => 'media',
                'dependency' => array( 'enable_single_product_preadcrumb', '==', 'true' ),
            ),
            array(
                'id'      => 'product_single_breadcrumb_title',
                'title'   => esc_html__( 'Shop Breadcrumb Title', 'goyto-tools' ),
                'type'    => 'text',
                'dependency' => array( 'enable_single_product_preadcrumb', '==', 'true' ),
            ),

        ),
    ) );

    // blog optoins
    CSF::createSection( $prefix . '_theme_options', array(
        'title'  => esc_html__( 'Breadcrumb', 'goyto-tools' ),
        'id'     => 'blog_page',
        'icon'   => 'fa fa-rss-square',
        'fields' => array(
            array(
                'id'      => 'breadcrumb_bg_img',
                'type'    => 'media',
                'title'   => esc_html__('Breadcrumb BG', 'goyto-tools'),
            ),
        ),
    ) );

    // blog optoins
    CSF::createSection( $prefix . '_theme_options', array(
        'title'  => esc_html__( 'Blog', 'goyto-tools' ),
        'id'     => 'blog_page',
        'icon'   => 'fa fa-rss-square',
        'fields' => array(

            array(
                'type'    => 'subheading',
                'content' => '<h3>' . esc_html__( 'Blog Options', 'goyto-tools' ) . '</h3>',
            ),

            array(
                'id'      => 'br_custom_title',
                'type'    => 'text',
                'title'   => esc_html__('Blog Breadcrumb Title', 'goyto-tools'),
                'desc'    => esc_html__('If you Do not Blog Breadcrumb Custom Title then type Title Here', 'goyto-tools'),
            ),
            array(
                'id'      => 'breadcrumb_bg',
                'type'    => 'media',
                'title'   => esc_html__('Breadcrumb BG', 'goyto-tools'),
            ),

            array(
                'id'      => 'blog_btn_text',
                'type'    => 'text',
                'title'   => esc_html__( 'Blog Read More Button', 'goyto-tools' ),
                'default' => esc_html__( 'Explore More', 'goyto-tools' ),
                'desc'    => esc_html__( 'Type Blog Read More Button Text Here', 'goyto-tools' ),
            ),
        ),
    ) );


   // goyto Color Setting
   CSF::createSection( $prefix . '_theme_options', array(
    'title'  => 'Color Control',
    'id'     => 'apix_color_control',
    'icon'   => 'fa fa-paint-brush',
    'fields' => array(


        array(  //nav bar one start
            'type'    => 'subheading',
            'content' => '<h3>' . esc_html__( 'Theme Primary Color', 'goyto-tools' ) . '</h3>',
        ),
        array(
            'id'    => 'theme-color-1',
            'type'  => 'color',
            'title' => 'Theme Primary Color',
            'default' => '#5b00f0'
        ),

        array(
            'id'    => 'theme-color-2',
            'type'  => 'color',
            'title' => 'Theme Primary Color 2',
            'default' => '#4400E7'
        ),

        array(
            'id'    => 'theme-color-3',
            'type'  => 'color',
            'title' => 'Theme Primary Color 3',
            'default' => '#EB662B'
        ),

        array(
            'id'        => '--gradient1',
            'type'      => 'color_group',
            'title'     => 'Gradient Color One',
            'options'   => array(
              'color-1' => 'Color 1',
              'color-2' => 'Color 2',
            ),
            'default'   => array(
                'color-1' => '#4300e7',
                'color-2' => '#7d00fc',
            )
        ),

        array(
            'id'        => '--gradient2',
            'type'      => 'color_group',
            'title'     => 'Gradient Color Two',
            'options'   => array(
              'color-1' => 'Color 1',
              'color-2' => 'Color 2',
            ),
            'default'   => array(
                'color-1' => '#4d00eb',
                'color-2' => '#193549',
            )
        ),


    ),
) );

    // Create a section
    CSF::createSection( $prefix . '_theme_options', array(
        'title'  => 'Error Page',
        'id'     => 'error_page',
        'icon'   => 'fa fa-exclamation-triangle',
        'fields' => array(


            array(  //nav bar one start
                'type'    => 'subheading',
                'content' => '<h3>' . esc_html__( '404 Page Options', 'goyto-tools' ) . '</h3>',
            ),

            array(
                'id'      => 'error_code',
                'type'    => 'media',
                'title'   => esc_html__( 'Error Code Image', 'goyto-tools' ),
            ),
            array(
                'id'      => 'error_title',
                'type'    => 'text',
                'title'   => esc_html__( '404 Title', 'goyto-tools' ),
                'default' => esc_html__( 'Oops! Page Not found.', 'goyto-tools' ),
            ),

            array(
                'id'      => 'error_button',
                'type'    => 'text',
                'title'   => esc_html__( '404 Button', 'goyto-tools' ),
                'default' => esc_html__( 'back to Home page ', 'goyto-tools' ),
            )


        ),
    ) );

    /*-------------------------------------------------------
     ** Footer  Options
    --------------------------------------------------------*/

    CSF::createSection( $prefix . '_theme_options', array(
        'title'  => esc_html__( 'Footer Options', 'goyto-tools' ),
        'icon'   => 'fa fa-copyright',
        'fields' => array(

            array(
                'id'          => 'footer_style',
                'type'        => 'select',
                'title'       => __('Select Footer Style', 'goyto-tools' ),
                'options'     => goyto_Plugin_Helper::get_footer_types(),
            ),
            array(
                'id'    => 'footer_copyright',
                'type'  => 'wp_editor',
                'title' => 'Default Footer Copyright',
                'default' => '© 2023 goyto - IT Services. All rights reserved.',
            ),

        ),
    ) );

    // Backup section
    CSF::createSection( $prefix . '_theme_options', array(
        'title'  => esc_html__( 'Backup Export', 'goyto-tools' ),
        'id'     => 'backup_options',
        'icon'   => 'fa fa-window-restore',
        'fields' => array(
            array(
                'type' => 'backup',
            ),
        ),
    ) );




}