<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package goyto
 */

get_header();
$error_code = cs_get_option('error_code');
$error_title = cs_get_option('error_title');
$error_button = cs_get_option('error_button');
?>
<div class="erorr-page-area pt-120 pb-120">
	<div class="container">
		<div class="row">
			<div class="col-12">
				<div class="erorr-page-content text-center">
					<div class="img wow fadeIn" data-wow-delay=".3s">
						<img src="<?php if (!empty($error_code['url'])) {
							echo esc_url($error_code['url']);
						} else {
							echo esc_url(get_template_directory_uri() . '/assets/img/404.svg');
						} ?>"
							alt="<?php esc_attr_e('404', 'goyto'); ?>" />
					</div>
					<h4 class="wow" data-splitting="">
						<?php if (!empty($error_title)) {
							echo esc_html($error_title);
						} else {
							esc_html_e('Oops! Page Not found.', 'goyto');
						} ?>
					</h4>
					<a href="<?php echo esc_url(home_url('/')); ?>" class="gtb-pr-btn-1">
						<?php if (!empty($error_button)) {
							echo esc_html($error_button);
						} else {
							esc_html_e('Go Back Home', 'goyto');
						} ?>
					<span class="icon"> <i class="fas icon-1 fa-long-arrow-alt-right"></i></span></a>
				</div>
			</div>
		</div>
	</div>
</div>


<?php
get_footer();
