<?php
/**
 * goyto functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package goyto
 */

define('GOYTO_THEME_DRI', get_template_directory());
define('GOYTO_INC_DRI', get_template_directory() . '/inc/');
define('GOYTO_THEME_URI', get_template_directory_uri());
define('GOYTO_CSS_PATH', GOYTO_THEME_URI . '/assets/css');
define('GOYTO_JS_PATH', GOYTO_THEME_URI . '/assets/js');
define('GOYTO_IMG_PATH', GOYTO_THEME_URI . '/assets/images');
define('GOYTO_ADMIN_DRI', GOYTO_THEME_DRI . '/admin');

/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function goyto_setup(){
	/*
	 * Make theme available for translation.
	 * Translations can be filed in the /languages/ directory.
	 * If you're building a theme based on goyto, use a find and replace
	 * to change 'goyto' to the name of your theme in all the template files.
	 */
	load_theme_textdomain('goyto', get_template_directory() . '/languages');

	// Add default posts and comments RSS feed links to head.
	add_theme_support('automatic-feed-links');
	add_image_size('goyto-img-size-1', 390, 398, true);
	add_image_size('goyto-img-size-2', 398, 317, true);
	add_image_size('goyto-img-size-3', 396, 295, true);
	add_image_size('goyto-img-size-4', 620, 377, true);
	add_image_size('goyto-img-size-5', 410, 490, true);
	add_image_size('goyto-img-size-6', 350, 244, true);
	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support('title-tag');
	remove_theme_support('widgets-block-editor');

	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
	 */
	add_theme_support('post-thumbnails');

	//Woocommerc
	add_theme_support('woocommerce');
	add_theme_support('wc-product-gallery-lightbox');
	add_theme_support('wc-product-gallery-slider');

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus(
		array(
			'menu-1' => esc_html__('Primary', 'goyto'),
		)
	);

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support(
		'html5',
		array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
			'style',
			'script',
		)
	);

	// Set up the WordPress core custom background feature.
	add_theme_support(
		'custom-background',
		apply_filters(
			'goyto_custom_background_args',
			array(
				'default-color' => 'ffffff',
				'default-image' => '',
			)
		)
	);

	// Add theme support for selective refresh for widgets.
	add_theme_support('customize-selective-refresh-widgets');

	/**
	 * Add support for core custom logo.
	 *
	 * @link https://codex.wordpress.org/Theme_Logo
	 */
	add_theme_support(
		'custom-logo',
		array(
			'height' => 250,
			'width' => 250,
			'flex-width' => true,
			'flex-height' => true,
		)
	);
}
add_action('after_setup_theme', 'goyto_setup');

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function goyto_content_width(){
	$GLOBALS['content_width'] = apply_filters('goyto_content_width', 640);
}
add_action('after_setup_theme', 'goyto_content_width', 0);

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function goyto_widgets_init(){
	register_sidebar(
		array(
			'name' => esc_html__('Sidebar', 'goyto'),
			'id' => 'sidebar-1',
			'description' => esc_html__('Add widgets here.', 'goyto'),
			'before_widget' => '<div id="%1$s" class="%2$s gt-sidebar-widget headline">',
			'after_widget' => '</div>',
			'before_title' => '<h3 class="widget-title">',
			'after_title' => '</h3>',
		)
	);

}
add_action('widgets_init', 'goyto_widgets_init');



/**
 *Google Font Load
 */
if (!function_exists('goyto_fonts_url')):

	function goyto_fonts_url(){
		$fonts_url = '';
		$font_families = array();
		$subsets = 'latin';
		if ('off' !== _x('on', 'Urbanist: on or off', 'goyto')) {
			$font_families[] = 'Urbanist:100,100i,200,200i,300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i';
		}
		if ('off' !== _x('on', 'Exo 2: on or off', 'goyto')) {
			$font_families[] = 'Exo 2:100,100i,200,200i,300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i';
		}
		if ( 'off' !== _x( 'on', 'Just Another Hand: on or off', 'goyto' ) ) {
			$font_families[] = 'Just Another Hand:400';
		}
		if ( 'off' !== _x( 'on', 'Kings: on or off', 'goyto' ) ) {
			$font_families[] = 'Kings:400';
		}
		if ( 'off' !== _x( 'on', 'Playball: on or off', 'goyto' ) ) {
			$font_families[] = 'Playball:400';
		}
		if ('off' !== _x('on', 'Kufam: on or off', 'goyto')) {
			$font_families[] = 'Kufam:400,400i,500,500i,600,600i,700,700i,800,800i,900,900i';
		}
		if ($font_families) {
			$fonts_url = add_query_arg(
				array(
					'family' => urlencode(implode('|', $font_families)),
					'subset' => urlencode($subsets),
				),
				'https://fonts.googleapis.com/css'
			);
		}

		return esc_url_raw($fonts_url);
	}
endif;


/**
 * Enqueue scripts and styles.
 */
function goyto_scripts(){

	wp_enqueue_style('goyto-google-fonts', goyto_fonts_url(), array(), null);
	wp_enqueue_style( 'jquery-ui' );
	wp_enqueue_style('bootstrap', GOYTO_CSS_PATH . '/bootstrap.min.css');
	wp_enqueue_style('e-animations', GOYTO_CSS_PATH . '/animate.css');
	wp_enqueue_style('animated-slider', GOYTO_CSS_PATH . '/animated-slider.css');
	wp_enqueue_style('flaticon-one', GOYTO_CSS_PATH . '/flaticon.css');
	wp_enqueue_style('goyto-swiper', GOYTO_CSS_PATH . '/swiper.min.css');
	wp_enqueue_style('video', GOYTO_CSS_PATH . '/video.min.css');
	wp_enqueue_style('fontawesome', GOYTO_CSS_PATH . '/fontawesome.min.css');
	wp_enqueue_style('magnific-popup', GOYTO_CSS_PATH . '/magnific-popup.css');
	wp_enqueue_style('nice-select', GOYTO_CSS_PATH . '/nice-select.css');
	wp_enqueue_style('odometer', GOYTO_CSS_PATH . '/odometer.css');
	wp_enqueue_style('goyto-main', GOYTO_CSS_PATH . '/style.css');

	if (class_exists('WooCommerce')) {
		wp_enqueue_style('woocommerce-style', get_template_directory_uri() . '/woocommerce/woocommerce.css');
	}
	$your_curnt_lang = apply_filters('wpml_current_language', NULL);
	if (is_rtl() && $your_curnt_lang != 'en') {
		wp_enqueue_style('goyto-rtl', GOYTO_CSS_PATH . '/rtl.css');
	}

	wp_enqueue_style('goyto-style', get_stylesheet_uri(), array());

	wp_enqueue_script( 'imagesloaded', ['jquery'], false, true );
    wp_enqueue_script( 'jquery-ui-core', ['jquery'], false, true );
    wp_enqueue_script( 'jquery-ui-datepicker', ['jquery'], false, true );
	wp_enqueue_script('bootstrap-bundle', GOYTO_JS_PATH . '/bootstrap.bundle.min.js', array('jquery'), '1.0', true);
	wp_enqueue_script('swiper-bundle', GOYTO_JS_PATH . '/swiper-bundle.min.js', array('jquery'), '1.0', true);
	wp_enqueue_script('wow', GOYTO_JS_PATH . '/wow.min.js', array('jquery'), '1.0', true);
	wp_enqueue_script('appear', GOYTO_JS_PATH . '/appear.js', array('jquery'), '1.0', true);
	wp_enqueue_script('gsap', GOYTO_JS_PATH . '/gsap.min.js', array('jquery'), '1.0', true);
	wp_enqueue_script('daterangepicker', GOYTO_JS_PATH . '/daterangepicker.min.js', array('jquery'), '1.0', true);
	wp_enqueue_script('knob', GOYTO_JS_PATH . '/knob.js', array('jquery'), '1.0', true);
	wp_enqueue_script('nice-select', GOYTO_JS_PATH . '/jquery.nice-select.min.js', array('jquery'), '1.0', true);
	wp_enqueue_script('magnific-popup', GOYTO_JS_PATH . '/jquery.magnific-popup.min.js', array('jquery'), '1.0', true);
	wp_enqueue_script('marquee', GOYTO_JS_PATH . '/jquery.marquee.min.js', array('jquery'), '1.0', true);
	wp_enqueue_script('isotope', GOYTO_JS_PATH . '/isotope.pkgd.min.js', array('jquery'), '1.0', true);
	wp_enqueue_script('YTPlayer', GOYTO_JS_PATH . '/jquery.mb.YTPlayer.min.js', array('jquery'), '1.0', true);
	wp_enqueue_script('inputarrow', GOYTO_JS_PATH . '/jquery.inputarrow.js', array('jquery'), '1.0', true);
	wp_enqueue_script('parallax', GOYTO_JS_PATH . '/parallax.min.js', array('jquery'), '1.0', true);
	wp_enqueue_script('split-type', GOYTO_JS_PATH . '/split-type.min.js', array('jquery'), '1.0', true);
	wp_enqueue_script('ScrollTrigger', GOYTO_JS_PATH . '/ScrollTrigger.min.js', array('jquery'), '1.0', true);
	wp_enqueue_script('counterup', GOYTO_JS_PATH . '/jquery.counterup.min.js', array('jquery'), '1.0', true);
	wp_enqueue_script('waypoints', GOYTO_JS_PATH . '/waypoints.min.js', array('jquery'), '1.0', true);
	wp_enqueue_script('heading', GOYTO_JS_PATH . '/heading.js', array('jquery'), '1.0', true);
	wp_enqueue_script('cssslider', GOYTO_JS_PATH . '/jquery.cssslider.min.js', array('jquery'), '1.0', true);
	wp_enqueue_script('lenis', GOYTO_JS_PATH . '/lenis.min.js', array('jquery'), '1.0', true);
	wp_enqueue_script('SplitText', GOYTO_JS_PATH . '/SplitText.min.js', array('jquery'), '1.0', true);
	wp_enqueue_script('goyto-main', GOYTO_JS_PATH . '/script.js', array('jquery', 'jquery-ui-core'), '1.0', true);
	if (is_rtl() && $your_curnt_lang != 'en') {
		wp_enqueue_script('goyto-main', GOYTO_JS_PATH . '/rtl.js', array('jquery'), '1.0', true);
	}


	if (is_singular() && comments_open() && get_option('thread_comments')) {
		wp_enqueue_script('comment-reply');
	}
}
add_action('wp_enqueue_scripts', 'goyto_scripts');

/**
 * Implement the Custom Header feature.
 */
require GOYTO_THEME_DRI . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require GOYTO_THEME_DRI . '/inc/template-tags.php';

/**
 * Custom template tags for this theme.
 */
require GOYTO_THEME_DRI . '/inc/class-wp-goyto-navwalker.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require GOYTO_THEME_DRI . '/inc/template-functions.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require GOYTO_THEME_DRI . '/inc/goyto-functions.php';

/**
 * Cs Fremwork Config
 */
require GOYTO_THEME_DRI . '/inc/cs-framework-functions.php';

/**
 * Dynamic Style
 */
require GOYTO_THEME_DRI . '/inc/dynamic-style.php';

/**
 * goyto Core Functions
 */
require GOYTO_THEME_DRI . '/inc/goyto-helper-class.php';

/**
 * goyto Core Functions
 */
require GOYTO_THEME_DRI . '/inc/admin/class-admin-dashboard.php';

/**
 * goyto Core Functions
 */
require GOYTO_THEME_DRI . '/inc/admin/demo-import/functions.php';

/**
 * Customizer additions.
 */
require GOYTO_THEME_DRI . '/inc/customizer.php';


/**
 * Initial Breadcrumb
 */
require GOYTO_THEME_DRI . '/inc/breadcrumb-init.php';



/**
 * Load Jetpack compatibility file.
 */
if (defined('JETPACK__VERSION')) {
	require GOYTO_THEME_DRI . '/inc/jetpack.php';
}

/**
 * Remove Action Hook
 */

function goyto_woo_theme_init()
{
	$goyto_exlude_hooks = require GOYTO_THEME_DRI . '/inc/remove_actions.php';
	foreach ($goyto_exlude_hooks as $k => $v) {
		foreach ($v as $value)
			remove_action($k, $value[0], $value[1]);
	}

}
add_action('init', 'goyto_woo_theme_init');
