<?php
include_once(get_template_directory() . '/inc/admin/demo-import/codestar.php');
function goyto_ocdi_import_files()
{
	return array(
		array(
			'import_file_name' => 'Home 1',
			'local_import_file' => trailingslashit(get_template_directory()) . 'inc/admin/demo-import/demo-content/content.xml',
			'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/admin/demo-import/demo-content/widgets.wie',
			'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/admin/demo-import/demo-content/customizer.dat',
			'local_import_json' => array(
				array(
					'file_path' => trailingslashit(get_template_directory()) . 'inc/admin/demo-import/demo-content/codestar.json',
					'option_name' => 'goyto',
				),
			),
			'import_preview_image_url' => get_template_directory_uri() . '/screenshot.jpg',
			'import_notice' => esc_html__('Import process may take 3-10 minutes. If you facing any issues please contact our support.After Import Succesfuly go to Appearance->Menu And Set your Menu', 'goyto'),
			'preview_url' => 'https://themexriver.com/wp/goyto/',
		),
		array(
			'import_file_name' => 'Home 2',
			'local_import_file' => trailingslashit(get_template_directory()) . 'inc/admin/demo-import/demo-content/content.xml',
			'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/admin/demo-import/demo-content/widgets.wie',
			'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/admin/demo-import/demo-content/customizer.dat',
			'local_import_json' => array(
				array(
					'file_path' => trailingslashit(get_template_directory()) . 'inc/admin/demo-import/demo-content/codestar.json',
					'option_name' => 'goyto',
				),
			),
			'import_preview_image_url' => 'https://themexriver.com/wp/goyto/demo/assets/img/demo/demo-3.png',
			'import_notice' => esc_html__('Import process may take 3-10 minutes. If you facing any issues please contact our support.After Import Succesfuly go to Appearance->Menu And Set your Menu', 'ftech'),
			'preview_url' => 'https://themexriver.com/wp/goyto/home-3/',
		),
		array(
			'import_file_name' => 'Home 3',
			'local_import_file' => trailingslashit(get_template_directory()) . 'inc/admin/demo-import/demo-content/content.xml',
			'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/admin/demo-import/demo-content/widgets.wie',
			'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/admin/demo-import/demo-content/customizer.dat',
			'local_import_json' => array(
				array(
					'file_path' => trailingslashit(get_template_directory()) . 'inc/admin/demo-import/demo-content/codestar.json',
					'option_name' => 'goyto',
				),
			),
			'import_preview_image_url' => 'https://themexriver.com/wp/goyto/demo/assets/img/demo/demo-2.png',
			'import_notice' => esc_html__('Import process may take 3-10 minutes. If you facing any issues please contact our support.After Import Succesfuly go to Appearance->Menu And Set your Menu', 'ftech'),
			'preview_url' => 'https://themexriver.com/wp/goyto/home-2/',
		),
		array(
			'import_file_name' => 'Home 4',
			'local_import_file' => trailingslashit(get_template_directory()) . 'inc/admin/demo-import/demo-content/content.xml',
			'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/admin/demo-import/demo-content/widgets.wie',
			'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/admin/demo-import/demo-content/customizer.dat',
			'local_import_json' => array(
				array(
					'file_path' => trailingslashit(get_template_directory()) . 'inc/admin/demo-import/demo-content/codestar.json',
					'option_name' => 'goyto',
				),
			),
			'import_preview_image_url' => 'https://themexriver.com/wp/goyto/demo/assets/img/demo/demo-7.png',
			'import_notice' => esc_html__('Import process may take 3-10 minutes. If you facing any issues please contact our support.After Import Succesfuly go to Appearance->Menu And Set your Menu', 'ftech'),
			'preview_url' => 'https://themexriver.com/wp/goyto/home-7/',
		),
		array(
			'import_file_name' => 'Home 5',
			'local_import_file' => trailingslashit(get_template_directory()) . 'inc/admin/demo-import/demo-content/content.xml',
			'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/admin/demo-import/demo-content/widgets.wie',
			'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/admin/demo-import/demo-content/customizer.dat',
			'local_import_json' => array(
				array(
					'file_path' => trailingslashit(get_template_directory()) . 'inc/admin/demo-import/demo-content/codestar.json',
					'option_name' => 'goyto',
				),
			),
			'import_preview_image_url' => 'https://themexriver.com/wp/goyto/demo/assets/img/demo/demo-6.png',
			'import_notice' => esc_html__('Import process may take 3-10 minutes. If you facing any issues please contact our support.After Import Succesfuly go to Appearance->Menu And Set your Menu', 'ftech'),
			'preview_url' => 'https://themexriver.com/wp/goyto/home-6/',
		),
		array(
			'import_file_name' => 'Home 5',
			'local_import_file' => trailingslashit(get_template_directory()) . 'inc/admin/demo-import/demo-content/content.xml',
			'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/admin/demo-import/demo-content/widgets.wie',
			'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/admin/demo-import/demo-content/customizer.dat',
			'local_import_json' => array(
				array(
					'file_path' => trailingslashit(get_template_directory()) . 'inc/admin/demo-import/demo-content/codestar.json',
					'option_name' => 'goyto',
				),
			),
			'import_preview_image_url' => 'https://themexriver.com/wp/goyto/demo/assets/img/demo/demo-4.png',
			'import_notice' => esc_html__('Import process may take 3-10 minutes. If you facing any issues please contact our support.After Import Succesfuly go to Appearance->Menu And Set your Menu', 'ftech'),
			'preview_url' => 'https://themexriver.com/wp/goyto/home-4/',
		),
		array(
			'import_file_name' => 'Home 7',
			'local_import_file' => trailingslashit(get_template_directory()) . 'inc/admin/demo-import/demo-content/content.xml',
			'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/admin/demo-import/demo-content/widgets.wie',
			'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/admin/demo-import/demo-content/customizer.dat',
			'local_import_json' => array(
				array(
					'file_path' => trailingslashit(get_template_directory()) . 'inc/admin/demo-import/demo-content/codestar.json',
					'option_name' => 'goyto',
				),
			),
			'import_preview_image_url' => 'https://themexriver.com/wp/goyto/demo/assets/img/demo/home-7.png',
			'import_notice' => esc_html__('Import process may take 3-10 minutes. If you facing any issues please contact our support.After Import Succesfuly go to Appearance->Menu And Set your Menu', 'ftech'),
			'preview_url' => 'https://themexriver.com/wp/goyto/home-5/',
		),
		array(
			'import_file_name' => 'Home RTL',
			'local_import_file' => trailingslashit(get_template_directory()) . 'inc/admin/demo-import/demo-content/content-rtl.xml',
			'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/admin/demo-import/demo-content/widgets-rtl.wie',
			'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/admin/demo-import/demo-content/customizer-rtl.dat',
			'local_import_json' => array(
				array(
					'file_path' => trailingslashit(get_template_directory()) . 'inc/admin/demo-import/demo-content/codestar-rtl.json',
					'option_name' => 'goyto',
				),
			),
			'import_preview_image_url' => 'https://themexriver.com/wp/goyto/demo/assets/img/demo/demo-rtl.png',
			'import_notice' => esc_html__('Import process may take 3-10 minutes. If you facing any issues please contact our support.After Import Succesfuly go to Appearance->Menu And Set your Menu', 'ftech'),
			'preview_url' => 'https://themexriver.com/wp/goyto/rtl/',
		),
	);
}
add_filter('pt-ocdi/import_files', 'goyto_ocdi_import_files');

function goyto_ocdi_after_import($selected_import)
{

	if ('Home 1' === $selected_import['import_file_name']) {
		$front_page_id = get_page_by_title('Home');
	} elseif ('Home 2' === $selected_import['import_file_name']) {
		$front_page_id = get_page_by_title('Home 3');
	} elseif ('Home 3' === $selected_import['import_file_name']) {
		$front_page_id = get_page_by_title('Home 2');
	} elseif ('Home 4' === $selected_import['import_file_name']) {
		$front_page_id = get_page_by_title('Home 7');
	} elseif ('Home 5' === $selected_import['import_file_name']) {
		$front_page_id = get_page_by_title('Home 6');
	} elseif ('Home 6' === $selected_import['import_file_name']) {
		$front_page_id = get_page_by_title('Home 4');
	} elseif ('Home 7' === $selected_import['import_file_name']) {
		$front_page_id = get_page_by_title('Home 5');
	}else {
		$front_page_id = get_page_by_title('Home');
	}

	$blog_page_id = get_page_by_title('Blog');

	// Assign goyto menus to their locations where will be display.
	$primary = get_term_by('name', 'Primary', 'nav_menu');

	set_theme_mod(
		'nav_menu_locations',
		array(
			'menu-1' => $primary->term_id,
		)
	);


	update_option('show_on_front', 'page');
	update_option('page_on_front', $front_page_id->ID);
	update_option('page_for_posts', $blog_page_id->ID);
	update_option('elementor_experiment-e_font_icon_svg' , 'inactive');

	if ( class_exists( '\Elementor\Plugin' ) ) {
		global $wpdb;
		$old_url = 'https://themexriver.com/wp/goyto';
		$new_url = get_site_url();
		$escaped_from = str_replace( '/', '\\/', $old_url );
		$escaped_to = str_replace( '/', '\\/', $new_url );
		$meta_value_like = '[%'; // meta_value LIKE '[%' are json formatted

		$rows_affected = $wpdb->query(
			$wpdb->prepare(
				"UPDATE {$wpdb->postmeta} " .
				'SET meta_value = REPLACE(meta_value, %s, %s) ' .
				"WHERE meta_key = '_elementor_data' AND meta_value LIKE %s;",
				$escaped_from,
				$escaped_to,
				$meta_value_like
			)
		);

		if ( false === $rows_affected ) {
			throw new \Exception( 'An error occurred while replacing URL\'s.' );
		}

		// Allow externals to replace-urls, when they have to.
		$rows_affected += (int) apply_filters( 'elementor/tools/replace-urls', 0, $old_url, $new_url );
		
		\Elementor\Plugin::$instance->files_manager->clear_cache();

	}

	
}
add_action('pt-ocdi/after_import', 'goyto_ocdi_after_import');

function goyto_ocdi_before_content_import()
{
	add_filter('wp_import_post_data_processed', 'goyto_ocdi_wp_import_post_data_processed', 99, 2);
}
add_action('pt-ocdi/before_content_import', 'goyto_ocdi_before_content_import', 99);

function goyto_ocdi_wp_import_post_data_processed($postdata, $data)
{
	return wp_slash($postdata);
}

add_filter('pt-ocdi/disable_pt_branding', '__return_true');

add_filter( 'ocdi/importer_options', function() {
	return array(
			'fetch_attachments' => true,
			'aggressive_url_search' => true
		);
} );

function ocdi_plugin_intro_text($default_text)
{

	function xriver_let_to_num($size)
	{
		$l = substr($size, -1);
		$ret = substr($size, 0, -1);
		switch (strtoupper($l)) {
			case 'P':
				$ret *= 1024;
			case 'T':
				$ret *= 1024;
			case 'G':
				$ret *= 1024;
			case 'M':
				$ret *= 1024;
			case 'K':
				$ret *= 1024;
		}
		return $ret;
	}
	$ssl_check = 'https' === substr(get_home_url(), 0, 5);
	$green_mark = '<mark class="green"><span class="dashicons dashicons-yes"></span></mark>';

	$tatheme = wp_get_theme();

	$plugins_counts = (array) get_option('active_plugins', []);

	if (is_multisite()) {
		$network_activated_plugins = array_keys(get_site_option('active_sitewide_plugins', []));
		$plugins_counts = array_merge($plugins_counts, $network_activated_plugins);
	}

	$default_text = '';

	$default_text .= '
	<div class="demo__ip-notice">
<table class="system-status-table">
	<h1>' . esc_html__('Importan Notice: Before demo import please make sure your server meet(green) all required options for installing the theme', 'goyto') . '</h1>
	<p class="error">' . esc_html__('If any of the option is under red mark, please contact your hosting provider and ask them to change it as recommended.', 'goyto') . '</p>
	<tbody>
	<tr>
	<td>' . esc_html__("WP Version", "goyto") . '</td>
	<td>
	' . esc_html($GLOBALS['wp_version']) . '
	<mark class="green">- We recommend using WordPress version 5.1 or above for greater performance and security.</mark></td>
	</tr>
	<tr>
	<td>' . esc_html__("Language", "goyto") . '</td>
	<td>' . get_locale() . '</td>
	</tr>
	<tr>
	<td>' . esc_html__("WP Memory Limit", "goyto") . '</td>
	<td>';

	$memory = xriver_let_to_num(WP_MEMORY_LIMIT);
	if ($memory < 100663296) {
		$default_text .= '
			<mark class="error">' . sprintf(esc_html__('%s - We recommend setting memory to at least 96MB. %s.', "goyto"), size_format($memory), '
				<a href="' . esc_url('//www.wpbeginner.com/wp-tutorials/fix-wordpress-memory-exhausted-error-increase-php-memory/') . '" target="_blank">' . esc_html__('More info', "goyto") . '</a>') . '
			</mark>';
	} else {
		$default_text .= '
			<mark class="green">' . size_format($memory) . '</mark>';
	}

	$default_text .= '
			</td>
		</tr>
		<tr>
			<td>' . esc_html__('PHP Max Input Vars', "goyto") . '</td>
			<td>';

	$max_input = ini_get('max_input_vars');
	if ($max_input < 3000) {
		$default_text .= '
			<mark class="error">' . sprintf(wp_kses(__('%s - We recommend setting PHP max_input_vars to at least 3000. See:
				<a href="%s" target="_blank">Increasing the PHP max vars limit</a>', "goyto"), ['a' => ['href' => [], 'target' => []]]), $max_input, 'https://jannah.helpscoutdocs.com/article/7-how-to-increase-the-php-max-input-vars') . '
			</mark>';
	} else {
		$default_text .= '
			<mark class="green">' . $max_input . '</mark>';
	}

	$default_text .= ' </td>
		</tr>
		<tr>
			<td>' . esc_html__('PHP Version', "goyto") . ' </td>
			<td>';

	$mayo_php = phpversion();
	if (version_compare($mayo_php, '7.2', '<')) {
		$default_text .= sprintf('
			<mark class="error"> %s </mark> - We recommend using PHP version 7.2 or above for greater performance and security.', esc_html($mayo_php), '');
	} else {
		$default_text .= '
			<mark class="green">' . esc_html($mayo_php) . '</mark>';
	}

	$default_text .= ' </td>
		</tr>
		<tr>
			<td>' . esc_html__('Secure Connection(HTTPS)', "goyto") . ' </td>
			<td>' . (esc_attr($ssl_check) ? $green_mark : '<mark class="error">Your site is not using a secure connection (HTTPS).</mark>') . '</td>
		</tr>
		</tbody>
	</table>
	</div> ';

	return $default_text;

}
add_filter('pt-ocdi/plugin_intro_text', 'ocdi_plugin_intro_text');