<?php

/**
 * [goyto_Admin description]
 */
if (!class_exists('goyto_Admin')) {
    class goyto_Admin
    {

        private static $instance = null;

        public static function init()
        {
            if (is_null(self::$instance)) {
                self::$instance = new self();
            }
            return self::$instance;
        }
        public function __construct()
        {
            add_action('init', [$this, 'goyto_tgm_dashboard'], 1);
            add_action('admin_menu', [$this, 'goyto_Admin_dashboard'], 1);
            add_action('admin_menu', [$this, 'goyto_template_dashboard'], 20);
            add_action('ocdi/plugin_page_setup', [$this, 'goyto_import_dsb'], 20);
            add_action('admin_enqueue_scripts', array($this, 'goyto_Admin_enqueue_scripts'));
        }


        public function goyto_Admin_dashboard()
        {
            add_menu_page(
                esc_html__('goyto', 'goyto'),
                esc_html__('goyto', 'goyto'),
                'manage_options',
                'goyto',
                [$this, 'display_goyto_Admin_dashboard'],
                get_template_directory_uri() . '/inc/admin/assets/img/favicon.png',
                2
            );


        }

        public function goyto_template_dashboard()
        {
            add_submenu_page(
                'goyto',
                esc_html__('Templates', 'goyto'),
                esc_html__('Templates', 'goyto'),
                'manage_options',
                'edit.php?post_type=goyto_template',
                false
            );
        }

        /**
         * admin style Add
         */
        public function goyto_Admin_enqueue_scripts()
        {
            wp_enqueue_style('goyto-admin', get_theme_file_uri('inc/admin/assets/css/admin.css'), array(), null, 'all');
        }

        public function display_goyto_Admin_dashboard()
        {
            require_once GOYTO_INC_DRI . 'admin/admin-page.php';
        }

        public function goyto_tgm_dashboard()
        {
            require_once GOYTO_INC_DRI . 'admin/class-tgm-plugin-activation.php';
            require_once GOYTO_INC_DRI . 'admin/plugin-activation.php';
        }

        public function goyto_import_dsb($default)
        {
            $default['parent_slug'] = 'goyto';
            $default['page_title'] = esc_html__('One Click Demo Import', 'goyto');
            $default['menu_title'] = esc_html__('Import Demo Data', 'goyto');
            $default['capability'] = 'import';
            $default['menu_slug'] = 'one-click-demo-import';

            return $default;
        }
    }
    goyto_Admin::init();
}
