<?php

// File Security Check
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

function goyto_theme_options_style() {

    //
    // Enqueueing StyleSheet file
    //
    wp_enqueue_style( 'goyto-theme-custom-style', get_template_directory_uri() . '/assets/css/custom-style.css' );
    $css_output = '';
    $theme_color_1 = cs_get_option( 'theme-color-1' );
    $theme_color_2 = cs_get_option( 'theme-color-2' );
    $theme_color_3 = cs_get_option( 'theme-color-3' );
    $gradient1 = cs_get_option( '--gradient1' );
    $gradient2 = cs_get_option( '--gradient2' );

    if ( !empty( $theme_color_1 ) || !empty( $theme_color_2 ) || !empty( $theme_color_3 ) ) {
        $css_output .= '
        :root {
            --gt-main: ' . esc_attr( $theme_color_1 ) . ';
            --gt-main-2: ' . esc_attr( $theme_color_2 ) . ';
            --gt-base-or: ' . esc_attr( $theme_color_3 ) . ';
        }
        ';
    }

    if ( !empty( $gradient1['color-1'] ) && !empty( $gradient1['color-2'] ) ) {
        $css_output .= '
        :root {
            --gt-gradient-1: linear-gradient( 90deg, ' . esc_attr( $gradient1['color-1'] ) . ' 0%, ' . esc_attr( $gradient1['color-2'] ) . ' 100%);
        }
        ';
    }

    if ( !empty( $gradient2['color-1'] ) && !empty( $gradient2['color-2'] ) ) {
        $css_output .= '
        :root {
            --gt-gradient-2: linear-gradient(to top, ' . esc_attr( $gradient2['color-1'] ) . ' 5%, ' . esc_attr( $gradient2['color-2'] ) . ' 100%);
        }
        ';
    }

    wp_add_inline_style( 'goyto-theme-custom-style', $css_output );

}
add_action( 'wp_enqueue_scripts', 'goyto_theme_options_style' );
