<?php


/**
 * Preloader
 *
 * @return  [type]  [return description]
 */
function goyto_preloader(){
    $preloader_enable = cs_get_option('preloader_enable');
    $goyto_custom_preloader = cs_get_option('goyto_custom_preloader');

    if ($preloader_enable == true):
        ?>
        <div id="preloader">
            <img class="logo" src="<?php
                if (!empty($goyto_custom_preloader['url'])) {
                    echo esc_url($goyto_custom_preloader['url']);
                } else {
                    echo esc_url(get_template_directory_uri()) . "/assets/img/logo.svg";
                }
                ?>" alt="<?php if(!empty($goyto_custom_preloader['alt'])){ echo esc_attr($goyto_custom_preloader['alt']);}else{ esc_attr_e('Preloader', 'goyto');}?>">
                
        </div>
        <?php
    endif;
}

function goyto_scroll_up_btn()
{
    $scroll_up_btn = cs_get_option('scroll_up_btn');

    if ($scroll_up_btn == true):
        ?>
        <div class="up">
            <a href="#" class="scrollup text-center"><i class="fas fa-chevron-up"></i></a>
        </div>
        <?php
    endif;
}



/**
 * goyto Post Loop
 *
 * @return  [type]  [return description]
 */
function goyto_post_loop()
{
    if (have_posts()):

        /* Start the Loop */
        while (have_posts()):
            the_post();

            /*
             * Include the Post-Type-specific template for the content.
             * If you want to override this in a child theme, then include a file
             * called content-___.php (where ___ is the Post Type name) and that will be used instead.
             */
            get_template_part('template-parts/content', get_post_type());

        endwhile; ?>
        <!-- pagination -->
        <div class="next-prev-btn pt-20 wow fadeInUp">
            <?php
            goyto_pagination(
                '
                    <i class="fa fa-angle-double-left"></i>',
                '<i class="fa fa-angle-double-right"></i>',
                '',
                ['class' => '']
            );
            ?>
        </div>



    <?php else:

        get_template_part('template-parts/content', 'none');

    endif;
}

/**
 * Single Post Loop
 *
 * @return  [type]  [return description]
 */
function goyto_single_post_loop()
{
    while (have_posts()):
        the_post();

        get_template_part('template-parts/content', 'single');
    endwhile; // End of the loop.
}

/**
 * Archive Loop
 *
 * @return  [type]  [return description]
 */
function goyto_post_archive_loop()
{
    if (have_posts()):
        /* Start the Loop */
        while (have_posts()):
            the_post();

            /*
             * Include the Post-Type-specific template for the content.
             * If you want to override this in a child theme, then include a file
             * called content-___.php (where ___ is the Post Type name) and that will be used instead.
             */
            get_template_part('template-parts/content', get_post_type());

        endwhile; ?>

        <div class="next-prev-btn pt-20 wow fadeInUp">
            <?php
            goyto_pagination(
                '
                <i class="fa fa-angle-double-left"></i>',
                '<i class="fa fa-angle-double-right"></i>',
                '',
                ['class' => '']
            );
            ?>
        </div>

    <?php else:

        get_template_part('template-parts/content', 'none');

    endif;
}

/**
 * Search Loop
 *
 * @return  [type]  [return description]
 */
function goyto_search_loop()
{
    if (have_posts()):

        /* Start the Loop */
        while (have_posts()):
            the_post();

            /**
             * Run the loop for the search to output the results.
             * If you want to overload this in a child theme then include a file
             * called content-search.php and that will be used instead.
             */
            get_template_part('template-parts/content', 'search');

        endwhile; ?>
        <div class="next-prev-btn pt-20 wow fadeInUp">
            <?php
            goyto_pagination(
                '
                <i class="fa fa-angle-double-left"></i>',
                '<i class="fa fa-angle-double-right"></i>',
                '',
                ['class' => '']
            );
            ?>
        </div>

    <?php else:

        get_template_part('template-parts/content', 'none');

    endif;
}

/**
 * Page Loop
 *
 * @return  [type]  [return description]
 */
function goyto_page_loop()
{
    while (have_posts()):
        the_post();

        get_template_part('template-parts/content', 'page');

        // If comments are open or we have at least one comment, load up the comment template.
        if (comments_open() || get_comments_number()):
            comments_template();
        endif;

    endwhile; // End of the loop.
}
