<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package goyto
 */
add_filter('wpcf7_form_elements', function ($content) {
	$content = preg_replace('/<(span).*?class="\s*(?:.*\s)?wpcf7-form-control-wrap(?:\s[^"]+)?\s*"[^\>]*>(.*)<\/\1>/i', '\2', $content);

	return $content;
});
/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function goyto_body_classes($classes){
	// Adds a class of hfeed to non-singular pages.
	if (!is_singular()) {
		$classes[] = 'hfeed';
	}

	// Adds a class of no-sidebar when there is no sidebar present.
	if (!is_active_sidebar('sidebar-1')) {
		$classes[] = 'no-sidebar';
	}

	return $classes;
}
add_filter('body_class', 'goyto_body_classes');

/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */
function goyto_pingback_header()
{
	if (is_singular() && pings_open()) {
		printf('<link rel="pingback" href="%s">', esc_url(get_bloginfo('pingback_url')));
	}
}
add_action('wp_head', 'goyto_pingback_header');


/**
 * Breadcrumb
 *
 * @return  [type]  [return description]
 */
function goyto_the_breadcrumb()
{
	global $wp_query;
	$queried_object = get_queried_object();
	$breadcrumb = '';
	$delimiter = '';
	$before = '<li class="breadcrumb-item">';
	$after = '</li>';
	if (!is_front_page()) {
		$breadcrumb .= $before . '<a href="' . home_url('/') . '">' . esc_html__('Home', 'goyto') . ' &nbsp;</a>' . $after;
		/** If category or single post */
		if (is_category()) {
			$cat_obj = $wp_query->get_queried_object();
			$this_category = get_category($cat_obj->term_id);
			if ($this_category->parent != 0) {
				$parent_category = get_category($this_category->parent);
				$breadcrumb .= get_category_parents($parent_category, true, $delimiter);
			}
			$breadcrumb .= $before . '<a href="' . get_category_link(get_query_var('cat')) . '">' . single_cat_title('', false) . '</a>' . $after;
		} elseif ($wp_query->is_posts_page) {
			$breadcrumb .= $before . $queried_object->post_title . $after;
		} elseif (is_tax()) {
			$breadcrumb .= $before . '<a href="' . get_term_link($queried_object) . '">' . $queried_object->name . '</a>' . $after;
		} elseif (is_page()) /** If WP pages */{
			global $post;
			if ($post->post_parent) {
				$anc = get_post_ancestors($post->ID);
				foreach ($anc as $ancestor) {
					$breadcrumb .= $before . '<a href="' . get_permalink($ancestor) . '">' . get_the_title($ancestor) . ' &nbsp;</a>' . $after;
				}
				$breadcrumb .= $before . '' . get_the_title($post->ID) . '' . $after;
			} else {
				$breadcrumb .= $before . '' . get_the_title() . '' . $after;
			}
		} elseif (is_singular()) {
			if ($category = wp_get_object_terms(get_the_ID(), array('category', 'location', 'tax_feature'))) {
				if (!is_wp_error($category)) {
					$breadcrumb .= $before . '<a href="' . get_term_link(goyto_set($category, '0')) . '">' . goyto_set(goyto_set($category, '0'), 'name') . '&nbsp;</a>' . $after;
					$breadcrumb .= $before . '' . get_the_title() . '' . $after;
				} else {
					$breadcrumb .= $before . '' . get_the_title() . '' . $after;
				}
			} else {
				$breadcrumb .= $before . '' . get_the_title() . '' . $after;
			}
		} elseif (is_tag()) {
			$breadcrumb .= $before . '<a href="' . get_term_link($queried_object) . '">' . single_tag_title('', false) . '</a>' . $after;
		} /**If tag template*/elseif (is_day()) {
			$breadcrumb .= $before . '<a href="#">' . esc_html__('Archive for ', 'goyto') . get_the_time('F jS, Y') . '</a>' . $after;
		} /** If daily Archives */elseif (is_month()) {
			$breadcrumb .= $before . '<a href="' . get_month_link(get_the_time('Y'), get_the_time('m')) . '">' . __('Archive for ', 'goyto') . get_the_time('F, Y') . '</a>' . $after;
		} /** If montly Archives */elseif (is_year()) {
			$breadcrumb .= $before . '<a href="' . get_year_link(get_the_time('Y')) . '">' . __('Archive for ', 'goyto') . get_the_time('Y') . '</a>' . $after;
		} /** If year Archives */elseif (is_author()) {
			$breadcrumb .= $before . '<a href="' . esc_url(get_author_posts_url(get_the_author_meta("ID"))) . '">' . __('Archive for ', 'goyto') . get_the_author() . '</a>' . $after;
		} /** If author Archives */elseif (is_search()) {
			$breadcrumb .= $before . '' . esc_html__('Search Results for ', 'goyto') . get_search_query() . '' . $after;
		} /** if search template */elseif (is_404()) {
			$breadcrumb .= $before . '' . esc_html__('404 - Not Found', 'goyto') . '' . $after;
			/** if search template */
		} elseif (is_post_type_archive('product')) {
			$shop_page_id = wc_get_page_id('shop');
			if (get_option('page_on_front') !== $shop_page_id) {
				$shop_page = get_post($shop_page_id);
				$_name = wc_get_page_id('shop') ? get_the_title(wc_get_page_id('shop')) : '';
				if (!$_name) {
					$product_post_type = get_post_type_object('product');
					$_name = $product_post_type->labels->singular_name;
				}
				if (is_search()) {
					$breadcrumb .= $before . '<a href="' . get_post_type_archive_link('product') . '">' . $_name . '</a>' . $delimiter . esc_html__('Search results for &ldquo;', 'goyto') . get_search_query() . '&rdquo;' . $after;
				} elseif (is_paged()) {
					$breadcrumb .= $before . '<a href="' . get_post_type_archive_link('product') . '">' . $_name . '</a>' . $after;
				} else {
					$breadcrumb .= $before . $_name . $after;
				}
			}
		} else {
			$breadcrumb .= $before . '<a href="' . get_permalink() . '">' . wp_title() . '</a>' . $after;
		}
		/** Default value */
	}

	return $breadcrumb;
}

function goyto_category_html( $links ) {
    $links = str_replace( '</a> (', '<span class="item-count">', $links );
    $links = str_replace( ')', '</span></a>', $links );
    return $links;
}
add_filter( 'wp_list_categories', 'goyto_category_html' );


function goyto_archive_html($links)
{
	$links = str_replace( '</a> (', '<span>', $links );
    $links = str_replace( ')', '</span></a>', $links );
    return $links;
}

add_filter('get_archives_link', 'goyto_archive_html');


/**
 * Comment Link Class
 *
 * @param [type] $class
 * @return void
 */
function wpdocs_comment_reply_link_class($class)
{
	$class = str_replace("class='comment-reply-link", "class='comment-reply-link reply-btn", $class);
	return $class;
}

add_filter('comment_reply_link', 'wpdocs_comment_reply_link_class');

/**
 * Comment List Modification
 */

function goyto_comments($comment, $args, $depth)
{
	$GLOBALS['comment'] = $comment; ?>

	<li <?php comment_class('comments-box-single wow fadeInUp'); ?> id="comment-<?php comment_ID() ?>">
		<div class="gt-comment-item d-flex flex-wrap position-relative pera-content">
			<?php if (get_avatar($comment)) { ?>
				<div class="gt-comment-img">
					<?php echo get_avatar($comment, 80); ?>
				</div>
			<?php } ?>
			<div class="gt-comment-text">
				<div class="author-name-date">
					<span class="cm-name">
						<?php comment_author_link() ?>
					</span>
					<span class="cm-date">
						<?php echo esc_html(get_the_time(get_option('date_format'))); ?>
					</span>
				</div>
				<div class="comment-text">
					<?php comment_text(); ?>
				</div>
			</div>
			<div class="gt-like-reply position-absolute text-capitalize">
				<?php comment_reply_link(array_merge($args, array('depth' => $depth, 'max_depth' => $args['max_depth'], 'reply_text' => wp_kses('Reply', true)))); ?>
			</div>
		</div>
	</li>

	<?php
}


/**
 * Comment Message Box
 */
function goyto_comment_reform($arg)
{

	$arg['title_reply'] = esc_html__('Leave a comment', 'goyto');
	$arg['comment_field'] = '<textarea id="comment" class="form_control" name="comment" cols="77" rows="3" placeholder="' . esc_attr__("Comment", "goyto") . '" aria-required="true"></textarea>';

	return $arg;

}
add_filter('comment_form_defaults', 'goyto_comment_reform');


/**
 * Comment Form Field
 */
function goyto_modify_comment_form_fields($fields)
{
	$commenter = wp_get_current_commenter();
	$req = get_option('require_name_email');

	$fields['author'] = '<div class="row"><div class="col-lg-6 col-md-6 col-sm-12 form-group"><input type="text" name="author" id="author" value="' . esc_attr($commenter['comment_author']) . '" placeholder="' . esc_attr__("Name", "goyto") . '" size="22" tabindex="1"' . ($req ? 'aria-required="true"' : '') . ' class="form_control" /></div>';

	$fields['email'] = '<div class="col-lg-6 col-md-6 col-sm-12 form-group"><input type="email" name="email" id="email" value="' . esc_attr($commenter['comment_author_email']) . '" placeholder="' . esc_attr__("Email", "goyto") . '" size="22" tabindex="2"' . ($req ? 'aria-required="true"' : '') . ' class="form_control"  /></div>';

	$fields['url'] = '<div class="col-lg-12 col-md-12 col-sm-12 form-group"><input type="url" name="url" id="url" value="' . esc_attr($commenter['comment_author_url']) . '" placeholder="' . esc_attr__("Website", "goyto") . '" size="22" tabindex="2"' . ($req ? 'aria-required="false"' : '') . ' class="form_control"  /></div></div>';

	return $fields;
}
add_filter('comment_form_default_fields', 'goyto_modify_comment_form_fields');

// comment Move Field
function goyto_move_comment_field_to_bottom($fields)
{
	$comment_field = $fields['comment'];
	unset($fields['comment']);
	$fields['comment'] = $comment_field;
	return $fields;
}
add_filter('comment_form_fields', 'goyto_move_comment_field_to_bottom');



/**
 * Product Per Page Count
 *
 * @param [type] $per_page
 * @return void
 */


/**
 * Authore Avater
 */
function goyto_main_author_avatars($size){
	echo get_avatar(get_the_author_meta('email'), $size);
}

add_action('genesis_entry_header', 'goyto_post_author_avatars');




/**
 * pagination
 */
if (!function_exists('goyto_pagination')) {

	function _goyto_pagi_callback($pagination)
	{
		return $pagination;
	}

	//page navegation
	function goyto_pagination($prev, $next, $pages, $args)
	{
		global $wp_query, $wp_rewrite;
		$menu = '';
		$wp_query->query_vars['paged'] > 1 ? $current = $wp_query->query_vars['paged'] : $current = 1;

		if ($pages == '') {
			global $wp_query;
			$pages = $wp_query->max_num_pages;

			if (!$pages) {
				$pages = 1;
			}

		}

		$pagination = [
			'base' => add_query_arg('paged', '%#%'),
			'format' => '',
			'total' => $pages,
			'current' => $current,
			'prev_text' => $prev,
			'next_text' => $next,
			'type' => 'array',
		];

		//rewrite permalinks
		if ($wp_rewrite->using_permalinks()) {
			$pagination['base'] = user_trailingslashit(trailingslashit(remove_query_arg('s', get_pagenum_link(1))) . 'page/%#%/', 'paged');
		}

		if (!empty($wp_query->query_vars['s'])) {
			$pagination['add_args'] = ['s' => get_query_var('s')];
		}

		$pagi = '';
		if (paginate_links($pagination) != '') {
			$paginations = paginate_links($pagination);
			$pagi .= '<div class="ul-li-block mark__pagination"><ul class="styled-pagination text-center d-flex align-items-center justify-content-center mb-0 pl-0">';
			foreach ($paginations as $key => $pg) {
				$pagi .= '<li>' . $pg . '</li>';
			}
			$pagi .= '</ul></div>';
		}

		print _goyto_pagi_callback($pagi);
	}
}


/**
 * Search Widget
 */
function goyto_search_widgets($form)
{
	$form = '<form role="search" method="get" id="searchform" class="search-widget" action="' . home_url('/') . '" >
    <input class="search-input" placeholder="' . esc_attr__('Search...', 'goyto') . '" type="text"  value="' . get_search_query() . '" name="s" id="s" />
		<button type="submit" class="search-btn"><i class="fal fa-search"></i></button>
    </form>';
	return $form;
}
add_filter('get_search_form', 'goyto_search_widgets', 100);


/**
 * Authore
 */
function goyto_authore_info()
{

	global $post;
	if (is_object($post)):

		$theme_author_markup = '';
		// Get author's display name
		$display_name = get_the_author_meta('display_name', $post->post_author);

		// If display name is not available then use nickname as display name
		if (empty($display_name))
			$display_name = get_the_author_meta('nickname', $post->post_author);

		// Get author's biographical information or description
		$user_description = get_the_author_meta('user_description', $post->post_author);

		$user_facebook = get_the_author_meta('facebook', $post->post_author);
		$user_twitter = get_the_author_meta('twitter', $post->post_author);
		$user_linkedin = get_the_author_meta('linkedin', $post->post_author);
		$user_instagram = get_the_author_meta('instagram', $post->post_author);
		$user_pinterest = get_the_author_meta('pinterest', $post->post_author);
		$user_youtube = get_the_author_meta('youtube', $post->post_author);

		// Get link to the author archive page
		$user_posts = get_author_posts_url(get_the_author_meta('ID', $post->post_author));
		if (!empty($display_name))
			// Author avatar - - the number 90 is the px size of the image.
			$theme_author_markup .= '<div class="img-wrap">' . get_avatar(get_the_author_meta('ID'), 140) . '</div>';
		$theme_author_markup .= '<div class="inner-text headline pera-content">';
		$theme_author_markup .= '<span class="name">' . $display_name . '</span>';
		$theme_author_markup .= '<p class="comment-text">' . get_the_author_meta('description') . '</p>';
		$theme_author_markup .= '<ul class="social-link">';


		// Check if author has Twitter in their profile

		if (!empty($user_facebook)) {
			$theme_author_markup .= ' <li><a href="' . $user_facebook . '" target="_blank" rel="nofollow" class="fb_aut" title="Facebook"><i class="fab fa-facebook-f"></i> </a></li>';
		}


		if (!empty($user_twitter)) {
			$theme_author_markup .= '<li> <a href="' . $user_twitter . '" target="_blank" rel="nofollow" class="twi_aut" title="Twitter"><i class="fab fa-twitter"></i> </a></li>';
		}

		if (!empty($user_instagram)) {
			$theme_author_markup .= '<li> <a href="' . $user_instagram . '" target="_blank" rel="nofollow" class="inst_aut" title="Instagram"><i class="fab fa-instagram"></i> </a></li>';
		}

		if (!empty($user_pinterest)) {
			$theme_author_markup .= '<li> <a href="' . $user_pinterest . '" target="_blank" rel="nofollow" class="pint_aut" title="Pinterest"><i class="fab fa-pinterest-p"></i> </a></li>';
		}

		if (!empty($user_youtube)) {
			$theme_author_markup .= '<li> <a href="' . $user_youtube . '" target="_blank" rel="nofollow" class="you_aut" title="Youtube"><i class="fab fa-youtube"></i> </a>';
		}

		if (!empty($user_linkedin)) {
			$theme_author_markup .= '<li> <a href="' . $user_linkedin . '" target="_blank" rel="nofollow" class="link_aut" title="linkedin"><i class="fab fa-linkedin-in"></i> </a></li>';
		}

		$theme_author_markup .= '</ul>';
		$theme_author_markup .= '</div>';

		// Pass all this info to post content 
		echo '<div class="gt-blog-next-prev-item-area mt-30 d-flex flex-wrap justify-content-between">' . $theme_author_markup . '</div>';
	endif;
}
