<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package goyto
 */

get_header();
$goytoPostClass = '';
if (is_active_sidebar('sidebar-1')) {
	$goytoPostClass = 'col-lg-8';
} else {
	$goytoPostClass = 'col-lg-10 offset-lg-1';
}
?>
<section id="gt-blog-list" class="gt-blog-list-section pt-120 pb-120">
	<div class="container">
		<div class="gt-blog-list-content">
			<div class="row">
				<!-- Content Side -->
				<div class="<?php echo esc_attr($goytoPostClass); ?>">
					<div class="gt-blog-list-item-wrap">
						<?php goyto_post_loop(); ?>
					</div>
				</div>
				<!-- Sidebar Side -->
				<?php get_sidebar(); ?>
			</div>
		</div>
	</div>
</section>

<?php
get_footer();
