<?php
/**
 * Template part for displaying single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package goyto
 */
$categories = get_the_category();
?>
<div id="post-<?php the_ID(); ?>" <?php post_class('gt-blog-details-content-wrap'); ?>>

    <?php if (has_post_thumbnail()) { ?>
        <div class="gt-blog-details-thumb-img mb-20">
            <?php the_post_thumbnail('full') ?>
        </div>
    <?php } ?>

    <div class="blog-meta-author mt-20 mb-20 flex-wrap d-flex justify-content-between align-items-center">
        <div class="blog-author d-flex align-items-center">
            <div class="inner-img">
                <?php goyto_main_author_avatars(44); ?>
            </div>
            <div class="inner-text text-uppercase">
                <?php the_author() ?>
            </div>
        </div>
        <div class="blog-meta text-uppercase">
            <a href="#"><i class="fal fa-comments"></i> <?php echo esc_attr(get_comments_number()); ?> <?php esc_html_e('comments', 'goyto'); ?></a>
			<a href="#"><i class="fal fa-calendar-alt"></i> <?php echo date(get_option('date_format')); ?></a>
        </div>
    </div>
    <div class="gt-blog-details-text-wrap headline pera-content">
        <h2><?php the_title();?></h2>
        <?php
        the_content(
            sprintf(
                wp_kses(
                    /* translators: %s: Name of current post. Only visible to screen readers */
                    __('Continue reading<span class="screen-reader-text"> "%s"</span>', 'goyto'),
                    array(
                        'span' => array(
                            'class' => array(),
                        ),
                    )
                ),
                wp_kses_post(get_the_title())
            )
        );

        wp_link_pages(
            array(
                'before' => '<div class="page-links">' . esc_html__('Pages:', 'goyto'),
                'after' => '</div>',
            )
        );
        ?>
    </div>
    <div class="gt-blog-share-tag pt-40 pb-40 flex-wrap d-flex justify-content-between">
        <?php if (function_exists('goyto_entry_footer')): ?>
            <div class="gt-blog-tag d-flex flex-wrap align-items-center">
                <?php goyto_entry_footer();?>
            </div>
        <?php endif;?>
    </div>
    <div class="gt-comment-list-wrap mt-40 ul-li-block headline pera-content">
    <?php if (comments_open() || get_comments_number()):
        comments_template();
    endif;?>
</div>     
</div>